/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.process.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractTokenizer<T>
implements Tokenizer<T> {
    protected T nextToken;

    protected abstract T getNext();

    @Override
    public T next() {
        if (this.nextToken == null) {
            this.nextToken = this.getNext();
        }
        T result = this.nextToken;
        this.nextToken = this.getNext();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        if (this.nextToken == null) {
            this.nextToken = this.getNext();
        }
        return this.nextToken != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        if (this.nextToken == null) {
            this.nextToken = this.getNext();
        }
        if (this.nextToken == null) {
            throw new NoSuchElementException();
        }
        return this.nextToken;
    }

    @Override
    public List<T> tokenize() {
        ArrayList<T> result = new ArrayList<T>();
        while (this.hasNext()) {
            result.add(this.next());
        }
        return result;
    }
}

