/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.GrammarProjection;
import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.util.Numberer;
import java.util.HashMap;
import java.util.Iterator;

class XBarGrammarProjection
implements GrammarProjection {
    UnaryGrammar sourceUG;
    BinaryGrammar sourceBG;
    Numberer sourceNumberer;
    UnaryGrammar targetUG;
    BinaryGrammar targetBG;
    Numberer targetNumberer;
    int[] projection;

    @Override
    public int project(int state) {
        return this.projection[state];
    }

    @Override
    public UnaryGrammar sourceUG() {
        return this.sourceUG;
    }

    @Override
    public BinaryGrammar sourceBG() {
        return this.sourceBG;
    }

    @Override
    public UnaryGrammar targetUG() {
        return this.targetUG;
    }

    @Override
    public BinaryGrammar targetBG() {
        return this.targetBG;
    }

    protected static String projectString(String str) {
        if (str.indexOf(64) == -1) {
            if (str.indexOf(94) == -1) {
                return str;
            }
            return str.substring(0, str.indexOf(94));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(str.substring(0, str.indexOf(32)));
        int num = -2;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            ++num;
        }
        sb.append(" w ").append(num);
        return sb.toString();
    }

    protected void scanStates(Numberer source, Numberer target) {
        for (int i = 0; i < source.total(); ++i) {
            String stateStr = (String)source.object(i);
            String projStr = XBarGrammarProjection.projectString(stateStr);
            this.projection[i] = target.number(projStr);
        }
    }

    protected BinaryRule projectBinaryRule(BinaryRule br) {
        BinaryRule br2 = new BinaryRule();
        br2.parent = this.projection[br.parent];
        br2.leftChild = this.projection[br.leftChild];
        br2.rightChild = this.projection[br.rightChild];
        br2.score = br.score;
        return br2;
    }

    protected UnaryRule projectUnaryRule(UnaryRule ur) {
        UnaryRule ur2 = new UnaryRule();
        ur2.parent = this.projection[ur.parent];
        ur2.child = this.projection[ur.child];
        ur2.score = ur.score;
        return ur2;
    }

    public XBarGrammarProjection(BinaryGrammar bg, UnaryGrammar ug) {
        HashMap<BinaryRule, BinaryRule> binaryRules = new HashMap<BinaryRule, BinaryRule>();
        HashMap<UnaryRule, UnaryRule> unaryRules = new HashMap<UnaryRule, UnaryRule>();
        this.sourceUG = ug;
        this.sourceBG = bg;
        this.sourceNumberer = Numberer.getGlobalNumberer(bg.stateSpace());
        this.targetNumberer = Numberer.getGlobalNumberer(bg.stateSpace() + "-xbar");
        this.projection = new int[this.sourceNumberer.total()];
        this.scanStates(this.sourceNumberer, this.targetNumberer);
        this.targetBG = new BinaryGrammar(this.targetNumberer.total(), bg.stateSpace() + "-xbar");
        this.targetUG = new UnaryGrammar(this.targetNumberer.total());
        for (BinaryRule br : bg) {
            BinaryRule rule = this.projectBinaryRule(br);
            Rule old = (Rule)binaryRules.get(rule);
            if (old != null && !(rule.score > old.score)) continue;
            binaryRules.put(rule, rule);
        }
        for (BinaryRule br : binaryRules.keySet()) {
            this.targetBG.addRule(br);
        }
        this.targetBG.splitRules();
        for (int parent = 0; parent < this.sourceNumberer.total(); ++parent) {
            Iterator<UnaryRule> urI = ug.ruleIteratorByParent(parent);
            while (urI.hasNext()) {
                UnaryRule sourceRule = urI.next();
                UnaryRule rule = this.projectUnaryRule(sourceRule);
                Rule old = (Rule)unaryRules.get(rule);
                if (old != null && !(rule.score > old.score)) continue;
                unaryRules.put(rule, rule);
            }
        }
        for (UnaryRule ur : unaryRules.keySet()) {
            this.targetUG.addRule(ur);
        }
        this.targetUG.purgeRules();
        System.out.println("Projected " + this.sourceNumberer.total() + " states to " + this.targetNumberer.total() + " states.");
    }
}

