/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.util.Numberer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UnaryGrammar
implements Serializable,
Iterable<UnaryRule> {
    private int numStates = -1;
    private String stateSpace;
    private transient List<UnaryRule>[] rulesWithParent;
    private transient List<UnaryRule>[] rulesWithChild;
    private transient List<UnaryRule>[] closedRulesWithParent;
    private transient List<UnaryRule>[] closedRulesWithChild;
    private transient UnaryRule[][] closedRulesWithP;
    private transient UnaryRule[][] closedRulesWithC;
    private Map<UnaryRule, UnaryRule> coreRules;
    private transient Map<UnaryRule, UnaryRule> bestRulesUnderMax;
    private static final UnaryRule[] EMPTY_UNARY_RULE_ARRAY = new UnaryRule[0];
    private static final long serialVersionUID = 1L;

    public int numClosedRules() {
        return this.bestRulesUnderMax.keySet().size();
    }

    public UnaryRule getRule(UnaryRule ur) {
        return this.coreRules.get(ur);
    }

    public Iterator<UnaryRule> closedRuleIterator() {
        return this.bestRulesUnderMax.keySet().iterator();
    }

    public int numRules() {
        return this.coreRules.keySet().size();
    }

    @Override
    public Iterator<UnaryRule> iterator() {
        return this.ruleIterator();
    }

    public Iterator<UnaryRule> ruleIterator() {
        return this.coreRules.keySet().iterator();
    }

    public List<UnaryRule> rules() {
        return new ArrayList<UnaryRule>(this.coreRules.keySet());
    }

    public final void purgeRules() {
        HashMap<UnaryRule, UnaryRule> bR = new HashMap<UnaryRule, UnaryRule>();
        for (UnaryRule ur : this.bestRulesUnderMax.keySet()) {
            if (ur.parent != ur.child) {
                bR.put(ur, ur);
                continue;
            }
            this.closedRulesWithParent[ur.parent].remove(ur);
            this.closedRulesWithChild[ur.child].remove(ur);
        }
        this.bestRulesUnderMax = bR;
    }

    private void closeRulesUnderMax(UnaryRule ur) {
        int isz = this.closedRulesWithChild[ur.parent].size();
        for (int i = 0; i < isz; ++i) {
            UnaryRule pr = this.closedRulesWithChild[ur.parent].get(i);
            int jsz = this.closedRulesWithParent[ur.child].size();
            for (int j = 0; j < jsz; ++j) {
                UnaryRule cr = this.closedRulesWithParent[ur.child].get(j);
                UnaryRule resultR = new UnaryRule(pr.parent, cr.child, pr.score + cr.score + ur.score);
                this.relaxRule(resultR);
            }
        }
    }

    private boolean relaxRule(UnaryRule ur) {
        UnaryRule bestR = this.bestRulesUnderMax.get(ur);
        if (bestR == null) {
            this.bestRulesUnderMax.put(ur, ur);
            this.closedRulesWithParent[ur.parent].add(ur);
            this.closedRulesWithChild[ur.child].add(ur);
            return true;
        }
        if (bestR.score < ur.score) {
            bestR.score = ur.score;
            return true;
        }
        return false;
    }

    public double scoreRule(UnaryRule ur) {
        UnaryRule bestR = this.bestRulesUnderMax.get(ur);
        return bestR != null ? (double)bestR.score : Double.NEGATIVE_INFINITY;
    }

    public final void addRule(UnaryRule ur) {
        this.closeRulesUnderMax(ur);
        this.coreRules.put(ur, ur);
        this.rulesWithParent[ur.parent].add(ur);
        this.rulesWithChild[ur.child].add(ur);
    }

    void makeCRArrays() {
        this.closedRulesWithP = new UnaryRule[this.numStates][];
        this.closedRulesWithC = new UnaryRule[this.numStates][];
        for (int i = 0; i < this.numStates; ++i) {
            this.closedRulesWithP[i] = this.closedRulesWithParent[i].toArray(new UnaryRule[this.closedRulesWithParent[i].size()]);
            this.closedRulesWithC[i] = this.closedRulesWithChild[i].toArray(new UnaryRule[this.closedRulesWithChild[i].size()]);
        }
    }

    public UnaryRule[] closedRulesByParent(int state) {
        if (this.closedRulesWithP == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedRulesWithP.length) {
            return EMPTY_UNARY_RULE_ARRAY;
        }
        return this.closedRulesWithP[state];
    }

    public UnaryRule[] closedRulesByChild(int state) {
        if (this.closedRulesWithC == null) {
            this.makeCRArrays();
        }
        if (state >= this.closedRulesWithC.length) {
            return EMPTY_UNARY_RULE_ARRAY;
        }
        return this.closedRulesWithC[state];
    }

    public Iterator<UnaryRule> closedRuleIteratorByParent(int state) {
        if (state >= this.closedRulesWithParent.length) {
            List lur = Collections.emptyList();
            return lur.iterator();
        }
        return this.closedRulesWithParent[state].iterator();
    }

    public Iterator<UnaryRule> closedRuleIteratorByChild(int state) {
        if (state >= this.closedRulesWithChild.length) {
            List lur = Collections.emptyList();
            return lur.iterator();
        }
        return this.closedRulesWithChild[state].iterator();
    }

    public Iterator<UnaryRule> ruleIteratorByParent(int state) {
        if (state >= this.rulesWithParent.length) {
            List lur = Collections.emptyList();
            return lur.iterator();
        }
        return this.rulesWithParent[state].iterator();
    }

    public Iterator<UnaryRule> ruleIteratorByChild(int state) {
        if (state >= this.rulesWithChild.length) {
            List lur = Collections.emptyList();
            return lur.iterator();
        }
        return this.rulesWithChild[state].iterator();
    }

    public List<UnaryRule> rulesByParent(int state) {
        if (state >= this.rulesWithParent.length) {
            return Collections.emptyList();
        }
        return this.rulesWithParent[state];
    }

    public List<UnaryRule> rulesByChild(int state) {
        if (state >= this.rulesWithChild.length) {
            return Collections.emptyList();
        }
        return this.rulesWithChild[state];
    }

    public List<UnaryRule>[] rulesWithParent() {
        return this.rulesWithParent;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        HashSet<UnaryRule> allRules = new HashSet<UnaryRule>(this.coreRules.keySet());
        this.init();
        for (UnaryRule ur : allRules) {
            this.addRule(ur);
        }
        this.purgeRules();
    }

    private void init() {
        this.coreRules = new HashMap<UnaryRule, UnaryRule>();
        this.rulesWithParent = new List[this.numStates];
        this.rulesWithChild = new List[this.numStates];
        this.closedRulesWithParent = new List[this.numStates];
        this.closedRulesWithChild = new List[this.numStates];
        this.bestRulesUnderMax = new HashMap<UnaryRule, UnaryRule>();
        for (int s = 0; s < this.numStates; ++s) {
            this.rulesWithParent[s] = new ArrayList<UnaryRule>();
            this.rulesWithChild[s] = new ArrayList<UnaryRule>();
            this.closedRulesWithParent[s] = new ArrayList<UnaryRule>();
            this.closedRulesWithChild[s] = new ArrayList<UnaryRule>();
            UnaryRule selfR = new UnaryRule(s, s, 0.0);
            this.relaxRule(selfR);
        }
    }

    public UnaryGrammar(int numStates) {
        this(numStates, "states");
    }

    public UnaryGrammar(int numStates, String stateSpace) {
        this.numStates = numStates;
        this.stateSpace = stateSpace;
        this.init();
    }

    public void readData(BufferedReader in) throws IOException {
        int lineNum = 1;
        Numberer n = Numberer.getGlobalNumberer(this.stateSpace);
        String line = in.readLine();
        while (line != null && line.length() > 0) {
            try {
                this.addRule(new UnaryRule(line, n));
            }
            catch (Exception e) {
                throw new IOException("Error on line " + lineNum);
            }
            ++lineNum;
            line = in.readLine();
        }
        this.purgeRules();
    }

    public void writeData(Writer w) {
        PrintWriter out2 = new PrintWriter(w);
        for (UnaryRule ur : this) {
            out2.println(ur);
        }
        out2.flush();
    }

    public void writeAllData(Writer w) {
        Iterator<UnaryRule> rI;
        int i;
        PrintWriter out2 = new PrintWriter(w);
        out2.println("Unary ruleIterator");
        Iterator<UnaryRule> rI2 = this.ruleIterator();
        while (rI2.hasNext()) {
            out2.println(rI2.next().toString());
        }
        out2.println("Unary closedRuleIterator");
        rI2 = this.closedRuleIterator();
        while (rI2.hasNext()) {
            out2.println(rI2.next().toString());
        }
        Numberer n = Numberer.getGlobalNumberer(this.stateSpace);
        out2.println("Unary rulesWithParentIterator");
        for (i = 0; i < this.numStates; ++i) {
            out2.println(n.object(i));
            rI = this.ruleIteratorByParent(i);
            while (rI.hasNext()) {
                out2.print("  ");
                out2.println(rI.next().toString());
            }
        }
        out2.println("Unary closedRulesWithParentIterator");
        for (i = 0; i < this.numStates; ++i) {
            out2.println(n.object(i));
            rI = this.closedRuleIteratorByParent(i);
            while (rI.hasNext()) {
                out2.print("  ");
                out2.println(rI.next().toString());
            }
        }
        out2.flush();
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.writeData(w);
        return ((Object)w).toString();
    }
}

