/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.ArrayList;

class TreeCollinizer
implements TreeTransformer {
    private TreebankLanguagePack tlp;
    private final boolean deletePunct;
    private final boolean fixCollinsBaseNP;
    protected TreeFactory tf = new LabeledScoredTreeFactory();

    public TreeCollinizer(TreebankLanguagePack tlp) {
        this(tlp, true, false);
    }

    public TreeCollinizer(TreebankLanguagePack tlp, boolean deletePunct, boolean fixCollinsBaseNP) {
        this.tlp = tlp;
        this.deletePunct = deletePunct;
        this.fixCollinsBaseNP = fixCollinsBaseNP;
    }

    @Override
    public Tree transformTree(Tree tree) {
        Tree[] kids;
        String s = tree.value();
        if (tree.isLeaf()) {
            return this.tf.newLeaf(tree.value());
        }
        s = this.tlp.basicCategory(s);
        if (this.deletePunct && tree.isPreTerminal() && this.tlp.isEvalBIgnoredPunctuationTag(s)) {
            return null;
        }
        if (this.fixCollinsBaseNP && s.equals("NP") && (kids = tree.children()).length == 1 && this.tlp.basicCategory(kids[0].value()).equals("NP")) {
            return this.transformTree(kids[0]);
        }
        if (this.tlp.isStartSymbol(s)) {
            return this.transformTree(tree.children()[0]);
        }
        if (s.equals("PRT")) {
            s = "ADVP";
        }
        ArrayList<Tree> children = new ArrayList<Tree>();
        int numKids = tree.numChildren();
        for (int cNum = 0; cNum < numKids; ++cNum) {
            Tree child = tree.children()[cNum];
            Tree newChild = this.transformTree(child);
            if (newChild == null) continue;
            children.add(newChild);
        }
        if (children.size() == 0) {
            return null;
        }
        return this.tf.newTreeNode(s, children);
    }
}

