/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.parser.lexparser.SisterAnnotationStats;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TreeAnnotator
implements TreeTransformer {
    private TreeFactory tf;
    private TreebankLangParserParams tlpParams;
    private HeadFinder hf;

    @Override
    public Tree transformTree(Tree t) {
        Tree copy = t.deeperCopy(this.tf);
        return this.transformTreeHelper(copy, copy);
    }

    private Tree transformTreeHelper(Tree t, Tree root) {
        String cat2;
        CategoryWordTag headLabel;
        String parentStr;
        Tree parent;
        if (t == null) {
            return null;
        }
        String cat = t.label().value();
        if (t.isLeaf()) {
            StringLabel label = new StringLabel(cat);
            t.setLabel(label);
            return t;
        }
        if (root == null || t.equals(root)) {
            parent = null;
            parentStr = "";
        } else {
            parent = t.parent(root);
            parentStr = parent.label().value();
        }
        String grandParentStr = parent == null || parent.equals(root) ? "" : parent.parent(root).label().value();
        String baseParentStr = this.tlpParams.treebankLanguagePack().basicCategory(parentStr);
        String baseGrandParentStr = this.tlpParams.treebankLanguagePack().basicCategory(grandParentStr);
        if (t.isPreTerminal()) {
            Tree childResult = this.transformTreeHelper(t.children()[0], null);
            String word = childResult.value();
            if (!Train.noTagSplit) {
                if (Train.tagPA) {
                    String test = cat + "^" + baseParentStr;
                    if (!Train.tagSelectiveSplit || Train.splitters.contains(test)) {
                        cat = test;
                    }
                }
                if (Train.markUnaryTags && parent.numChildren() == 1) {
                    cat = cat + "^U";
                }
            }
            CategoryWordTag label = new CategoryWordTag(cat, word, cat);
            t.setLabel(label);
            t.setChild(0, childResult);
            if (Train.noTagSplit) {
                return t;
            }
            return this.tlpParams.transformTree(t, root);
        }
        Tree[] kids = t.children();
        for (int childNum = 0; childNum < kids.length; ++childNum) {
            Tree child = kids[childNum];
            Tree childResult = this.transformTreeHelper(child, root);
            t.setChild(childNum, childResult);
        }
        Tree headChild = this.hf.determineHead(t);
        try {
            headLabel = (CategoryWordTag)headChild.label();
        }
        catch (ClassCastException cce) {
            this.tlpParams.pw(System.err).println("\n\nTreeAnnotator ERROR: Ill-formed tree around empty node \"" + headChild.label() + "\" in tree\n" + t);
            throw cce;
        }
        catch (NullPointerException npe) {
            this.tlpParams.pw(System.err).println("TreeAnnotator: null head found for tree:\n" + t);
            throw npe;
        }
        String word = headLabel.word();
        String tag = headLabel.tag();
        String baseCat = this.tlpParams.treebankLanguagePack().basicCategory(cat);
        if (Train.sisterAnnotate && !Train.smoothing && baseParentStr.length() > 0) {
            List<String> leftSis = this.listBasicCategories(SisterAnnotationStats.leftSisterLabels(t, parent));
            List<String> rightSis = this.listBasicCategories(SisterAnnotationStats.rightSisterLabels(t, parent));
            ArrayList<String> leftAnn = new ArrayList<String>();
            ArrayList<String> rightAnn = new ArrayList<String>();
            for (String s : leftSis) {
                leftAnn.add(baseCat + "=l=" + this.tlpParams.treebankLanguagePack().basicCategory(s));
            }
            for (String s : rightSis) {
                rightAnn.add(baseCat + "=r=" + this.tlpParams.treebankLanguagePack().basicCategory(s));
            }
            Iterator j = rightAnn.iterator();
            while (j.hasNext()) {
            }
            for (String annCat : Train.sisterSplitters) {
                if (!leftAnn.contains(annCat) && !rightAnn.contains(annCat)) continue;
                cat = cat + annCat.replaceAll("^" + baseCat, "");
                break;
            }
        }
        if (Train.PA && !Train.smoothing && baseParentStr.length() > 0) {
            cat2 = baseCat + "^" + baseParentStr;
            if (!Train.selectiveSplit || Train.splitters.contains(cat2)) {
                cat = cat + "^" + baseParentStr;
            }
        }
        if (Train.gPA && !Train.smoothing && grandParentStr.length() > 0) {
            if (Train.selectiveSplit) {
                cat2 = baseCat + "^" + baseParentStr + "~" + baseGrandParentStr;
                if (cat.contains("^") && Train.splitters.contains(cat2)) {
                    cat = cat + "~" + baseGrandParentStr;
                }
            } else {
                cat = cat + "~" + baseGrandParentStr;
            }
        }
        if (Train.markUnary > 0) {
            if (Train.markUnary == 1 && kids.length == 1 && kids[0].depth() >= 2) {
                cat = cat + "-U";
            } else if (Train.markUnary == 2 && parent != null && parent.numChildren() == 1 && t.depth() >= 2) {
                cat = cat + "-u";
            }
        }
        if (Train.xOverX && TreeAnnotator.xOverX(t, baseCat)) {
            cat = cat + "-X";
        }
        if (Train.rightRec && TreeAnnotator.rightRec(t, baseCat)) {
            cat = cat + "-R";
        }
        if (Train.leftRec && TreeAnnotator.leftRec(t, baseCat)) {
            cat = cat + "-L";
        }
        if (Train.splitPrePreT && t.isPrePreTerminal()) {
            cat = cat + "-PPT";
        }
        CategoryWordTag label = new CategoryWordTag(cat, word, tag);
        t.setLabel(label);
        return this.tlpParams.transformTree(t, root);
    }

    private List<String> listBasicCategories(List<String> l) {
        ArrayList<String> l1 = new ArrayList<String>();
        for (String str : l) {
            l1.add(this.tlpParams.treebankLanguagePack().basicCategory(str));
        }
        return l1;
    }

    private static boolean rightRec(Tree t, String baseCat) {
        if (!baseCat.equals("NP")) {
            return false;
        }
        while (!t.isLeaf()) {
            String str = (t = t.lastChild()).label().value();
            if (!str.startsWith(baseCat)) continue;
            return true;
        }
        return false;
    }

    private static boolean leftRec(Tree t, String baseCat) {
        while (!t.isLeaf()) {
            String str = (t = t.firstChild()).label().value();
            if (!str.startsWith(baseCat)) continue;
            return true;
        }
        return false;
    }

    private static boolean xOverX(Tree t, String baseCat) {
        for (Tree s : t.subTreeList()) {
            if (s == t || !s.label().value().startsWith(baseCat)) continue;
            return true;
        }
        return false;
    }

    public TreeAnnotator(HeadFinder hf, TreebankLangParserParams tlpp) {
        this.tlpParams = tlpp;
        this.hf = hf;
        this.tf = new LabeledScoredTreeFactory(new CategoryWordTagFactory());
    }
}

