/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.UnknownWordModel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PetrovLexicon
implements Lexicon {
    static String UNKNOWN_WORD = "UNK";
    Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
    Numberer wordNumberer = Numberer.getGlobalNumberer("words");
    ClassicCounter<Integer> wordCounter = new ClassicCounter();
    ClassicCounter<Integer> tagCounter = new ClassicCounter();
    ClassicCounter<Integer> unseenTagCounter = new ClassicCounter();
    ClassicCounter<IntTaggedWord> tagAndWordCounter = new ClassicCounter();
    ClassicCounter<IntTaggedWord> unseenTagAndSignatureCounter = new ClassicCounter();
    int smoothInUnknownsThreshold = 10;
    double smooth = 0.1;
    List[] rulesWithWord;
    int lastWord = -1;
    int lastSignature = -1;

    @Override
    public boolean isKnown(int word) {
        return this.wordCounter.getCount(word) > 0.0;
    }

    @Override
    public boolean isKnown(String word) {
        return this.isKnown(this.wordNumberer.number(word));
    }

    @Override
    public Iterator<IntTaggedWord> ruleIteratorByWord(int word, int loc) {
        if (this.isKnown(word)) {
            ArrayList rules = new ArrayList();
            return rules.iterator();
        }
        return null;
    }

    protected void initRulesWithWord() {
    }

    @Override
    public int numRules() {
        if (this.rulesWithWord == null) {
            this.initRulesWithWord();
        }
        int accumulated = 0;
        for (List lis : this.rulesWithWord) {
            accumulated += lis.size();
        }
        return accumulated;
    }

    @Override
    public void train(Collection<Tree> trees) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float score(IntTaggedWord iTW, int loc) {
        int word = iTW.word();
        int tag = iTW.tag();
        double wc = this.wordCounter.getCount(word);
        double totalSeen = this.tagCounter.totalCount();
        double totalUnseen = this.unseenTagCounter.totalCount();
        if (wc > 0.0) {
            double probTagGivenWord = Double.NEGATIVE_INFINITY;
            double twc = this.tagAndWordCounter.getCount(iTW);
            if (wc > (double)this.smoothInUnknownsThreshold) {
                probTagGivenWord = twc / wc;
            } else {
                double probTagGivenUnseen = this.unseenTagCounter.getCount(tag) / totalUnseen;
                probTagGivenWord = (twc + this.smooth * probTagGivenUnseen) / (wc + this.smooth);
            }
            double tc = this.tagCounter.getCount(tag);
            double probTag = tc / totalSeen;
            double probWord = wc / totalSeen;
            return (float)(probTagGivenWord * probWord / probTag);
        }
        int signature = this.getSignature(word, loc);
        double sc = this.wordCounter.getCount(signature);
        IntTaggedWord siTW = new IntTaggedWord(signature, tag);
        double tsc = this.unseenTagAndSignatureCounter.getCount(siTW);
        double probTagGivenUnseen = this.unseenTagCounter.getCount(tag) / totalUnseen;
        double probTagGivenWord = (tsc + this.smooth * probTagGivenUnseen) / (sc + this.smooth);
        double tc = this.unseenTagCounter.getCount(tag);
        double probTag = tc / totalUnseen;
        double probWord = wc / totalUnseen;
        return (float)(probTagGivenWord * probWord / probTag);
    }

    @Override
    public void writeData(Writer w) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readData(BufferedReader in) throws IOException {
        Timing t = new Timing();
        t.start();
        System.err.println("Loading in PetrovLexicon from file...");
        int numSeenWords = 0;
        int numUnseenWords = 0;
        this.wordCounter = new ClassicCounter();
        this.tagCounter = new ClassicCounter();
        this.unseenTagCounter = new ClassicCounter();
        this.tagAndWordCounter = new ClassicCounter();
        this.unseenTagAndSignatureCounter = new ClassicCounter();
        String line = in.readLine();
        int WC = 0;
        int TC = 1;
        int UTC = 2;
        int TWC = 3;
        int UTSC = 4;
        int status = -1;
        while (line != null) {
            double count;
            IntTaggedWord itw;
            String tag;
            int i;
            String[] fields;
            int space;
            if (line.startsWith("-------")) {
                status = -1;
            } else if (status == -1) {
                if (line.startsWith("WORD-COUNTER")) {
                    status = WC;
                } else if (line.startsWith("TAG-COUNTER")) {
                    status = TC;
                } else if (line.startsWith("UNSEEN-TAG-COUNTER")) {
                    status = UTC;
                } else if (line.startsWith("TAG-AND-WORD-COUNTER")) {
                    status = TWC;
                } else {
                    if (!line.startsWith("UNSEEN-TAG-AND-SIGNATURE-COUNTER")) throw new RuntimeException("Unrecognized header: " + line);
                    status = UTSC;
                }
            } else if (status == WC) {
                space = line.indexOf(32);
                String wordString = new String(line.substring(0, space));
                if (wordString.startsWith("UNK")) {
                    ++numUnseenWords;
                } else {
                    ++numSeenWords;
                }
                int word = this.wordNumberer.number(wordString);
                double count2 = Double.parseDouble(line.substring(space + 1));
                this.wordCounter.setCount(word, count2);
            } else if (status == TC) {
                space = line.indexOf(32);
                int tag2 = this.tagNumberer.number(new String(line.substring(0, space)));
                double count3 = Double.parseDouble(line.substring(space + 1));
                this.tagCounter.setCount(tag2, count3);
            } else if (status == UTC) {
                space = line.indexOf(32);
                int tag3 = this.tagNumberer.number(new String(line.substring(0, space)));
                double count4 = Double.parseDouble(line.substring(space + 1));
                this.unseenTagCounter.setCount(tag3, count4);
            } else if (status == TWC) {
                space = line.indexOf(32);
                int bracket = line.indexOf(91);
                String baseTag = line.substring(0, space);
                String word = new String(line.substring(space + 1, bracket - 1));
                fields = line.substring(bracket + 1, line.length() - 1).split(" ,");
                for (i = 0; i < fields.length; ++i) {
                    tag = baseTag + "_" + i;
                    itw = new IntTaggedWord(this.wordNumberer.number(word), this.tagNumberer.number(tag));
                    count = Double.parseDouble(fields[i]);
                    this.tagAndWordCounter.setCount(itw, count);
                }
            } else if (status == UTSC) {
                space = line.indexOf(32);
                int bracket = line.indexOf(91);
                String baseTag = new String(line.substring(0, space));
                String word = new String(line.substring(space + 1, bracket - 1));
                fields = line.substring(bracket + 1, line.length() - 1).split(" ,");
                for (i = 0; i < fields.length; ++i) {
                    tag = baseTag + "_" + i;
                    itw = new IntTaggedWord(this.wordNumberer.number(word), this.tagNumberer.number(tag));
                    count = Double.parseDouble(fields[i]);
                    this.unseenTagAndSignatureCounter.setCount(itw, count);
                }
            }
            line = in.readLine();
        }
        t.stop("Done loading.");
        System.err.println("numSeenWords: " + numSeenWords);
        System.err.println("numUnseenWords: " + numUnseenWords);
        System.err.println("wordCounter: " + this.wordCounter.size() + " keys and " + this.wordCounter.totalCount() + " total count.");
        System.err.println("tagCounter: " + this.tagCounter.size() + " keys and " + this.tagCounter.totalCount() + " total count.");
        System.err.println("unseenTagCounter: " + this.unseenTagCounter.size() + " keys and " + this.unseenTagCounter.totalCount() + " total count.");
        System.err.println("tagAndWordCounter: " + this.tagAndWordCounter.size() + " keys and " + this.tagAndWordCounter.totalCount() + " total count.");
        System.err.println("unseenTagAndSignatureCounter: " + this.unseenTagAndSignatureCounter.size() + " keys and " + this.unseenTagAndSignatureCounter.totalCount() + " total count.");
    }

    public int getSignature(int word, int loc) {
        if (word == this.lastWord) {
            return this.lastSignature;
        }
        String wordString = (String)this.wordNumberer.object(word);
        String signatureString = this.getSignature(wordString, loc);
        int signature = this.wordNumberer.number(word);
        this.lastWord = word;
        this.lastSignature = signature;
        return signature;
    }

    public String getSignature(String word, int loc) {
        StringBuilder sb = new StringBuilder();
        int wlen = word.length();
        int numCaps = 0;
        boolean hasDigit = false;
        boolean hasDash = false;
        boolean hasLower = false;
        for (int i = 0; i < wlen; ++i) {
            char ch = word.charAt(i);
            if (Character.isDigit(ch)) {
                hasDigit = true;
                continue;
            }
            if (ch == '-') {
                hasDash = true;
                continue;
            }
            if (!Character.isLetter(ch)) continue;
            if (Character.isLowerCase(ch)) {
                hasLower = true;
                continue;
            }
            if (Character.isTitleCase(ch)) {
                hasLower = true;
                ++numCaps;
                continue;
            }
            ++numCaps;
        }
        char ch0 = word.charAt(0);
        String lowered = word.toLowerCase();
        if (Character.isUpperCase(ch0) || Character.isTitleCase(ch0)) {
            if (loc == 0 && numCaps == 1) {
                sb.append("-INITC");
                if (this.isKnown(lowered)) {
                    sb.append("-KNOWNLC");
                }
            } else {
                sb.append("-CAPS");
            }
        } else if (!Character.isLetter(ch0) && numCaps > 0) {
            sb.append("-CAPS");
        } else if (hasLower) {
            sb.append("-LC");
        }
        if (hasDigit) {
            sb.append("-NUM");
        }
        if (hasDash) {
            sb.append("-DASH");
        }
        if (lowered.endsWith("s") && wlen >= 3) {
            char ch2 = lowered.charAt(wlen - 2);
            if (ch2 != 's' && ch2 != 'i' && ch2 != 'u') {
                sb.append("-s");
            }
        } else if (!(word.length() < 5 || hasDash || hasDigit && numCaps > 0)) {
            if (lowered.endsWith("ed")) {
                sb.append("-ed");
            } else if (lowered.endsWith("ing")) {
                sb.append("-ing");
            } else if (lowered.endsWith("ion")) {
                sb.append("-ion");
            } else if (lowered.endsWith("er")) {
                sb.append("-er");
            } else if (lowered.endsWith("est")) {
                sb.append("-est");
            } else if (lowered.endsWith("ly")) {
                sb.append("-ly");
            } else if (lowered.endsWith("ity")) {
                sb.append("-ity");
            } else if (lowered.endsWith("y")) {
                sb.append("-y");
            } else if (lowered.endsWith("al")) {
                sb.append("-al");
            }
        }
        return sb.toString();
    }

    @Override
    public UnknownWordModel getUnknownWordModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUnknownWordModel(UnknownWordModel uwm) {
        throw new UnsupportedOperationException();
    }
}

