/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.Scorer;
import java.util.List;

class MaxScorer
implements Scorer {
    private Scorer scorer1;
    private Scorer scorer2;

    @Override
    public double oScore(Edge edge) {
        return SloppyMath.min(this.scorer1.oScore(edge), this.scorer2.oScore(edge));
    }

    @Override
    public double iScore(Edge edge) {
        return SloppyMath.min(this.scorer1.iScore(edge), this.scorer2.iScore(edge));
    }

    @Override
    public boolean oPossible(Hook hook) {
        return this.scorer1.oPossible(hook) && this.scorer2.oPossible(hook);
    }

    @Override
    public boolean iPossible(Hook hook) {
        return this.scorer1.iPossible(hook) && this.scorer2.iPossible(hook);
    }

    @Override
    public boolean parse(List<? extends HasWord> words) {
        boolean b1 = this.scorer1.parse(words);
        boolean b2 = this.scorer2.parse(words);
        return b1 && b2;
    }

    public MaxScorer(Scorer scorer1, Scorer scorer2) {
        this.scorer1 = scorer1;
        this.scorer2 = scorer2;
    }
}

