/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.fsm.ExactGrammarCompactor;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.NumberRangeFileFilter;
import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.ViterbiParser;
import edu.stanford.nlp.parser.lexparser.AbstractEval;
import edu.stanford.nlp.parser.lexparser.BiLexPCFGParser;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryGrammarExtractor;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.BoundaryRemover;
import edu.stanford.nlp.parser.lexparser.CollinsPuncTransformer;
import edu.stanford.nlp.parser.lexparser.ConstituentEvalByCat;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.EvalB;
import edu.stanford.nlp.parser.lexparser.ExhaustiveDependencyParser;
import edu.stanford.nlp.parser.lexparser.ExhaustivePCFGParser;
import edu.stanford.nlp.parser.lexparser.Extractor;
import edu.stanford.nlp.parser.lexparser.FastFactoredParser;
import edu.stanford.nlp.parser.lexparser.GrammarCompactor;
import edu.stanford.nlp.parser.lexparser.IterativeCKYPCFGParser;
import edu.stanford.nlp.parser.lexparser.LabeledConstituentEval;
import edu.stanford.nlp.parser.lexparser.LatticeReader;
import edu.stanford.nlp.parser.lexparser.LeftHeadFinder;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammarExtractor;
import edu.stanford.nlp.parser.lexparser.NodePruner;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.ParentAnnotationStats;
import edu.stanford.nlp.parser.lexparser.ParserData;
import edu.stanford.nlp.parser.lexparser.PetrovLexicon;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreeAnnotator;
import edu.stanford.nlp.parser.lexparser.TreeAnnotatorAndBinarizer;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.lexparser.TwinScorer;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.trees.CompositeTreeTransformer;
import edu.stanford.nlp.trees.CompositeTreebank;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.arabic.ArabicTreebankLanguagePack;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.GZIPOutputStream;

public class LexicalizedParser
implements ViterbiParser,
Function<Object, Tree> {
    static boolean basicCategoryTagsInDependencyGrammar = false;
    static String trainTreeFile = null;
    private boolean fallbackToPCFG = false;
    protected ExhaustivePCFGParser pparser;
    protected ExhaustiveDependencyParser dparser;
    protected KBestViterbiParser bparser;
    protected TreeTransformer debinarizer;
    private TreeTransformer subcategoryStripper;
    private transient ParserData pd;
    private Options op;
    private static final String SERIALIZED_PARSER_PROPERTY = "edu.stanford.nlp.SerializedLexicalizedParser";
    private static final String DEFAULT_PARSER_LOC = "/u/nlp/data/lexparser/englishPCFG.ser.gz";
    private static boolean parseSucceeded = false;
    private static int trainLengthLimit = 100000;

    public Options getOp() {
        return this.op;
    }

    @Override
    public Tree apply(Object in) {
        List<Word> lst;
        if (in instanceof String) {
            DocumentPreprocessor dp = new DocumentPreprocessor(this.op.tlpParams.treebankLanguagePack().getTokenizerFactory());
            lst = dp.getWordsFromString((String)in);
        } else if (in instanceof List) {
            lst = (List<Word>)in;
        } else {
            throw new IllegalArgumentException("Can only parse Sentence/List/String");
        }
        try {
            if (this.parse((List<? extends HasWord>)lst)) {
                Tree bestparse = this.getBestParse();
                bestparse.setScore(this.getPCFGScore() % -1000.0);
                return bestparse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LabeledScoredTreeFactory lstf = new LabeledScoredTreeFactory();
        ArrayList<Tree> lst2 = new ArrayList<Tree>();
        for (HasWord hasWord : lst) {
            String s = hasWord.toString();
            Tree t = lstf.newLeaf(s);
            Tree t2 = lstf.newTreeNode("X", Collections.singletonList(t));
            lst2.add(t2);
        }
        return lstf.newTreeNode("X", lst2);
    }

    public TreePrint getTreePrint() {
        return Test.treePrint(this.op.tlpParams);
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence, String goal) {
        return this.parse(sentence);
    }

    public boolean parse(String sentence) {
        DocumentPreprocessor dp = new DocumentPreprocessor(this.op.tlpParams.treebankLanguagePack().getTokenizerFactory());
        return this.parse(dp.getWordsFromString(sentence));
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence) {
        int length = sentence.size();
        if (length == 0) {
            throw new UnsupportedOperationException("Can't parse a zero-length sentence!");
        }
        ArrayList<HasWord> sentenceB = new ArrayList<HasWord>(sentence);
        if (Test.addMissingFinalPunctuation) {
            this.addSentenceFinalPunctIfNeeded(sentenceB, length);
        }
        if (length > Test.maxLength) {
            throw new UnsupportedOperationException("Sentence too long: length " + length);
        }
        TreePrint treePrint = this.getTreePrint();
        PrintWriter pwOut = this.op.tlpParams.pw();
        parseSucceeded = false;
        sentenceB.add(new Word(".$."));
        if (this.op.doPCFG) {
            if (!this.pparser.parse(sentenceB)) {
                return parseSucceeded;
            }
            if (Test.verbose) {
                System.out.println("PParser output");
                treePrint.printTree(this.debinarizer.transformTree(this.pparser.getBestParse()), pwOut);
            }
        }
        if (this.op.doDep && !Test.useFastFactored) {
            if (!this.dparser.parse(sentenceB)) {
                return parseSucceeded;
            }
            if (Test.verbose) {
                System.out.println("DParser output");
                treePrint.printTree(this.dparser.getBestParse(), pwOut);
            }
        }
        if (this.op.doPCFG && this.op.doDep) {
            if (!this.bparser.parse(sentenceB)) {
                return parseSucceeded;
            }
            parseSucceeded = true;
        }
        return true;
    }

    public boolean parse(LatticeReader lr) {
        TreePrint treePrint = this.getTreePrint();
        PrintWriter pwOut = this.op.tlpParams.pw();
        parseSucceeded = false;
        if (lr.getNumStates() > Test.maxLength + 1) {
            throw new UnsupportedOperationException("Lattice too big: " + lr.getNumStates());
        }
        if (this.op.doPCFG) {
            if (!this.pparser.parse(lr)) {
                return parseSucceeded;
            }
            if (Test.verbose) {
                System.out.println("PParser output");
                treePrint.printTree(this.debinarizer.transformTree(this.pparser.getBestParse()), pwOut);
            }
        }
        return true;
    }

    private void addSentenceFinalPunctIfNeeded(List<HasWord> sentence, int length) {
        String[] sfpWords;
        int start = length - 3;
        if (start < 0) {
            start = 0;
        }
        TreebankLanguagePack tlp = this.op.tlpParams.treebankLanguagePack();
        for (int i = length - 1; i >= start; --i) {
            String str;
            HasWord item = sentence.get(i);
            String tag = null;
            if (item instanceof HasTag) {
                tag = ((HasTag)((Object)item)).tag();
            }
            if (!(tag != null && !"".equals(tag) ? tlp.isSentenceFinalPunctuationTag(tag) : (item instanceof HasWord ? tlp.isPunctuationWord(str = item.word()) : tlp.isPunctuationWord(str = item.toString())))) continue;
            return;
        }
        if (Test.verbose) {
            System.err.println("Adding missing final punctuation to sentence.");
        }
        if ((sfpWords = tlp.sentenceFinalPunctuationWords()).length > 0) {
            sentence.add(new Word(sfpWords[0]));
        }
    }

    @Override
    public Tree getBestParse() {
        if (this.bparser != null && parseSucceeded) {
            Tree binaryTree = this.bparser.getBestParse();
            Tree tree = this.debinarizer.transformTree(binaryTree);
            if (this.op.nodePrune) {
                NodePruner np = new NodePruner(this.pparser, this.debinarizer);
                tree = np.prune(tree);
            }
            return this.subcategoryStripper.transformTree(tree);
        }
        if (this.pparser != null && this.pparser.hasParse() && this.fallbackToPCFG) {
            return this.getBestPCFGParse();
        }
        if (this.dparser != null && this.dparser.hasParse()) {
            return this.getBestDependencyParse(true);
        }
        throw new NoSuchElementException();
    }

    public List<ScoredObject<Tree>> getKGoodFactoredParses(int k) {
        if (this.bparser == null) {
            return null;
        }
        List<ScoredObject<Tree>> binaryTrees = this.bparser.getKGoodParses(k);
        if (binaryTrees == null) {
            return null;
        }
        ArrayList<ScoredObject<Tree>> trees = new ArrayList<ScoredObject<Tree>>(k);
        for (ScoredObject<Tree> tp : binaryTrees) {
            Tree t = this.debinarizer.transformTree(tp.object());
            t = this.subcategoryStripper.transformTree(t);
            trees.add(new ScoredObject<Tree>(t, tp.score()));
        }
        return trees;
    }

    public List<ScoredObject<Tree>> getKBestPCFGParses(int k) {
        if (this.pparser == null) {
            return null;
        }
        List<ScoredObject<Tree>> binaryTrees = this.pparser.getKBestParses(k);
        if (binaryTrees == null) {
            return null;
        }
        ArrayList<ScoredObject<Tree>> trees = new ArrayList<ScoredObject<Tree>>(k);
        for (ScoredObject<Tree> p : binaryTrees) {
            Tree t = this.debinarizer.transformTree(p.object());
            t = this.subcategoryStripper.transformTree(t);
            trees.add(new ScoredObject<Tree>(t, p.score()));
        }
        return trees;
    }

    public Tree getBestPCFGParse() {
        return this.getBestPCFGParse(true);
    }

    public Tree getBestPCFGParse(boolean stripSubcategories) {
        if (this.pparser == null) {
            return null;
        }
        Tree binaryTree = this.pparser.getBestParse();
        if (binaryTree == null) {
            return null;
        }
        Tree t = this.debinarizer.transformTree(binaryTree);
        if (stripSubcategories) {
            t = this.subcategoryStripper.transformTree(t);
        }
        return t;
    }

    public double getPCFGScore() {
        return this.pparser.getBestScore();
    }

    public double getPCFGScore(String goalStr) {
        return this.pparser.getBestScore(goalStr);
    }

    public Tree getBestDependencyParse() {
        return this.getBestDependencyParse(false);
    }

    public Tree getBestDependencyParse(boolean debinarize) {
        Tree t;
        Tree tree = t = this.dparser != null ? this.dparser.getBestParse() : null;
        if (debinarize && t != null) {
            t = this.debinarizer.transformTree(t);
        }
        return t;
    }

    public LexicalizedParser() {
        this(new Options());
    }

    public LexicalizedParser(Options op) {
        this.op = op;
        String source = System.getProperty(SERIALIZED_PARSER_PROPERTY);
        if (source == null) {
            source = DEFAULT_PARSER_LOC;
        }
        this.pd = LexicalizedParser.getParserDataFromFile(source, op);
        this.op = this.pd.pt;
        this.makeParsers();
    }

    public LexicalizedParser(String parserFileOrUrl, Options op) {
        this.op = op;
        this.pd = LexicalizedParser.getParserDataFromFile(parserFileOrUrl, op);
        this.op = this.pd.pt;
        this.makeParsers();
    }

    public LexicalizedParser(String parserFileOrUrl) {
        this(parserFileOrUrl, new Options());
    }

    public void setMaxLength(int maxLength) {
        Test.maxLength = maxLength;
    }

    public static ParserData getParserDataFromFile(String parserFileOrUrl, Options op) {
        ParserData pd = LexicalizedParser.getParserDataFromSerializedFile(parserFileOrUrl);
        if (pd == null) {
            pd = LexicalizedParser.getParserDataFromTextFile(parserFileOrUrl, op);
        }
        return pd;
    }

    public LexicalizedParser(String parserFileOrUrl, boolean isTextGrammar, Options op) {
        this.op = op;
        if (isTextGrammar) {
            this.pd = LexicalizedParser.getParserDataFromTextFile(parserFileOrUrl, op);
        } else {
            this.pd = LexicalizedParser.getParserDataFromSerializedFile(parserFileOrUrl);
            this.op = this.pd.pt;
        }
        this.makeParsers();
    }

    public LexicalizedParser(ParserData pd) {
        this.pd = pd;
        this.makeParsers();
    }

    public LexicalizedParser(ObjectInputStream in) throws Exception {
        this((ParserData)in.readObject());
    }

    public LexicalizedParser(Treebank trainTreebank, GrammarCompactor compactor, Options op) {
        this(trainTreebank, compactor, op, null);
    }

    public LexicalizedParser(String treebankPath, FileFilter filt, Options op) {
        this(LexicalizedParser.makeTreebank(treebankPath, op, filt), op);
    }

    private static Treebank makeTreebank(String treebankPath, Options op, FileFilter filt) {
        System.err.println("Training a parser from treebank dir: " + treebankPath);
        DiskTreebank trainTreebank = op.tlpParams.diskTreebank();
        System.err.print("Reading trees...");
        if (filt == null) {
            trainTreebank.loadPath(treebankPath);
        } else {
            trainTreebank.loadPath(treebankPath, filt);
        }
        Timing.tick("done [read " + trainTreebank.size() + " trees].");
        return trainTreebank;
    }

    private static DiskTreebank makeSecondaryTreebank(String treebankPath, Options op, FileFilter filt) {
        System.err.println("Additionally training using secondary disk treebank: " + treebankPath + ' ' + filt);
        DiskTreebank trainTreebank = op.tlpParams.diskTreebank();
        if (filt == null) {
            trainTreebank.loadPath(treebankPath);
        } else {
            trainTreebank.loadPath(treebankPath, filt);
        }
        return trainTreebank;
    }

    public LexicalizedParser(Treebank trainTreebank, GrammarCompactor compactor, Options op, Treebank tuneTreebank) {
        this.op = op;
        this.pd = this.getParserDataFromTreebank(trainTreebank, compactor, tuneTreebank);
        this.makeParsers();
    }

    public LexicalizedParser(Treebank trainTreebank, DiskTreebank secondaryTrainTreebank, double weight, GrammarCompactor compactor, Options op) {
        this.op = op;
        this.pd = this.getParserDataFromTreebank(trainTreebank, secondaryTrainTreebank, weight, compactor);
        this.makeParsers();
    }

    public LexicalizedParser(Treebank trainTreebank, Options op) {
        this(trainTreebank, null, op);
    }

    public ParserData parserData() {
        return this.pd;
    }

    public Lexicon getLexicon() {
        return this.pd.lex;
    }

    static void saveParserDataToSerialized(ParserData pd, String filename) {
        try {
            System.err.print("Writing parser in serialized format to file " + filename + ' ');
            ObjectOutputStream out2 = IOUtils.writeStreamFromString(filename);
            out2.writeObject(pd);
            out2.close();
            System.err.println("done.");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    static void saveParserDataToText(ParserData pd, String filename) {
        try {
            System.err.print("Writing parser in text grammar format to file " + filename);
            BufferedOutputStream os = filename.endsWith(".gz") ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename))) : new BufferedOutputStream(new FileOutputStream(filename));
            PrintWriter out2 = new PrintWriter(os);
            String prefix = "BEGIN ";
            out2.println(prefix + "OPTIONS");
            if (pd.pt != null) {
                pd.pt.writeData(out2);
            }
            out2.println();
            System.err.print(".");
            out2.println(prefix + "LEXICON");
            if (pd.lex != null) {
                pd.lex.writeData(out2);
            }
            out2.println();
            System.err.print(".");
            out2.println(prefix + "UNARY_GRAMMAR");
            if (pd.ug != null) {
                pd.ug.writeData(out2);
            }
            out2.println();
            System.err.print(".");
            out2.println(prefix + "BINARY_GRAMMAR");
            if (pd.bg != null) {
                pd.bg.writeData(out2);
            }
            out2.println();
            System.err.print(".");
            out2.println(prefix + "DEPENDENCY_GRAMMAR");
            if (pd.dg != null) {
                pd.dg.writeData(out2);
            }
            out2.println();
            System.err.print(".");
            out2.flush();
            out2.close();
            System.err.println("done.");
        }
        catch (IOException e) {
            System.err.println("Trouble saving parser data to ASCII format.");
            e.printStackTrace();
        }
    }

    protected static ParserData getParserDataFromPetrovFiles(String grammarFile, String lexiconFile) {
        try {
            Options op = new Options();
            BufferedReader gIn = new BufferedReader(new FileReader(grammarFile));
            String line = gIn.readLine();
            Numberer stateNumberer = Numberer.getGlobalNumberer("states");
            ArrayList<UnaryRule> unaryRules = new ArrayList<UnaryRule>();
            ArrayList<BinaryRule> binaryRules = new ArrayList<BinaryRule>();
            while (line != null) {
                double score;
                String[] fields = line.split("\\s+");
                if (fields.length == 4) {
                    score = Double.parseDouble(fields[3]);
                    UnaryRule ur = new UnaryRule(stateNumberer.number(new String(fields[0])), stateNumberer.number(new String(fields[2])), score);
                    unaryRules.add(ur);
                } else if (fields.length == 5) {
                    score = Double.parseDouble(fields[4]);
                    BinaryRule br = new BinaryRule(stateNumberer.number(new String(fields[0])), stateNumberer.number(new String(fields[2])), stateNumberer.number(new String(fields[3])), score);
                    binaryRules.add(br);
                } else {
                    throw new RuntimeException("Bad line format: " + line);
                }
                line = gIn.readLine();
            }
            BinaryGrammar bg = new BinaryGrammar(stateNumberer.total());
            for (BinaryRule br : binaryRules) {
                bg.addRule(br);
            }
            bg.splitRules();
            UnaryGrammar ug = new UnaryGrammar(stateNumberer.total());
            for (UnaryRule ur : unaryRules) {
                ug.addRule(ur);
            }
            ug.purgeRules();
            PetrovLexicon lex = new PetrovLexicon();
            lex.readData(new BufferedReader(new FileReader(lexiconFile)));
            return new ParserData(lex, bg, ug, null, null, op);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void confirmBeginBlock(String file, String line) {
        if (line == null) {
            throw new RuntimeException(file + ": expecting BEGIN block; got end of file.");
        }
        if (!line.startsWith("BEGIN")) {
            throw new RuntimeException(file + ": expecting BEGIN block; got " + line);
        }
    }

    protected static ParserData getParserDataFromTextFile(String textFileOrUrl, Options op) {
        try {
            Timing tim = new Timing();
            System.err.print("Loading parser from text file " + textFileOrUrl + ' ');
            BufferedReader in = IOUtils.readReaderFromString(textFileOrUrl);
            Timing.startTime();
            String line = in.readLine();
            LexicalizedParser.confirmBeginBlock(textFileOrUrl, line);
            op.readData(in);
            System.err.print(".");
            line = in.readLine();
            LexicalizedParser.confirmBeginBlock(textFileOrUrl, line);
            Lexicon lex = op.tlpParams.lex(op.lexOptions);
            lex.readData(in);
            System.err.print(".");
            line = in.readLine();
            LexicalizedParser.confirmBeginBlock(textFileOrUrl, line);
            UnaryGrammar ug = new UnaryGrammar(op.numStates);
            ug.readData(in);
            System.err.print(".");
            line = in.readLine();
            LexicalizedParser.confirmBeginBlock(textFileOrUrl, line);
            BinaryGrammar bg = new BinaryGrammar(op.numStates);
            bg.readData(in);
            System.err.print(".");
            line = in.readLine();
            LexicalizedParser.confirmBeginBlock(textFileOrUrl, line);
            MLEDependencyGrammar dg = new MLEDependencyGrammar(op.tlpParams, op.directional, op.distance, op.coarseDistance);
            dg.readData(in);
            System.err.print(".");
            Map<String, Numberer> numbs = Numberer.getNumberers();
            in.close();
            System.err.println(" done [" + tim.toSecondsString() + " sec].");
            return new ParserData(lex, bg, ug, dg, numbs, op);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ParserData getParserDataFromSerializedFile(String serializedFileOrUrl) {
        try {
            Timing tim = new Timing();
            System.err.print("Loading parser from serialized file " + serializedFileOrUrl + " ...");
            ObjectInputStream in = IOUtils.readStreamFromString(serializedFileOrUrl);
            ParserData pd = (ParserData)in.readObject();
            in.close();
            System.err.println(" done [" + tim.toSecondsString() + " sec].");
            return pd;
        }
        catch (InvalidClassException ice) {
            System.err.println();
            throw new RuntimeException("Invalid class in file: " + serializedFileOrUrl, ice);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println();
            throw new RuntimeException("File not found: " + serializedFileOrUrl, fnfe);
        }
        catch (StreamCorruptedException sce) {
            System.err.println();
        }
        catch (Exception e) {
            System.err.println();
            e.printStackTrace();
        }
        return null;
    }

    private static void printOptions(boolean train, Options op) {
        op.display();
        if (train) {
            Train.display();
        } else {
            Test.display();
        }
        op.tlpParams.display();
    }

    public static Pair<List<Tree>, List<Tree>> getAnnotatedBinaryTreebankFromTreebank(Treebank trainTreebank, Treebank tuneTreebank, Options op) {
        Timing.startTime();
        TreebankLangParserParams tlpParams = op.tlpParams;
        TreebankLanguagePack tlp = tlpParams.treebankLanguagePack();
        if (Test.verbose) {
            PrintWriter pwErr = tlpParams.pw(System.err);
            pwErr.print("Training ");
            pwErr.println(trainTreebank.textualSummary(tlp));
        }
        System.err.print("Binarizing trees...");
        TreeAnnotatorAndBinarizer binarizer = !Train.leftToRight ? new TreeAnnotatorAndBinarizer(tlpParams, op.forceCNF, !Train.outsideFactor(), true) : new TreeAnnotatorAndBinarizer(tlpParams.headFinder(), (HeadFinder)new LeftHeadFinder(), tlpParams, op.forceCNF, !Train.outsideFactor(), true);
        CollinsPuncTransformer collinsPuncTransformer = null;
        if (Train.collinsPunc) {
            collinsPuncTransformer = new CollinsPuncTransformer(tlp);
        }
        ArrayList<Tree> binaryTrainTrees = new ArrayList<Tree>();
        ArrayList<Tree> binaryTuneTrees = new ArrayList<Tree>();
        if (Train.selectiveSplit) {
            Train.splitters = ParentAnnotationStats.getSplitCategories(trainTreebank, Train.tagSelectiveSplit, 0, Train.selectiveSplitCutOff, Train.tagSelectiveSplitCutOff, tlp);
            LexicalizedParser.removeDeleteSplittersFromSplitters(tlp);
            if (Test.verbose) {
                ArrayList<String> list = new ArrayList<String>(Train.splitters);
                Collections.sort(list);
                System.err.println("Parent split categories: " + list);
            }
        }
        if (Train.selectivePostSplit) {
            TreeAnnotator myTransformer = new TreeAnnotator(tlpParams.headFinder(), tlpParams);
            Treebank annotatedTB = trainTreebank.transform(myTransformer);
            Train.postSplitters = ParentAnnotationStats.getSplitCategories(annotatedTB, true, 0, Train.selectivePostSplitCutOff, Train.tagSelectivePostSplitCutOff, tlp);
            if (Test.verbose) {
                System.err.println("Parent post annotation split categories: " + Train.postSplitters);
            }
        }
        if (Train.hSelSplit) {
            int ptt = Train.printTreeTransformations;
            Train.printTreeTransformations = 0;
            binarizer.setDoSelectiveSplit(false);
            for (Tree tree : trainTreebank) {
                if (Train.collinsPunc) {
                    tree = collinsPuncTransformer.transformTree(tree);
                }
                binarizer.transformTree(tree);
            }
            binarizer.setDoSelectiveSplit(true);
            Train.printTreeTransformations = ptt;
        }
        for (Tree tree : trainTreebank) {
            if (Train.collinsPunc) {
                tree = collinsPuncTransformer.transformTree(tree);
            }
            if ((tree = binarizer.transformTree(tree)).yield().size() - 1 > trainLengthLimit) continue;
            binaryTrainTrees.add(tree);
        }
        if (Train.printAnnotatedStateCounts) {
            binarizer.printStateCounts();
        }
        if (Train.printAnnotatedRuleCounts) {
            binarizer.printRuleCounts();
        }
        if (tuneTreebank != null) {
            for (Tree tree : tuneTreebank) {
                if (Train.collinsPunc) {
                    tree = collinsPuncTransformer.transformTree(tree);
                }
                if ((tree = binarizer.transformTree(tree)).yield().size() - 1 > trainLengthLimit) continue;
                binaryTuneTrees.add(tree);
            }
        }
        Timing.tick("done.");
        if (Test.verbose) {
            binarizer.dumpStats();
        }
        return new Pair<List<Tree>, List<Tree>>(binaryTrainTrees, binaryTuneTrees);
    }

    private static void removeDeleteSplittersFromSplitters(TreebankLanguagePack tlp) {
        if (Train.deleteSplitters != null) {
            ArrayList<String> deleted = new ArrayList<String>();
            for (String del : Train.deleteSplitters) {
                String baseDel = tlp.basicCategory(del);
                boolean checkBasic = del.equals(baseDel);
                Iterator<String> it = Train.splitters.iterator();
                while (it.hasNext()) {
                    String elem = it.next();
                    String baseElem = tlp.basicCategory(elem);
                    boolean delStr = checkBasic && baseElem.equals(baseDel) || elem.equals(del);
                    if (!delStr) continue;
                    it.remove();
                    deleted.add(elem);
                }
            }
            if (Test.verbose) {
                System.err.println("Removed from vertical splitters: " + deleted);
            }
        }
    }

    public final ParserData getParserDataFromTreebank(Treebank trainTreebank, GrammarCompactor compactor, Treebank tuneTreebank) {
        System.err.println("Currently " + new Date());
        LexicalizedParser.printOptions(true, this.op);
        Pair<List<Tree>, List<Tree>> pair = LexicalizedParser.getAnnotatedBinaryTreebankFromTreebank(trainTreebank, tuneTreebank, this.op);
        List<Tree> binaryTrainTrees = pair.first();
        List<Tree> binaryTuneTrees = pair.second();
        BinaryGrammarExtractor bgExtractor = new BinaryGrammarExtractor();
        Extractor<MLEDependencyGrammar> dgExtractor = this.op.tlpParams.dependencyGrammarExtractor(this.op);
        System.err.print("Extracting PCFG...");
        Pair<UnaryGrammar, BinaryGrammar> bgug = (Pair<UnaryGrammar, BinaryGrammar>)bgExtractor.extract(binaryTrainTrees);
        Timing.tick("done.");
        if (compactor != null) {
            System.err.print("Compacting grammar...");
            bgug = compactor.compactGrammar(bgug);
            Timing.tick("done.");
        }
        System.err.print("Compiling grammar...");
        BinaryGrammar bg = (BinaryGrammar)bgug.second;
        bg.splitRules();
        UnaryGrammar ug = (UnaryGrammar)bgug.first;
        ug.purgeRules();
        Timing.tick("done");
        System.err.print("Extracting Lexicon...");
        Lexicon lex = this.op.tlpParams.lex(this.op.lexOptions);
        lex.train(binaryTrainTrees);
        Timing.tick("done.");
        DependencyGrammar dg = null;
        if (this.op.doDep) {
            System.err.print("Extracting Dependencies...");
            dg = dgExtractor.extract(binaryTrainTrees);
            Timing.tick("done.");
            if (tuneTreebank != null) {
                System.err.print("Tuning Dependency Model...");
                dg.tune(binaryTuneTrees);
                Timing.tick("done.");
            }
        }
        Map<String, Numberer> numbs = Numberer.getNumberers();
        System.err.println("Done training parser.");
        if (trainTreeFile != null) {
            try {
                System.err.print("Writing out binary trees to " + trainTreeFile + "...");
                IOUtils.writeObjectToFile(binaryTrainTrees, trainTreeFile);
                Timing.tick("done.");
            }
            catch (Exception e) {
                System.err.println("Problem writing out binary trees.");
            }
        }
        return new ParserData(lex, bg, ug, dg, numbs, this.op);
    }

    protected final ParserData getParserDataFromTreebank(Treebank trainTreebank, DiskTreebank secondaryTrainTreebank, double weight, GrammarCompactor compactor) {
        System.err.println("Currently " + new Date());
        LexicalizedParser.printOptions(true, this.op);
        Timing.startTime();
        TreebankLangParserParams tlpParams = this.op.tlpParams;
        TreebankLanguagePack tlp = tlpParams.treebankLanguagePack();
        if (Test.verbose) {
            PrintWriter pwErr = tlpParams.pw(System.err);
            pwErr.print("Training ");
            pwErr.println(trainTreebank.textualSummary(tlp));
            pwErr.print("Secondary training ");
            pwErr.println(secondaryTrainTreebank.textualSummary(tlp));
        }
        CompositeTreeTransformer trainTransformer = new CompositeTreeTransformer();
        if (Train.collinsPunc) {
            CollinsPuncTransformer collinsPuncTransformer = new CollinsPuncTransformer(tlp);
            trainTransformer.addTransformer(collinsPuncTransformer);
        }
        TreeAnnotatorAndBinarizer binarizer = !Train.leftToRight ? new TreeAnnotatorAndBinarizer(tlpParams, this.op.forceCNF, !Train.outsideFactor(), true) : new TreeAnnotatorAndBinarizer(tlpParams.headFinder(), (HeadFinder)new LeftHeadFinder(), tlpParams, this.op.forceCNF, !Train.outsideFactor(), true);
        trainTransformer.addTransformer(binarizer);
        CompositeTreebank wholeTreebank = new CompositeTreebank(trainTreebank, secondaryTrainTreebank);
        if (Train.selectiveSplit) {
            Train.splitters = ParentAnnotationStats.getSplitCategories(wholeTreebank, Train.tagSelectiveSplit, 0, Train.selectiveSplitCutOff, Train.tagSelectiveSplitCutOff, tlp);
            LexicalizedParser.removeDeleteSplittersFromSplitters(tlp);
            if (Test.verbose) {
                ArrayList<String> list = new ArrayList<String>(Train.splitters);
                Collections.sort(list);
                System.err.println("Parent split categories: " + list);
            }
        }
        Treebank transformedWholeTreebank = wholeTreebank;
        if (Train.selectivePostSplit) {
            TreeAnnotator annotator = new TreeAnnotator(tlpParams.headFinder(), tlpParams);
            transformedWholeTreebank = transformedWholeTreebank.transform(annotator);
            Train.postSplitters = ParentAnnotationStats.getSplitCategories(transformedWholeTreebank, true, 0, Train.selectivePostSplitCutOff, Train.tagSelectivePostSplitCutOff, tlp);
            if (Test.verbose) {
                System.err.println("Parent post annotation split categories: " + Train.postSplitters);
            }
        }
        if (Train.hSelSplit) {
            int ptt = Train.printTreeTransformations;
            Train.printTreeTransformations = 0;
            binarizer.setDoSelectiveSplit(false);
            for (Tree tree : transformedWholeTreebank) {
                trainTransformer.transformTree(tree);
            }
            binarizer.setDoSelectiveSplit(true);
            Train.printTreeTransformations = ptt;
        }
        trainTreebank = trainTreebank.transform(trainTransformer);
        Treebank transformedSecondaryTrainTreebank = secondaryTrainTreebank.transform(trainTransformer);
        BinaryGrammarExtractor bgExtractor = new BinaryGrammarExtractor();
        MLEDependencyGrammarExtractor dgExtractor = new MLEDependencyGrammarExtractor(this.op);
        System.err.print("Extracting PCFG...");
        Pair<UnaryGrammar, BinaryGrammar> bgug = (Pair<UnaryGrammar, BinaryGrammar>)bgExtractor.extract(trainTreebank, transformedSecondaryTrainTreebank, weight);
        Timing.tick("done.");
        if (compactor != null) {
            System.err.print("Compacting grammar...");
            bgug = compactor.compactGrammar(bgug);
            Timing.tick("done.");
        }
        System.err.print("Compiling grammar...");
        BinaryGrammar bg = (BinaryGrammar)bgug.second;
        bg.splitRules();
        UnaryGrammar ug = (UnaryGrammar)bgug.first;
        ug.purgeRules();
        Timing.tick("done");
        System.err.print("Extracting Lexicon...");
        Lexicon lex = this.op.tlpParams.lex(this.op.lexOptions);
        CompositeTreebank wholeBinaryTreebank = new CompositeTreebank(trainTreebank, transformedSecondaryTrainTreebank);
        lex.train(wholeBinaryTreebank);
        Timing.tick("done.");
        DependencyGrammar dg = null;
        if (this.op.doDep) {
            System.err.print("Extracting Dependencies...");
            dg = (DependencyGrammar)dgExtractor.extract(trainTreebank, transformedSecondaryTrainTreebank, weight);
            Timing.tick("done.");
        }
        Map<String, Numberer> numbs = Numberer.getNumberers();
        System.err.println("Done training parser.");
        return new ParserData(lex, bg, ug, dg, numbs, this.op);
    }

    public void reset() {
        this.makeParsers();
    }

    private void makeParsers() {
        ArabicTreebankLanguagePack tlp;
        if (this.pd == null) {
            throw new IllegalArgumentException("Error loading parser data: pd null");
        }
        Numberer.setNumberers(this.pd.numbs);
        BinaryGrammar bg = this.pd.bg;
        bg.splitRules();
        UnaryGrammar ug = this.pd.ug;
        Lexicon lex = this.pd.lex;
        DependencyGrammar dg = this.pd.dg;
        if (this.pd.pt.tlpParams.treebankLanguagePack() instanceof ArabicTreebankLanguagePack && (tlp = (ArabicTreebankLanguagePack)this.op.tlpParams.treebankLanguagePack()).getTokenizerFactory() != null) {
            try {
                ((ArabicTreebankLanguagePack)this.pd.pt.tlpParams.treebankLanguagePack()).setTokenizerFactory(tlp.getTokenizerFactory());
            }
            catch (Exception e) {
                System.err.println(" Attempt to apply command line options to serialized paresr failed; " + e.toString());
            }
        }
        this.op = this.pd.pt;
        if (this.op.doPCFG) {
            this.pparser = Test.iterativeCKY ? new IterativeCKYPCFGParser(bg, ug, lex, this.op) : new ExhaustivePCFGParser(bg, ug, lex, this.op);
        }
        if (this.op.doDep) {
            dg.setLexicon(lex);
            if (!Test.useFastFactored) {
                this.dparser = new ExhaustiveDependencyParser(dg, lex, this.op);
            }
            if (this.op.doPCFG) {
                if (Test.useFastFactored) {
                    MLEDependencyGrammar mledg = (MLEDependencyGrammar)dg;
                    int numToFind = 1;
                    if (Test.printFactoredKGood > 0) {
                        numToFind = Test.printFactoredKGood;
                    }
                    this.bparser = new FastFactoredParser(this.pparser, mledg, this.op, numToFind);
                } else {
                    TwinScorer scorer = new TwinScorer(this.pparser, this.dparser);
                    this.bparser = Test.useN5 ? new BiLexPCFGParser.N5BiLexPCFGParser(scorer, this.pparser, this.dparser, bg, ug, dg, lex, this.op) : new BiLexPCFGParser(scorer, this.pparser, this.dparser, bg, ug, dg, lex, this.op);
                }
            }
        }
        this.fallbackToPCFG = true;
        this.debinarizer = new Debinarizer(this.op.forceCNF, new CategoryWordTagFactory());
        this.subcategoryStripper = this.op.tlpParams.subcategoryStripper();
    }

    static Sentence<? extends HasWord> getInputSentence(Tree t) {
        if (Test.forceTags) {
            if (Test.preTag) {
                throw new RuntimeException("Sorry -- haven't implemented support for external tagger yet.");
            }
            if (Test.noFunctionalForcing) {
                Sentence<TaggedWord> s = t.taggedYield();
                for (HasWord hasWord : s) {
                    String tag = ((HasTag)((Object)hasWord)).tag();
                    tag = tag.split("-")[0];
                    ((HasTag)((Object)hasWord)).setTag(tag);
                }
                return s;
            }
            return t.taggedYield();
        }
        return t.yield();
    }

    private static int numSubArgs(String[] args, int index) {
        int i = index;
        while (i + 1 < args.length && args[i + 1].charAt(0) != '-') {
            ++i;
        }
        return i - index;
    }

    private static void printOutOfMemory(PrintWriter pw) {
        pw.println();
        pw.println("*******************************************************");
        pw.println("***  WARNING!! OUT OF MEMORY! THERE WAS NOT ENOUGH  ***");
        pw.println("***  MEMORY TO RUN ALL PARSERS.  EITHER GIVE THE    ***");
        pw.println("***  JVM MORE MEMORY, SET THE MAXIMUM SENTENCE      ***");
        pw.println("***  LENGTH WITH -maxLength, OR PERHAPS YOU ARE     ***");
        pw.println("***  HAPPY TO HAVE THE PARSER FALL BACK TO USING    ***");
        pw.println("***  A SIMPLER PARSER FOR VERY LONG SENTENCES.      ***");
        pw.println("*******************************************************");
        pw.println();
    }

    public double testOnTreebank(Treebank testTreebank) {
        System.err.println("Testing on treebank");
        Timing treebankTotalTtimer = new Timing();
        TreePrint treePrint = this.getTreePrint();
        TreebankLangParserParams tlpParams = this.op.tlpParams;
        TreebankLanguagePack tlp = this.op.langpack();
        PrintWriter pwOut = tlpParams.pw();
        PrintWriter pwErr = tlpParams.pw(System.err);
        if (Test.verbose) {
            pwErr.print("Testing ");
            pwErr.println(testTreebank.textualSummary(tlp));
        }
        if (Test.evalb) {
            EvalB.initEVALBfiles(tlpParams);
        }
        TreeTransformer tc = tlpParams.collinizer();
        BoundaryRemover br = new BoundaryRemover();
        boolean runningAverages = Boolean.parseBoolean(Test.evals.getProperty("runningAverages"));
        boolean summary = Boolean.parseBoolean(Test.evals.getProperty("summary"));
        boolean tsv = Boolean.parseBoolean(Test.evals.getProperty("tsv"));
        LabeledConstituentEval pcfgLB = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("pcfgLB"))) {
            pcfgLB = new LabeledConstituentEval("pcfg LP/LR", runningAverages, tlp);
        }
        LabeledConstituentEval.CBEval pcfgCB = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("pcfgCB"))) {
            pcfgCB = new LabeledConstituentEval.CBEval("pcfg CB", runningAverages, tlp);
        }
        AbstractEval.DependencyEval pcfgDA = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("pcfgDA"))) {
            pcfgDA = new AbstractEval.DependencyEval("pcfg DA", runningAverages, tlp.punctuationWordAcceptFilter());
        }
        AbstractEval.TaggingEval pcfgTA = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("pcfgTA"))) {
            pcfgTA = new AbstractEval.TaggingEval("pcfg Tag", runningAverages, this.pd.lex);
        }
        AbstractEval.DependencyEval depDA = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("depDA"))) {
            depDA = new AbstractEval.DependencyEval("dep DA", runningAverages, tlp.punctuationWordAcceptFilter());
        }
        AbstractEval.TaggingEval depTA = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("depTA"))) {
            depTA = new AbstractEval.TaggingEval("dep Tag", runningAverages, this.pd.lex, true);
        }
        LabeledConstituentEval factLB = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("factLB"))) {
            factLB = new LabeledConstituentEval("factor LP/LR", runningAverages, tlp);
        }
        LabeledConstituentEval.CBEval factCB = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("factCB"))) {
            factCB = new LabeledConstituentEval.CBEval("fact CB", runningAverages, tlp);
        }
        AbstractEval.DependencyEval factDA = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("factDA"))) {
            factDA = new AbstractEval.DependencyEval("factor DA", runningAverages, tlp.punctuationWordAcceptFilter());
        }
        AbstractEval.TaggingEval factTA = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("factTA"))) {
            factTA = this.op.doPCFG ? new AbstractEval.TaggingEval("factor Tag", runningAverages, this.pd.lex) : new AbstractEval.TaggingEval("factor Tag", runningAverages, this.pd.lex, true);
        }
        AbstractEval.RuleErrorEval pcfgRUO = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("pcfgRUO"))) {
            pcfgRUO = new AbstractEval.RuleErrorEval("pcfg Rule under/over");
        }
        AbstractEval.CatErrorEval pcfgCUO = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("pcfgCUO"))) {
            pcfgCUO = new AbstractEval.CatErrorEval("pcfg Category under/over");
        }
        ConstituentEvalByCat pcfgCatE = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("pcfgCatE"))) {
            pcfgCatE = new ConstituentEvalByCat("pcfg Category Eval", tlp, runningAverages);
        }
        AbstractEval.ScoreEval pcfgLL = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("pcfgLL"))) {
            pcfgLL = new AbstractEval.ScoreEval("pcfgLL", runningAverages);
        }
        AbstractEval.ScoreEval depLL = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("depLL"))) {
            depLL = new AbstractEval.ScoreEval("depLL", runningAverages);
        }
        AbstractEval.ScoreEval factLL = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("factLL"))) {
            factLL = new AbstractEval.ScoreEval("factLL", runningAverages);
        }
        LabeledConstituentEval kGoodLB = new LabeledConstituentEval("kGood LP/LR", false, tlp);
        TreeAnnotatorAndBinarizer binarizerOnly = !Train.leftToRight ? new TreeAnnotatorAndBinarizer(tlpParams, this.op.forceCNF, false, false) : new TreeAnnotatorAndBinarizer(tlpParams.headFinder(), (HeadFinder)new LeftHeadFinder(), tlpParams, this.op.forceCNF, false, false);
        boolean saidMemMessage = false;
        Timing timer = new Timing();
        for (Tree goldTree : testTreebank) {
            boolean outsideLengthBound = false;
            Sentence<? extends HasWord> s = LexicalizedParser.getInputSentence(goldTree);
            timer.start();
            pwErr.println("Parsing [len. " + s.length() + "]: " + s);
            Tree tree = null;
            try {
                if (!this.parse(s)) {
                    pwErr.print("Sentence couldn't be parsed by grammar.");
                    if (this.pparser != null && this.pparser.hasParse() && this.fallbackToPCFG) {
                        pwErr.println("... falling back to PCFG parse.");
                        tree = this.getBestPCFGParse();
                    } else {
                        pwErr.println();
                    }
                } else {
                    tree = this.getBestParse();
                    if (this.bparser != null) {
                        pwErr.println("FactoredParser parse score is " + this.bparser.getBestScore());
                    }
                }
            }
            catch (OutOfMemoryError e) {
                if (Test.maxLength != 559038737) {
                    pwErr.print("NOT ENOUGH MEMORY TO PARSE SENTENCES OF LENGTH ");
                    pwErr.println(Test.maxLength);
                    throw e;
                }
                if (!saidMemMessage) {
                    LexicalizedParser.printOutOfMemory(pwErr);
                    saidMemMessage = true;
                }
                if (this.pparser.hasParse() && this.fallbackToPCFG) {
                    try {
                        String what = "dependency";
                        if (this.dparser.hasParse()) {
                            what = "factored";
                        }
                        pwErr.println("Sentence too long for " + what + " parser.  Falling back to PCFG parse...");
                        tree = this.getBestPCFGParse();
                    }
                    catch (OutOfMemoryError oome) {
                        oome.printStackTrace();
                        pwErr.println("No memory to gather PCFG parse. Skipping...");
                        this.pparser.nudgeDownArraySize();
                    }
                } else {
                    pwErr.println("Sentence has no parse using PCFG grammar (or no PCFG fallback).  Skipping...");
                }
                pwErr.println();
            }
            catch (UnsupportedOperationException uoe) {
                pwErr.println("Sentence too long (or zero words).");
                outsideLengthBound = true;
            }
            if (Test.verbose) {
                pwOut.println("ComboParser best");
                Tree ot = tree;
                if (ot != null && !tlpParams.treebankLanguagePack().isStartSymbol(ot.value())) {
                    ot = ot.treeFactory().newTreeNode(tlpParams.treebankLanguagePack().startSymbol(), Collections.singletonList(ot));
                }
                treePrint.printTree(ot, pwOut);
            } else {
                treePrint.printTree(tree, pwOut);
            }
            if (tree != null) {
                Tree tbtr;
                Tree tbd;
                List<ScoredObject<Tree>> trees;
                List<ScoredObject<Tree>> parses;
                int sz;
                if (Test.printAllBestParses && (sz = (parses = this.pparser.getBestParses()).size()) > 1) {
                    pwOut.println("There were " + sz + " best PCFG parses with score " + parses.get(0).score() + '.');
                    Tree transGoldTree = tc.transformTree(goldTree);
                    int iii = 0;
                    for (ScoredObject<Tree> sot : parses) {
                        Tree tb = sot.object();
                        Tree tbd2 = this.debinarizer.transformTree(tb);
                        tbd2 = this.subcategoryStripper.transformTree(tbd2);
                        pwOut.println("PCFG Parse #" + ++iii + " with score " + tbd2.score());
                        tbd2.pennPrint(pwOut);
                        Tree tbtr2 = tc.transformTree(tbd2);
                        ((AbstractEval)kGoodLB).evaluate(tbtr2, transGoldTree, pwErr);
                    }
                }
                if (Test.printPCFGkBest > 0) {
                    trees = this.getKBestPCFGParses(Test.printPCFGkBest);
                    Tree transGoldTree = tc.transformTree(goldTree);
                    int i = 0;
                    for (ScoredObject<Tree> tp : trees) {
                        pwOut.println("PCFG Parse #" + ++i + " with score " + tp.score());
                        tbd = tp.object();
                        tbd.pennPrint(pwOut);
                        tbtr = tc.transformTree(tbd);
                        ((AbstractEval)kGoodLB).evaluate(tbtr, transGoldTree, pwErr);
                    }
                }
                if (Test.printFactoredKGood > 0 && this.bparser.hasParse()) {
                    trees = this.getKGoodFactoredParses(Test.printFactoredKGood);
                    Tree transGoldTree = tc.transformTree(goldTree);
                    int ii = 0;
                    for (ScoredObject<Tree> tp : trees) {
                        pwOut.println("Factored Parse #" + ++ii + " with score " + tp.score());
                        tbd = tp.object();
                        tbd.pennPrint(pwOut);
                        tbtr = tc.transformTree(tbd);
                        ((AbstractEval)kGoodLB).evaluate(tbtr, transGoldTree, pwOut);
                    }
                }
            }
            if (Test.verbose && !outsideLengthBound) {
                pwOut.println("Correct parse");
                treePrint.printTree(goldTree, pwOut);
            }
            timer.report("Parsing Sentence");
            if (tree != null) {
                Tree treeDep;
                Tree transGoldTree = tc.transformTree(goldTree);
                if (transGoldTree != null) {
                    transGoldTree = this.subcategoryStripper.transformTree(transGoldTree);
                }
                if (transGoldTree == null) {
                    pwErr.println("Couldn't transform gold tree for evaluation, skipping eval. Gold tree was:");
                    goldTree.pennPrint(pwErr);
                    continue;
                }
                Tree treePCFG = this.getBestPCFGParse();
                if (treePCFG != null) {
                    Tree treePCFGeval = tc.transformTree(treePCFG);
                    if (pcfgLB != null) {
                        ((AbstractEval)pcfgLB).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgCB != null) {
                        ((AbstractEval)pcfgCB).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgDA != null) {
                        Tree pcfgTreeB = this.pparser.getBestParse();
                        Tree cwtPCFGTreeB = pcfgTreeB.deeperCopy(new LabeledScoredTreeFactory(), new CategoryWordTagFactory());
                        cwtPCFGTreeB.percolateHeads(tlpParams.headFinder());
                        Tree goldTreeB = binarizerOnly.transformTree(goldTree);
                        pcfgDA.evaluate(cwtPCFGTreeB, goldTreeB, pwErr);
                    }
                    if (pcfgTA != null) {
                        ((AbstractEval)pcfgTA).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgLL != null && this.pparser != null) {
                        pcfgLL.recordScore(this.pparser, pwErr);
                    }
                    if (pcfgRUO != null) {
                        ((AbstractEval)pcfgRUO).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgCUO != null) {
                        ((AbstractEval)pcfgCUO).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                    if (pcfgCatE != null) {
                        ((AbstractEval)pcfgCatE).evaluate(treePCFGeval, transGoldTree, pwErr);
                    }
                }
                if ((treeDep = this.getBestDependencyParse()) != null) {
                    Tree goldTreeB = binarizerOnly.transformTree(goldTree);
                    if (depDA != null) {
                        depDA.evaluate(treeDep, goldTreeB, pwErr);
                    }
                    if (depTA != null) {
                        Tree undoneTree = this.debinarizer.transformTree(treeDep);
                        undoneTree = this.subcategoryStripper.transformTree(undoneTree);
                        ((AbstractEval)depTA).evaluate(undoneTree, goldTree, pwErr);
                    }
                    if (depLL != null && this.dparser != null) {
                        depLL.recordScore(this.dparser, pwErr);
                    }
                    Tree factTreeB = this.bparser != null && parseSucceeded ? this.bparser.getBestParse() : treeDep;
                    if (factDA != null) {
                        factDA.evaluate(factTreeB, goldTreeB, pwErr);
                    }
                }
                if (factLB != null) {
                    factLB.evaluate(tc.transformTree(tree), transGoldTree, pwErr);
                }
                if (factTA != null) {
                    ((AbstractEval)factTA).evaluate(tree, br.transformTree(goldTree), pwErr);
                }
                if (factLL != null && this.bparser != null) {
                    factLL.recordScore(this.bparser, pwErr);
                }
                if (factCB != null) {
                    ((AbstractEval)factCB).evaluate(tc.transformTree(tree), transGoldTree, pwErr);
                }
                if (Test.evalb) {
                    LexicalizedParser.nanScores(tree);
                    EvalB.writeEVALBline(goldTree, tree);
                }
            }
            pwErr.println();
        }
        treebankTotalTtimer.done("Testing on treebank");
        if (saidMemMessage) {
            LexicalizedParser.printOutOfMemory(pwErr);
        }
        if (Test.evalb) {
            EvalB.closeEVALBfiles();
        }
        if (summary) {
            if (pcfgLB != null) {
                pcfgLB.display(false, pwErr);
            }
            if (pcfgCB != null) {
                ((AbstractEval)pcfgCB).display(false, pwErr);
            }
            if (pcfgDA != null) {
                pcfgDA.display(false, pwErr);
            }
            if (pcfgTA != null) {
                pcfgTA.display(false, pwErr);
            }
            if (pcfgLL != null && this.pparser != null) {
                pcfgLL.display(false, pwErr);
            }
            if (depDA != null) {
                depDA.display(false, pwErr);
            }
            if (depTA != null) {
                depTA.display(false, pwErr);
            }
            if (depLL != null && this.dparser != null) {
                depLL.display(false, pwErr);
            }
            if (factLB != null) {
                factLB.display(false, pwErr);
            }
            if (factCB != null) {
                ((AbstractEval)factCB).display(false, pwErr);
            }
            if (factDA != null) {
                factDA.display(false, pwErr);
            }
            if (factTA != null) {
                factTA.display(false, pwErr);
            }
            if (factLL != null && this.bparser != null) {
                factLL.display(false, pwErr);
            }
            if (pcfgCatE != null) {
                ((AbstractEval)pcfgCatE).display(false, pwErr);
            }
        }
        if (pcfgRUO != null) {
            ((AbstractEval)pcfgRUO).display(true, pwErr);
        }
        if (pcfgCUO != null) {
            ((AbstractEval)pcfgCUO).display(true, pwErr);
        }
        if (tsv) {
            DecimalFormat nf = new DecimalFormat("0.00");
            pwErr.println("factF1\tfactDA\tfactEx\tpcfgF1\tdepDA\tfactTA\tnum");
            if (factLB != null) {
                pwErr.print(nf.format(factLB.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (this.dparser != null && factDA != null) {
                pwErr.print(nf.format(factDA.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (factLB != null) {
                pwErr.print(nf.format(factLB.getExactPercent()));
            }
            pwErr.print("\t");
            if (pcfgLB != null) {
                pwErr.print(nf.format(pcfgLB.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (this.dparser != null && depDA != null) {
                pwErr.print(nf.format(depDA.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (factTA != null) {
                pwErr.print(nf.format(factTA.getEvalbF1Percent()));
            }
            pwErr.print("\t");
            if (factLB != null) {
                pwErr.print(factLB.getNum());
            }
            pwErr.println();
        }
        double f1 = 0.0;
        if (factLB != null) {
            f1 = factLB.getEvalbF1();
        }
        return f1;
    }

    private static void nanScores(Tree tree) {
        tree.setScore(Double.NaN);
        Tree[] kids = tree.children();
        for (int i = 0; i < kids.length; ++i) {
            LexicalizedParser.nanScores(kids[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseFiles(String[] args, int argIndex, boolean tokenized, TokenizerFactory<? extends HasWord> tokenizerFactory, DocumentPreprocessor documentPreprocessor, String elementDelimiter, String sentenceDelimiter, Function<List<HasWord>, List<HasWord>> escaper, int tagDelimiter) {
        PrintWriter pwOut = this.op.tlpParams.pw();
        PrintWriter pwErr = this.op.tlpParams.pw(System.err);
        TreePrint treePrint = this.getTreePrint();
        int numWords = 0;
        int numSents = 0;
        int numUnparsable = 0;
        int numNoMemory = 0;
        int numFallback = 0;
        int numSkipped = 0;
        Timing timer = new Timing();
        TreebankLanguagePack tlp = this.op.tlpParams.treebankLanguagePack();
        if (tokenized) {
            tokenizerFactory = WhitespaceTokenizer.factory();
        }
        if (tokenizerFactory == null) {
            tokenizerFactory = tlp.getTokenizerFactory();
        }
        if (Test.verbose) {
            System.err.println("parseFiles: Tokenizer factory is: " + tokenizerFactory);
            System.err.println("Sentence final words are: " + Arrays.asList(tlp.sentenceFinalPunctuationWords()));
            System.err.println("File encoding is: " + this.op.tlpParams.getInputEncoding());
        }
        documentPreprocessor.setTokenizerFactory(tokenizerFactory);
        documentPreprocessor.setSentenceFinalPuncWords(tlp.sentenceFinalPunctuationWords());
        documentPreprocessor.setEncoding(this.op.tlpParams.getInputEncoding());
        boolean saidMemMessage = false;
        boolean runningAverages = Boolean.parseBoolean(Test.evals.getProperty("runningAverages"));
        boolean summary = Boolean.parseBoolean(Test.evals.getProperty("summary"));
        AbstractEval.ScoreEval pcfgLL = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("pcfgLL"))) {
            pcfgLL = new AbstractEval.ScoreEval("pcfgLL", runningAverages);
        }
        AbstractEval.ScoreEval depLL = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("depLL"))) {
            depLL = new AbstractEval.ScoreEval("depLL", runningAverages);
        }
        AbstractEval.ScoreEval factLL = null;
        if (Boolean.parseBoolean(Test.evals.getProperty("factLL"))) {
            factLL = new AbstractEval.ScoreEval("factLL", runningAverages);
        }
        timer.start();
        for (int i = argIndex; i < args.length; ++i) {
            String filename = args[i];
            try {
                List<Object> document;
                BufferedReader in = null;
                if (filename.equals("-")) {
                    document = Generics.newArrayList();
                    in = new BufferedReader(new InputStreamReader(System.in));
                } else {
                    document = elementDelimiter != null ? documentPreprocessor.getSentencesFromXML(filename, escaper, elementDelimiter, sentenceDelimiter) : documentPreprocessor.getSentencesFromText(filename, escaper, sentenceDelimiter, tagDelimiter);
                }
                System.err.println("Parsing file: " + filename + " with " + document.size() + " sentences.");
                PrintWriter pwo = pwOut;
                if (Test.writeOutputFiles) {
                    String ext = Test.outputFilesExtension == null ? "stp" : Test.outputFilesExtension;
                    String fname = filename + '.' + ext;
                    if (Test.outputFilesDirectory != null) {
                        void var34_42;
                        String string = System.getProperty("file.separator");
                        if (string == null || "".equals(string)) {
                            String string2 = "/";
                        }
                        int ind = fname.lastIndexOf((String)var34_42);
                        fname = fname.substring(ind + 1);
                        if (!"".equals(Test.outputFilesDirectory)) {
                            fname = Test.outputFilesDirectory + (String)var34_42 + fname;
                        }
                    }
                    try {
                        pwo = this.op.tlpParams.pw(new FileOutputStream(fname));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                treePrint.printHeader(pwo, this.op.tlpParams.getOutputEncoding());
                int num = 0;
                do {
                    if (in != null) {
                        document.clear();
                        String line = in.readLine();
                        if (line == null) {
                            in.close();
                            in = null;
                            break;
                        }
                        document.add(documentPreprocessor.getWordsFromString(line));
                    }
                    for (List list : document) {
                        List<ScoredObject<Tree>> trees;
                        ++numSents;
                        int len = list.size();
                        numWords += len;
                        pwErr.println("Parsing [sent. " + ++num + " len. " + len + "]: " + list);
                        Tree ansTree = null;
                        try {
                            if (!this.parse(list)) {
                                pwErr.print("Sentence couldn't be parsed by grammar.");
                                if (this.pparser != null && this.pparser.hasParse() && this.fallbackToPCFG) {
                                    pwErr.println("... falling back to PCFG parse.");
                                    ansTree = this.getBestPCFGParse();
                                    ++numFallback;
                                } else {
                                    pwErr.println();
                                    ++numUnparsable;
                                }
                            } else {
                                ansTree = this.getBestParse();
                            }
                            if (pcfgLL != null && this.pparser != null) {
                                pcfgLL.recordScore(this.pparser, pwErr);
                            }
                            if (depLL != null && this.dparser != null) {
                                depLL.recordScore(this.dparser, pwErr);
                            }
                            if (factLL != null && this.bparser != null) {
                                factLL.recordScore(this.bparser, pwErr);
                            }
                        }
                        catch (OutOfMemoryError e) {
                            if (Test.maxLength != 559038737) {
                                pwErr.println("NOT ENOUGH MEMORY TO PARSE SENTENCES OF LENGTH " + Test.maxLength);
                                pwo.println("NOT ENOUGH MEMORY TO PARSE SENTENCES OF LENGTH " + Test.maxLength);
                                throw e;
                            }
                            if (!saidMemMessage) {
                                LexicalizedParser.printOutOfMemory(pwErr);
                                saidMemMessage = true;
                            }
                            if (this.pparser.hasParse() && this.fallbackToPCFG) {
                                try {
                                    String what = "dependency";
                                    if (this.dparser.hasParse()) {
                                        what = "factored";
                                    }
                                    pwErr.println("Sentence too long for " + what + " parser.  Falling back to PCFG parse...");
                                    ansTree = this.getBestPCFGParse();
                                    ++numFallback;
                                }
                                catch (OutOfMemoryError oome) {
                                    oome.printStackTrace();
                                    ++numNoMemory;
                                    pwErr.println("No memory to gather PCFG parse. Skipping...");
                                    pwo.println("Sentence skipped:  no PCFG fallback.");
                                    this.pparser.nudgeDownArraySize();
                                }
                            } else {
                                pwErr.println("Sentence has no parse using PCFG grammar (or no PCFG fallback).  Skipping...");
                                pwo.println("Sentence skipped: no PCFG fallback.");
                                ++numSkipped;
                            }
                        }
                        catch (UnsupportedOperationException uoe) {
                            pwErr.println("Sentence too long (or zero words).");
                            pwo.println("Sentence skipped: too long (or zero words).");
                            numWords -= len;
                            ++numSkipped;
                        }
                        try {
                            treePrint.printTree(ansTree, Integer.toString(num), pwo);
                        }
                        catch (RuntimeException re) {
                            pwErr.println("TreePrint.printTree skipped: out of memory");
                            re.printStackTrace();
                            ++numNoMemory;
                            try {
                                treePrint.printTree(null, Integer.toString(num), pwo);
                            }
                            catch (Exception e) {
                                pwo.println("Sentence skipped: out of memory and error calling TreePrint.");
                                e.printStackTrace();
                            }
                        }
                        if (Test.printPCFGkBest > 0 && this.pparser.hasParse()) {
                            trees = this.getKBestPCFGParses(Test.printPCFGkBest);
                            treePrint.printTrees(trees, Integer.toString(num), pwo);
                            continue;
                        }
                        if (Test.printFactoredKGood <= 0 || !this.bparser.hasParse()) continue;
                        trees = this.getKGoodFactoredParses(Test.printFactoredKGood);
                        treePrint.printTrees(trees, Integer.toString(num), pwo);
                    }
                } while (in != null);
                treePrint.printFooter(pwo);
                if (Test.writeOutputFiles) {
                    pwo.close();
                }
                System.err.println("Parsed file: " + filename + " [" + num + " sentences].");
                continue;
            }
            catch (IOException e) {
                pwErr.println("ERROR: Couldn't open file: " + filename);
            }
        }
        long millis = timer.stop();
        if (summary) {
            if (pcfgLL != null) {
                pcfgLL.display(false, pwErr);
            }
            if (depLL != null) {
                depLL.display(false, pwErr);
            }
            if (factLL != null) {
                factLL.display(false, pwErr);
            }
        }
        if (saidMemMessage) {
            LexicalizedParser.printOutOfMemory(pwErr);
        }
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        double sentspersec = (double)numSents / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        pwErr.println("Parsed " + numWords + " words in " + numSents + " sentences (" + nf.format(wordspersec) + " wds/sec; " + nf.format(sentspersec) + " sents/sec).");
        if (numFallback > 0) {
            pwErr.println("  " + numFallback + " sentences were parsed by fallback to PCFG.");
        }
        if (numUnparsable > 0 || numNoMemory > 0 || numSkipped > 0) {
            pwErr.println("  " + (numUnparsable + numNoMemory + numSkipped) + " sentences were not parsed:");
            if (numUnparsable > 0) {
                pwErr.println("    " + numUnparsable + " were not parsable with non-zero probability.");
            }
            if (numNoMemory > 0) {
                pwErr.println("    " + numNoMemory + " were skipped because of insufficient memory.");
            }
            if (numSkipped > 0) {
                pwErr.println("    " + numSkipped + " were skipped as length 0 or greater than " + Test.maxLength);
            }
        }
    }

    public void setOptionFlags(String ... flags) {
        this.op.setOptions(flags);
    }

    private static void printArgs(String[] args, PrintStream ps) {
        ps.print("LexicalizedParser invoked with arguments:");
        for (String arg : args) {
            ps.print(' ' + arg);
        }
        ps.println();
    }

    public static void main(String[] args) {
        boolean train = false;
        boolean saveToSerializedFile = false;
        boolean saveToTextFile = false;
        String serializedInputFileOrUrl = null;
        String textInputFileOrUrl = null;
        String serializedOutputFileOrUrl = null;
        String textOutputFileOrUrl = null;
        String treebankPath = null;
        MemoryTreebank testTreebank = null;
        MemoryTreebank tuneTreebank = null;
        String testPath = null;
        FileFilter testFilter = null;
        String tunePath = null;
        FileFilter tuneFilter = null;
        FileFilter trainFilter = null;
        String secondaryTreebankPath = null;
        double secondaryTreebankWeight = 1.0;
        NumberRangesFileFilter secondaryTrainFilter = null;
        TokenizerFactory tokenizerFactory = null;
        DocumentPreprocessor documentPreprocessor = new DocumentPreprocessor();
        boolean tokenized = false;
        Function escaper = null;
        int tagDelimiter = -1;
        String sentenceDelimiter = null;
        String elementDelimiter = null;
        int argIndex = 0;
        if (args.length < 1) {
            System.err.println("usage: java edu.stanford.nlp.parser.lexparser.LexicalizedParser parserFileOrUrl filename*");
            return;
        }
        Options op = new Options();
        String encoding = null;
        while (argIndex < args.length && args[argIndex].charAt(0) == '-') {
            int high;
            int low;
            if (args[argIndex].equalsIgnoreCase("-train") || args[argIndex].equalsIgnoreCase("-trainTreebank")) {
                train = true;
                int numSubArgs = LexicalizedParser.numSubArgs(args, argIndex);
                ++argIndex;
                if (numSubArgs >= 1) {
                    treebankPath = args[argIndex];
                    ++argIndex;
                } else {
                    throw new RuntimeException("Error: -train option must have treebankPath as first argument.");
                }
                if (numSubArgs == 2) {
                    trainFilter = new NumberRangesFileFilter(args[argIndex++], true);
                    continue;
                }
                if (numSubArgs < 3) continue;
                try {
                    low = Integer.parseInt(args[argIndex]);
                    high = Integer.parseInt(args[argIndex + 1]);
                    trainFilter = new NumberRangeFileFilter(low, high, true);
                    argIndex += 2;
                }
                catch (NumberFormatException e) {
                    trainFilter = new NumberRangesFileFilter(args[argIndex], true);
                    ++argIndex;
                }
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-train2")) {
                int numSubArgs = LexicalizedParser.numSubArgs(args, argIndex);
                ++argIndex;
                if (numSubArgs < 3) {
                    throw new RuntimeException("Error: -train2 <treebankPath> <ranges> <weight>.");
                }
                secondaryTreebankPath = args[argIndex++];
                secondaryTrainFilter = new NumberRangesFileFilter(args[argIndex++], true);
                secondaryTreebankWeight = Double.parseDouble(args[argIndex++]);
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tLPP") && argIndex + 1 < args.length) {
                try {
                    op.tlpParams = (TreebankLangParserParams)Class.forName(args[argIndex + 1]).newInstance();
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Class not found: " + args[argIndex + 1]);
                }
                catch (InstantiationException e) {
                    System.err.println("Couldn't instantiate: " + args[argIndex + 1] + ": " + e.toString());
                }
                catch (IllegalAccessException e) {
                    System.err.println("Illegal access" + e);
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-encoding")) {
                encoding = args[argIndex + 1];
                op.tlpParams.setInputEncoding(encoding);
                op.tlpParams.setOutputEncoding(encoding);
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-useBasicCategoryTagsInDependencyGrammar")) {
                basicCategoryTagsInDependencyGrammar = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tokenized")) {
                tokenized = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-escaper")) {
                try {
                    escaper = (Function)Class.forName(args[argIndex + 1]).newInstance();
                }
                catch (Exception e) {
                    System.err.println("Couldn't instantiate escaper " + args[argIndex + 1] + ": " + e);
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tokenizerFactory")) {
                try {
                    tokenizerFactory = (TokenizerFactory)Class.forName(args[argIndex + 1]).newInstance();
                }
                catch (Exception e) {
                    System.err.println("Couldn't instantiate TokenizerFactory " + args[argIndex + 1]);
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-sentences")) {
                sentenceDelimiter = args[argIndex + 1];
                if (sentenceDelimiter.equalsIgnoreCase("newline")) {
                    sentenceDelimiter = "\n";
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-parseInside")) {
                elementDelimiter = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tagSeparator")) {
                tagDelimiter = args[argIndex + 1].charAt(0);
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-loadFromSerializedFile")) {
                serializedInputFileOrUrl = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-loadFromTextFile")) {
                textInputFileOrUrl = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-saveToSerializedFile")) {
                saveToSerializedFile = true;
                if (LexicalizedParser.numSubArgs(args, argIndex) < 1) {
                    System.err.println("Missing path: -saveToSerialized filename");
                } else {
                    serializedOutputFileOrUrl = args[argIndex + 1];
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-saveToTextFile")) {
                saveToTextFile = true;
                textOutputFileOrUrl = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-saveTrainTrees")) {
                trainTreeFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-trainLength")) {
                trainLengthLimit = Integer.parseInt(args[argIndex + 1]);
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-lengthNormalization")) {
                Test.lengthNormalization = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-treebank") || args[argIndex].equalsIgnoreCase("-testTreebank") || args[argIndex].equalsIgnoreCase("-test")) {
                int numSubArgs = LexicalizedParser.numSubArgs(args, argIndex);
                if (numSubArgs > 0 && numSubArgs < 3) {
                    int n = ++argIndex;
                    ++argIndex;
                    testPath = args[n];
                    if (numSubArgs == 2) {
                        testFilter = new NumberRangesFileFilter(args[argIndex++], true);
                        continue;
                    }
                    if (numSubArgs != 3) continue;
                    try {
                        low = Integer.parseInt(args[argIndex]);
                        high = Integer.parseInt(args[argIndex + 1]);
                        testFilter = new NumberRangeFileFilter(low, high, true);
                        argIndex += 2;
                    }
                    catch (NumberFormatException e) {
                        testFilter = new NumberRangesFileFilter(args[argIndex++], true);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Bad arguments after -testTreebank");
            }
            if (args[argIndex].equalsIgnoreCase("-tune")) {
                int numSubArgs = LexicalizedParser.numSubArgs(args, argIndex);
                ++argIndex;
                if (numSubArgs == 1) {
                    tuneFilter = new NumberRangesFileFilter(args[argIndex++], true);
                    continue;
                }
                if (numSubArgs <= 1) continue;
                tunePath = args[argIndex++];
                if (numSubArgs == 2) {
                    tuneFilter = new NumberRangesFileFilter(args[argIndex++], true);
                    continue;
                }
                if (numSubArgs < 3) continue;
                try {
                    low = Integer.parseInt(args[argIndex]);
                    high = Integer.parseInt(args[argIndex + 1]);
                    tuneFilter = new NumberRangeFileFilter(low, high, true);
                    argIndex += 2;
                }
                catch (NumberFormatException e) {
                    tuneFilter = new NumberRangesFileFilter(args[argIndex++], true);
                }
                continue;
            }
            argIndex = op.setOptionOrWarn(args, argIndex);
        }
        if (tuneFilter != null) {
            if (tunePath == null) {
                if (treebankPath == null) {
                    throw new RuntimeException("No tune treebank path specified...");
                }
                System.err.println("No tune treebank path specified.  Using train path: \"" + treebankPath + '\"');
                tunePath = treebankPath;
            }
            tuneTreebank = op.tlpParams.testMemoryTreebank();
            tuneTreebank.loadPath(tunePath, tuneFilter);
        }
        if (!train && Test.verbose) {
            System.err.println("Currently " + new Date());
            LexicalizedParser.printArgs(args, System.err);
        }
        LexicalizedParser lp = null;
        if (train) {
            LexicalizedParser.printArgs(args, System.err);
            ExactGrammarCompactor compactor = null;
            if (Train.compactGrammar() == 3) {
                compactor = new ExactGrammarCompactor(false, false);
            }
            Treebank trainTreebank = LexicalizedParser.makeTreebank(treebankPath, op, trainFilter);
            if (secondaryTreebankPath != null) {
                DiskTreebank secondaryTrainTreebank = LexicalizedParser.makeSecondaryTreebank(secondaryTreebankPath, op, secondaryTrainFilter);
                lp = new LexicalizedParser(trainTreebank, secondaryTrainTreebank, secondaryTreebankWeight, compactor, op);
            } else {
                lp = new LexicalizedParser(trainTreebank, compactor, op, tuneTreebank);
            }
        } else if (textInputFileOrUrl != null) {
            lp = new LexicalizedParser(textInputFileOrUrl, true, op);
        } else {
            if (serializedInputFileOrUrl == null && argIndex < args.length) {
                serializedInputFileOrUrl = args[argIndex];
                ++argIndex;
            }
            if (serializedInputFileOrUrl == null) {
                System.err.println("No grammar specified, exiting...");
                return;
            }
            try {
                lp = new LexicalizedParser(serializedInputFileOrUrl, op);
                op = lp.op;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error loading parser, exiting...");
                return;
            }
        }
        if (encoding != null) {
            op.tlpParams.setInputEncoding(encoding);
            op.tlpParams.setOutputEncoding(encoding);
        }
        if (testFilter != null || testPath != null) {
            if (testPath == null) {
                if (treebankPath == null) {
                    throw new RuntimeException("No test treebank path specified...");
                }
                System.err.println("No test treebank path specified.  Using train path: \"" + treebankPath + '\"');
                testPath = treebankPath;
            }
            testTreebank = op.tlpParams.testMemoryTreebank();
            testTreebank.loadPath(testPath, testFilter);
        }
        Train.sisterSplitters = new HashSet<String>(Arrays.asList(op.tlpParams.sisterSplitters()));
        if (saveToTextFile) {
            if (textOutputFileOrUrl != null) {
                LexicalizedParser.saveParserDataToText(lp.pd, textOutputFileOrUrl);
            } else {
                System.err.println("Usage: must specify a text grammar output path");
            }
        }
        if (saveToSerializedFile) {
            if (serializedOutputFileOrUrl != null) {
                LexicalizedParser.saveParserDataToSerialized(lp.pd, serializedOutputFileOrUrl);
            } else if (textOutputFileOrUrl == null && testTreebank == null) {
                System.err.println("usage: java edu.stanford.nlp.parser.lexparser.LexicalizedParser -train trainFilesPath [fileRange] -saveToSerializedFile serializedParserFilename");
            }
        }
        if (Test.verbose || train) {
            String lexNumRules = lp.pparser != null ? Integer.toString(lp.pparser.lex.numRules()) : "";
            System.err.println("Grammar\tStates\tTags\tWords\tUnaryR\tBinaryR\tTaggings");
            System.err.println("Grammar\t" + Numberer.getGlobalNumberer("states").total() + '\t' + Numberer.getGlobalNumberer("tags").total() + '\t' + Numberer.getGlobalNumberer("words").total() + '\t' + (lp.pparser != null ? Integer.valueOf(lp.pparser.ug.numRules()) : "") + '\t' + (lp.pparser != null ? Integer.valueOf(lp.pparser.bg.numRules()) : "") + '\t' + lexNumRules);
            System.err.println("ParserPack is " + op.tlpParams.getClass().getName());
            System.err.println("Lexicon is " + lp.pd.lex.getClass().getName());
            if (Test.verbose) {
                System.err.println("Tags are: " + Numberer.getGlobalNumberer("tags"));
            }
            LexicalizedParser.printOptions(false, op);
        }
        if (testTreebank != null) {
            lp.testOnTreebank(testTreebank);
        } else if (argIndex >= args.length) {
            PrintWriter pwOut = op.tlpParams.pw();
            PrintWriter pwErr = op.tlpParams.pw(System.err);
            if (lp.parse(op.tlpParams.defaultTestSentence())) {
                Test.treePrint(op.tlpParams).printTree(lp.getBestParse(), pwOut);
            } else {
                pwErr.println("Error. Can't parse test sentence: " + op.tlpParams.defaultTestSentence());
            }
        } else {
            lp.parseFiles(args, argIndex, tokenized, tokenizerFactory, documentPreprocessor, elementDelimiter, sentenceDelimiter, escaper, tagDelimiter);
        }
    }
}

