/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;

public class IntTaggedWord
implements Serializable,
Comparable<IntTaggedWord> {
    public static final int ANY_WORD_INT = -1;
    public static final int ANY_TAG_INT = -1;
    public static final int STOP_WORD_INT = -2;
    public static final int STOP_TAG_INT = -2;
    public static final String ANY = ".*.";
    public static final String STOP = "STOP";
    private static Numberer wordNumberer;
    private static Numberer tagNumberer;
    public int word;
    public short tag;
    private static final char[] charsToEscape;
    private static final long serialVersionUID = 1L;

    static Numberer wordNumberer() {
        if (wordNumberer == null) {
            wordNumberer = Numberer.getGlobalNumberer("words");
        }
        return wordNumberer;
    }

    static Numberer tagNumberer() {
        if (tagNumberer == null) {
            tagNumberer = Numberer.getGlobalNumberer("tags");
        }
        return tagNumberer;
    }

    public static void setWordNumberer(Numberer wordNumberer) {
        IntTaggedWord.wordNumberer = wordNumberer;
    }

    public static void setTagNumberer(Numberer tagNumberer) {
        IntTaggedWord.tagNumberer = tagNumberer;
    }

    static void resetNumberers() {
        wordNumberer = null;
        tagNumberer = null;
    }

    public int tag() {
        return this.tag;
    }

    public int word() {
        return this.word;
    }

    public String wordString() {
        String wordStr = this.word >= 0 ? (String)IntTaggedWord.wordNumberer().object(this.word) : (this.word == -1 ? ANY : STOP);
        return wordStr;
    }

    public String tagString() {
        String tagStr = this.tag >= 0 ? IntTaggedWord.tagNumberer().object(this.tag).toString() : (this.tag == -1 ? ANY : STOP);
        return tagStr;
    }

    public Label tagLabel() {
        return (Label)IntTaggedWord.tagNumberer().object(this.tag);
    }

    public int hashCode() {
        return this.word ^ this.tag << 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IntTaggedWord) {
            IntTaggedWord i = (IntTaggedWord)o;
            return this.word == i.word && this.tag == i.tag;
        }
        return false;
    }

    @Override
    public int compareTo(IntTaggedWord that) {
        if (this.tag != that.tag) {
            return this.tag - that.tag;
        }
        return this.word - that.word;
    }

    public String toLexicalEntry() {
        String wordStr = this.wordString();
        String tagStr = this.tagString();
        return '\"' + StringUtils.escapeString(tagStr, charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(wordStr, charsToEscape, '\\') + '\"';
    }

    public String toString() {
        return this.wordString() + '/' + this.tagString();
    }

    public String toString(String arg) {
        if (arg.equals("verbose")) {
            return this.wordString() + '[' + this.word + "]/" + this.tagString() + '[' + this.tag + ']';
        }
        return this.toString();
    }

    public IntTaggedWord(int word, int tag) {
        this.word = word;
        this.tag = (short)tag;
    }

    public TaggedWord toTaggedWord() {
        String wordStr = this.wordString();
        String tagStr = this.tagString();
        return new TaggedWord(wordStr, tagStr);
    }

    public IntTaggedWord(String s, char splitChar) {
        this(IntTaggedWord.extractWord(s, splitChar), IntTaggedWord.extractTag(s, splitChar));
    }

    private static String extractWord(String s, char splitChar) {
        int n = s.lastIndexOf(splitChar);
        String result = s.substring(0, n);
        return result;
    }

    private static String extractTag(String s, char splitChar) {
        int n = s.lastIndexOf(splitChar);
        String result = s.substring(n + 1);
        return result;
    }

    public IntTaggedWord(String wordString, String tagString) {
        this.word = wordString.equals(ANY) ? -1 : (wordString.equals(STOP) ? -2 : IntTaggedWord.wordNumberer().number(wordString));
        this.tag = tagString.equals(ANY) ? (short)-1 : (tagString.equals(STOP) ? (short)-2 : (short)IntTaggedWord.tagNumberer().number(tagString));
    }

    static {
        charsToEscape = new char[]{'\"'};
    }
}

