/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.BaseUnknownWordModel;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;

public class GermanUnknownWordModel
extends BaseUnknownWordModel {
    private static final long serialVersionUID = 221L;
    private static final String numberMatch = "[0-9]+(?:\\.[0-9]*)";

    public GermanUnknownWordModel(Options.LexOptions op, Lexicon lex) {
        super(op, lex);
    }

    @Override
    public float score(IntTaggedWord itw) {
        String word = itw.wordString();
        String tag = itw.tagString();
        if (word.matches(numberMatch)) {
            if (tag.equals("CARD")) {
                return 0.0f;
            }
            return Float.NEGATIVE_INFINITY;
        }
        return super.score(itw);
    }
}

