/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasOffset;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.LatticeReader;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.OutsideRuleFilter;
import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.parser.lexparser.Scorer;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreeAnnotatorAndBinarizer;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.BinaryHeapPriorityQueue;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.PriorityQueue;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.Timing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public class ExhaustivePCFGParser
implements Scorer,
KBestViterbiParser {
    protected String goalStr;
    protected String stateSpace;
    protected Numberer stateNumberer;
    protected Numberer wordNumberer = Numberer.getGlobalNumberer("words");
    protected Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
    protected TreeFactory tf;
    protected BinaryGrammar bg;
    protected UnaryGrammar ug;
    protected Lexicon lex;
    protected Options op;
    protected TreebankLanguagePack tlp;
    protected OutsideRuleFilter orf;
    protected float[][][] iScore;
    protected float[][][] oScore;
    protected float bestScore;
    protected int[][][] wordsInSpan;
    protected boolean[][] oFilteredStart;
    protected boolean[][] oFilteredEnd;
    protected boolean[][] iPossibleByL;
    protected boolean[][] iPossibleByR;
    protected boolean[][] oPossibleByL;
    protected boolean[][] oPossibleByR;
    protected int[] words;
    protected IntPair[] offsets;
    protected int length;
    protected boolean[][] tags;
    protected int myMaxLength = 559038737;
    protected int numStates;
    protected int arraySize = 0;
    protected static final boolean spillGuts = false;
    protected static final boolean dumpTagging = false;
    private static long time = System.currentTimeMillis();
    protected boolean floodTags = false;
    protected List sentence = null;
    protected LatticeReader lr = null;
    protected int[][] narrowLExtent = null;
    protected int[][] wideLExtent = null;
    protected int[][] narrowRExtent = null;
    protected int[][] wideRExtent = null;
    protected boolean[] isTag = null;
    private static final double TOL = 1.0E-5;
    private Map<Vertex, PriorityQueue<Derivation>> cand = new HashMap<Vertex, PriorityQueue<Derivation>>();
    private Map<Vertex, LinkedList<Derivation>> dHat = new HashMap<Vertex, LinkedList<Derivation>>();

    public void setGoalString(String goalStr) {
        this.goalStr = goalStr;
    }

    @Override
    public double oScore(Edge edge) {
        double oS = this.oScore[edge.start][edge.end][edge.state];
        return oS;
    }

    @Override
    public double iScore(Edge edge) {
        return this.iScore[edge.start][edge.end][edge.state];
    }

    @Override
    public boolean oPossible(Hook hook) {
        return hook.isPreHook() ? this.oPossibleByR[hook.end][hook.state] : this.oPossibleByL[hook.start][hook.state];
    }

    @Override
    public boolean iPossible(Hook hook) {
        return hook.isPreHook() ? this.iPossibleByR[hook.start][hook.subState] : this.iPossibleByL[hook.end][hook.subState];
    }

    public boolean oPossibleL(int state, int start) {
        return this.oPossibleByL[start][state];
    }

    public boolean oPossibleR(int state, int end) {
        return this.oPossibleByR[end][state];
    }

    public boolean iPossibleL(int state, int start) {
        return this.iPossibleByL[start][state];
    }

    public boolean iPossibleR(int state, int end) {
        return this.iPossibleByR[end][state];
    }

    protected void buildOFilter() {
        this.orf.init();
        for (int start = 0; start < this.length; ++start) {
            this.orf.leftAccepting(this.oFilteredStart[start]);
            this.orf.advanceRight(this.tags[start]);
        }
        for (int end = this.length; end > 0; --end) {
            this.orf.rightAccepting(this.oFilteredEnd[end]);
            this.orf.advanceLeft(this.tags[end - 1]);
        }
    }

    public double validateBinarizedTree(Tree tree, int start) {
        double bound;
        if (tree.isLeaf()) {
            return 0.0;
        }
        float epsilon = 1.0E-4f;
        if (tree.isPreTerminal()) {
            float bound2;
            int tag = Numberer.number("tags", tree.label().value());
            int word = Numberer.number("words", tree.children()[0].label().value());
            IntTaggedWord iTW = new IntTaggedWord(word, tag);
            float score = this.lex.score(iTW, start);
            if (score > (bound2 = this.iScore[start][start + 1][Numberer.number(this.stateSpace, tree.label().value())]) + epsilon) {
                System.out.println("Invalid tagging:");
                System.out.println("  Tag: " + tree.label().value());
                System.out.println("  Word: " + tree.children()[0].label().value());
                System.out.println("  Score: " + score);
                System.out.println("  Bound: " + bound2);
            }
            return score;
        }
        int parent = Numberer.number(this.stateSpace, tree.label().value());
        int firstChild = Numberer.number(this.stateSpace, tree.children()[0].label().value());
        if (tree.numChildren() == 1) {
            double bound3;
            UnaryRule ur = new UnaryRule();
            ur.parent = parent;
            ur.child = firstChild;
            double score = SloppyMath.max(this.ug.scoreRule(ur), -10000.0) + this.validateBinarizedTree(tree.children()[0], start);
            if (score > (bound3 = (double)this.iScore[start][start + tree.yield().size()][parent]) + (double)epsilon) {
                System.out.println("Invalid unary:");
                System.out.println("  Parent: " + tree.label().value());
                System.out.println("  Child: " + tree.children()[0].label().value());
                System.out.println("  Start: " + start);
                System.out.println("  End: " + (start + tree.yield().size()));
                System.out.println("  Score: " + score);
                System.out.println("  Bound: " + bound3);
            }
            return score;
        }
        BinaryRule br = new BinaryRule();
        br.parent = parent;
        br.leftChild = firstChild;
        br.rightChild = Numberer.number(this.stateSpace, tree.children()[1].label().value());
        double score = SloppyMath.max(this.bg.scoreRule(br), -10000.0) + this.validateBinarizedTree(tree.children()[0], start) + this.validateBinarizedTree(tree.children()[1], start + tree.children()[0].yield().size());
        if (score > (bound = (double)this.iScore[start][start + tree.yield().size()][parent]) + (double)epsilon) {
            System.out.println("Invalid binary:");
            System.out.println("  Parent: " + tree.label().value());
            System.out.println("  LChild: " + tree.children()[0].label().value());
            System.out.println("  RChild: " + tree.children()[1].label().value());
            System.out.println("  Start: " + start);
            System.out.println("  End: " + (start + tree.yield().size()));
            System.out.println("  Score: " + score);
            System.out.println("  Bound: " + bound);
        }
        return score;
    }

    public Tree scoreNonBinarizedTree(Tree tree) {
        TreeAnnotatorAndBinarizer binarizer = new TreeAnnotatorAndBinarizer(this.op.tlpParams, this.op.forceCNF, !Train.outsideFactor(), true);
        tree = binarizer.transformTree(tree);
        this.scoreBinarizedTree(tree, 0);
        return this.op.tlpParams.subcategoryStripper().transformTree(new Debinarizer(this.op.forceCNF).transformTree(tree));
    }

    public double scoreBinarizedTree(Tree tree, int start) {
        if (tree.isLeaf()) {
            return 0.0;
        }
        if (tree.isPreTerminal()) {
            int tag = Numberer.number("tags", tree.label().value());
            int word = Numberer.number("words", tree.children()[0].label().value());
            IntTaggedWord iTW = new IntTaggedWord(word, tag);
            float score = this.lex.score(iTW, start);
            tree.setScore(score);
            return score;
        }
        int parent = Numberer.number(this.stateSpace, tree.label().value());
        int firstChild = Numberer.number(this.stateSpace, tree.children()[0].label().value());
        if (tree.numChildren() == 1) {
            UnaryRule ur = new UnaryRule();
            ur.parent = parent;
            ur.child = firstChild;
            double score = this.ug.scoreRule(ur) + this.scoreBinarizedTree(tree.children()[0], start);
            tree.setScore(score);
            return score;
        }
        BinaryRule br = new BinaryRule();
        br.parent = parent;
        br.leftChild = firstChild;
        br.rightChild = Numberer.number(this.stateSpace, tree.children()[1].label().value());
        double score = this.bg.scoreRule(br) + this.scoreBinarizedTree(tree.children()[0], start) + this.scoreBinarizedTree(tree.children()[1], start + tree.children()[0].yield().size());
        tree.setScore(score);
        return score;
    }

    protected static void tick(String str) {
        long time2 = System.currentTimeMillis();
        long diff = time2 - time;
        time = time2;
        System.err.print("done.  " + diff + "\n" + str);
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence, String goal) {
        return this.parse(sentence);
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence) {
        this.lr = null;
        if (sentence != this.sentence) {
            this.sentence = sentence;
            this.floodTags = false;
        }
        if (Test.verbose) {
            Timing.tick("Starting pcfg parse.");
        }
        this.length = sentence.size();
        if (this.length > this.arraySize) {
            this.considerCreatingArrays(this.length);
        }
        int goal = this.stateNumberer.number(this.goalStr);
        if (Test.verbose) {
            System.err.print("Initializing PCFG...");
        }
        this.words = new int[this.length];
        this.offsets = new IntPair[this.length];
        int unk = 0;
        StringBuilder unkWords = new StringBuilder("[");
        for (int i = 0; i < this.length; ++i) {
            Object o = sentence.get(i);
            if (o instanceof HasOffset) {
                this.offsets[i] = new IntPair(((HasOffset)o).beginPosition(), ((HasOffset)o).endPosition());
            }
            if (o instanceof HasWord) {
                o = o.word();
            }
            String s = o.toString();
            if (Test.verbose && !this.lex.isKnown(this.wordNumberer.number(s))) {
                ++unk;
                unkWords.append(" ");
                unkWords.append(s);
                unkWords.append(" { ");
                for (int jj = 0; jj < s.length(); ++jj) {
                    char ch = s.charAt(jj);
                    unkWords.append(Character.getType(ch)).append(" ");
                }
                unkWords.append("}");
            }
            this.words[i] = this.wordNumberer.number(s);
        }
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                Arrays.fill(this.iScore[start][end], Float.NEGATIVE_INFINITY);
                if (this.op.doDep && !Test.useFastFactored) {
                    Arrays.fill(this.oScore[start][end], Float.NEGATIVE_INFINITY);
                }
                if (!Test.lengthNormalization) continue;
                Arrays.fill(this.wordsInSpan[start][end], 1);
            }
        }
        for (int loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
        }
        if (Test.verbose) {
            Timing.tick("done.");
            unkWords.append(" ]");
            this.op.tlpParams.pw(System.err).println("Unknown words: " + unk + " " + unkWords);
            System.err.print("Starting filters...");
        }
        this.initializeChart(sentence);
        if (Test.verbose) {
            Timing.tick("done.");
            System.err.print("Starting insides...");
        }
        this.doInsideScores();
        if (Test.verbose) {
            Timing.tick("done.");
            System.out.println("PCFG parsing " + this.length + " words (incl. stop): insideScore = " + this.iScore[0][this.length][goal]);
        }
        this.bestScore = this.iScore[0][this.length][goal];
        boolean succeeded = this.hasParse();
        if (Test.doRecovery && !succeeded && !this.floodTags) {
            this.floodTags = true;
            System.err.println("Trying recovery parse...");
            return this.parse(sentence);
        }
        if (!this.op.doDep || Test.useFastFactored) {
            return succeeded;
        }
        if (Test.verbose) {
            System.err.print("Starting outsides...");
        }
        this.oScore[0][this.length][goal] = 0.0f;
        this.doOutsideScores();
        if (Test.verbose) {
            Timing.tick("done.");
            System.err.print("Starting half-filters...");
        }
        for (int loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.iPossibleByL[loc], false);
            Arrays.fill(this.iPossibleByR[loc], false);
            Arrays.fill(this.oPossibleByL[loc], false);
            Arrays.fill(this.oPossibleByR[loc], false);
        }
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                for (int state = 0; state < this.numStates; ++state) {
                    if (!(this.iScore[start][end][state] > Float.NEGATIVE_INFINITY) || !(this.oScore[start][end][state] > Float.NEGATIVE_INFINITY)) continue;
                    this.iPossibleByL[start][state] = true;
                    this.iPossibleByR[end][state] = true;
                    this.oPossibleByL[start][state] = true;
                    this.oPossibleByR[end][state] = true;
                }
            }
        }
        if (Test.verbose) {
            Timing.tick("done.");
        }
        return succeeded;
    }

    public boolean parse(LatticeReader lr) {
        this.sentence = null;
        if (lr != this.lr) {
            this.lr = lr;
            this.floodTags = false;
        }
        if (Test.verbose) {
            Timing.tick("Starting pcfg parse.");
        }
        this.length = lr.getNumStates();
        if (this.length > this.arraySize) {
            this.considerCreatingArrays(this.length);
        }
        int goal = this.stateNumberer.number(this.goalStr);
        if (Test.verbose) {
            System.out.print("Initializing PCFG...");
        }
        List<LatticeReader.LatticeWord> lWords = lr.getLatticeWords();
        this.words = new int[lWords.size()];
        this.offsets = new IntPair[lWords.size()];
        int unk = 0;
        StringBuilder unkWords = new StringBuilder("[");
        int size = lWords.size();
        for (int i = 0; i < size; ++i) {
            String s = lWords.get((int)i).word;
            if (Test.verbose && !this.lex.isKnown(this.wordNumberer.number(s))) {
                ++unk;
                unkWords.append(" ");
                unkWords.append(s);
            }
            this.words[i] = this.wordNumberer.number(s);
        }
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                Arrays.fill(this.iScore[start][end], Float.NEGATIVE_INFINITY);
                if (!this.op.doDep || Test.useFastFactored) continue;
                Arrays.fill(this.oScore[start][end], Float.NEGATIVE_INFINITY);
            }
        }
        for (int loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
        }
        if (Test.verbose) {
            Timing.tick("done.");
            unkWords.append(" ]");
            this.op.tlpParams.pw().println("Unknown words: " + unk + " " + unkWords);
            System.out.print("Starting filters...");
        }
        this.initializeChart(lr);
        if (Test.verbose) {
            Timing.tick("done.");
            System.out.print("Starting insides...");
        }
        this.doInsideScores();
        if (Test.verbose) {
            Timing.tick("done.");
            System.out.println("PCFG " + this.length + " words (incl. stop) iScore " + this.iScore[0][this.length][goal]);
        }
        this.bestScore = this.iScore[0][this.length][goal];
        boolean succeeded = this.hasParse();
        if (Test.doRecovery && this.bestScore == Float.NEGATIVE_INFINITY && !this.floodTags) {
            this.floodTags = true;
            System.err.println("Trying recovery parse...");
            return this.parse(lr);
        }
        if (!this.op.doDep || Test.useFastFactored) {
            return succeeded;
        }
        if (Test.verbose) {
            System.err.print("Starting outsides...");
        }
        this.oScore[0][this.length][goal] = 0.0f;
        this.doOutsideScores();
        if (Test.verbose) {
            Timing.tick("Done.");
            System.out.print("Starting half-filters...");
        }
        for (int loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.iPossibleByL[loc], false);
            Arrays.fill(this.iPossibleByR[loc], false);
            Arrays.fill(this.oPossibleByL[loc], false);
            Arrays.fill(this.oPossibleByR[loc], false);
        }
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                for (int state = 0; state < this.numStates; ++state) {
                    if (!(this.iScore[start][end][state] > Float.NEGATIVE_INFINITY) || !(this.oScore[start][end][state] > Float.NEGATIVE_INFINITY)) continue;
                    this.iPossibleByL[start][state] = true;
                    this.iPossibleByR[end][state] = true;
                    this.oPossibleByL[start][state] = true;
                    this.oPossibleByR[end][state] = true;
                }
            }
        }
        if (Test.verbose) {
            Timing.tick("done.");
        }
        return succeeded;
    }

    private void doOutsideScores() {
        for (int diff = this.length; diff >= 1; --diff) {
            int start = 0;
            while (start + diff <= this.length) {
                float totR;
                float totL;
                float rS;
                float lS;
                int split;
                int max2;
                int min;
                int max;
                float oS;
                Rule[] rules;
                int s;
                int end = start + diff;
                for (s = 0; s < this.numStates; ++s) {
                    float oS2 = this.oScore[start][end][s];
                    if (oS2 == Float.NEGATIVE_INFINITY) continue;
                    rules = this.ug.closedRulesByParent(s);
                    for (Rule ur : rules) {
                        float pS = ((UnaryRule)ur).score;
                        float tot = oS2 + pS;
                        if (!(tot > this.oScore[start][end][((UnaryRule)ur).child]) || !(this.iScore[start][end][((UnaryRule)ur).child] > Float.NEGATIVE_INFINITY)) continue;
                        this.oScore[start][end][((UnaryRule)ur).child] = tot;
                    }
                }
                for (s = 0; s < this.numStates; ++s) {
                    int min1 = this.narrowRExtent[start][s];
                    if (end < min1) continue;
                    rules = this.bg.splitRulesWithLC(s);
                    for (Rule br : rules) {
                        int max1;
                        oS = this.oScore[start][end][((BinaryRule)br).parent];
                        if (oS == Float.NEGATIVE_INFINITY || (max1 = this.narrowLExtent[end][((BinaryRule)br).rightChild]) < min1) continue;
                        max = max1;
                        min = min1;
                        if (max - min > 2) {
                            int min2 = this.wideLExtent[end][((BinaryRule)br).rightChild];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (max1 < min) continue;
                            max2 = this.wideRExtent[start][((BinaryRule)br).leftChild];
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (max < min) continue;
                        }
                        float pS = ((BinaryRule)br).score;
                        for (split = min; split <= max; ++split) {
                            lS = this.iScore[start][split][((BinaryRule)br).leftChild];
                            if (lS == Float.NEGATIVE_INFINITY || (rS = this.iScore[split][end][((BinaryRule)br).rightChild]) == Float.NEGATIVE_INFINITY) continue;
                            totL = pS + rS + oS;
                            if (totL > this.oScore[start][split][((BinaryRule)br).leftChild]) {
                                this.oScore[start][split][((BinaryRule)br).leftChild] = totL;
                            }
                            if (!((totR = pS + lS + oS) > this.oScore[split][end][((BinaryRule)br).rightChild])) continue;
                            this.oScore[split][end][((BinaryRule)br).rightChild] = totR;
                        }
                    }
                }
                for (s = 0; s < this.numStates; ++s) {
                    int max1 = this.narrowLExtent[end][s];
                    if (max1 < start) continue;
                    rules = this.bg.splitRulesWithRC(s);
                    for (Rule br : rules) {
                        int min1;
                        oS = this.oScore[start][end][((BinaryRule)br).parent];
                        if (oS == Float.NEGATIVE_INFINITY || max1 < (min1 = this.narrowRExtent[start][((BinaryRule)br).leftChild])) continue;
                        max = max1;
                        min = min1;
                        if (max - min > 2) {
                            int min2 = this.wideLExtent[end][((BinaryRule)br).rightChild];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (max1 < min) continue;
                            max2 = this.wideRExtent[start][((BinaryRule)br).leftChild];
                            int n3 = max = max1 < max2 ? max1 : max2;
                            if (max < min) continue;
                        }
                        float pS = ((BinaryRule)br).score;
                        for (split = min; split <= max; ++split) {
                            lS = this.iScore[start][split][((BinaryRule)br).leftChild];
                            if (lS == Float.NEGATIVE_INFINITY || (rS = this.iScore[split][end][((BinaryRule)br).rightChild]) == Float.NEGATIVE_INFINITY) continue;
                            totL = pS + rS + oS;
                            if (totL > this.oScore[start][split][((BinaryRule)br).leftChild]) {
                                this.oScore[start][split][((BinaryRule)br).leftChild] = totL;
                            }
                            if (!((totR = pS + lS + oS) > this.oScore[split][end][((BinaryRule)br).rightChild])) continue;
                            this.oScore[split][end][((BinaryRule)br).rightChild] = totR;
                        }
                    }
                }
                ++start;
            }
        }
    }

    void doInsideScores() {
        for (int diff = 2; diff <= this.length; ++diff) {
            for (int start = 0; start < (diff == this.length ? 1 : this.length - diff); ++start) {
                int newWordsInSpan;
                float tot;
                float normTot;
                int bestWordsInSpan;
                boolean foundBetter;
                int split;
                float bestIScore;
                float oldIScore;
                int parentState;
                float pS;
                int max;
                int max2;
                int max1;
                int min;
                int min2;
                int min1;
                int end = start + diff;
                if (Test.constraints != null) {
                    boolean skip = false;
                    for (Test.Constraint c : Test.constraints) {
                        if ((start <= c.start || start >= c.end || end <= c.end) && (end <= c.start || end >= c.end || start >= c.start)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                for (int leftState = 0; leftState < this.numStates; ++leftState) {
                    BinaryRule[] leftRules;
                    boolean iPossibleL;
                    int narrowR = this.narrowRExtent[start][leftState];
                    boolean bl = iPossibleL = narrowR < end;
                    if (!iPossibleL) continue;
                    for (BinaryRule r : leftRules = this.bg.splitRulesWithLC(leftState)) {
                        boolean iPossibleR;
                        int narrowL = this.narrowLExtent[end][r.rightChild];
                        boolean bl2 = iPossibleR = narrowL >= narrowR;
                        if (!iPossibleR) continue;
                        min1 = narrowR;
                        min2 = this.wideLExtent[end][r.rightChild];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        max1 = this.wideRExtent[start][leftState];
                        max2 = narrowL;
                        int n2 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        pS = r.score;
                        parentState = r.parent;
                        bestIScore = oldIScore = this.iScore[start][end][parentState];
                        if (!Test.lengthNormalization) {
                            for (split = min; split <= max; ++split) {
                                float tot2;
                                float rS;
                                float lS;
                                if (Test.constraints != null) {
                                    boolean skip = false;
                                    for (Test.Constraint c : Test.constraints) {
                                        String tag;
                                        Matcher m;
                                        if ((start < c.start && end >= c.end || start <= c.start && end > c.end) && split > c.start && split < c.end) {
                                            skip = true;
                                            break;
                                        }
                                        if (start == c.start && split == c.end && !(m = c.state.matcher(tag = (String)this.stateNumberer.object(leftState))).matches()) {
                                            skip = true;
                                            break;
                                        }
                                        if (split != c.start || end != c.end || (m = c.state.matcher(tag = (String)this.stateNumberer.object(r.rightChild))).matches()) continue;
                                        skip = true;
                                        break;
                                    }
                                    if (skip) continue;
                                }
                                if ((lS = this.iScore[start][split][leftState]) == Float.NEGATIVE_INFINITY || (rS = this.iScore[split][end][r.rightChild]) == Float.NEGATIVE_INFINITY || !((tot2 = pS + lS + rS) > bestIScore)) continue;
                                bestIScore = tot2;
                            }
                            foundBetter = bestIScore > oldIScore;
                        } else {
                            float oldNormIScore;
                            bestWordsInSpan = this.wordsInSpan[start][end][parentState];
                            float bestNormIScore = oldNormIScore = oldIScore / (float)bestWordsInSpan;
                            for (int split2 = min; split2 <= max; ++split2) {
                                float rS;
                                float lS = this.iScore[start][split2][leftState];
                                if (lS == Float.NEGATIVE_INFINITY || (rS = this.iScore[split2][end][r.rightChild]) == Float.NEGATIVE_INFINITY || !((normTot = (tot = pS + lS + rS) / (float)(newWordsInSpan = this.wordsInSpan[start][split2][leftState] + this.wordsInSpan[split2][end][r.rightChild])) > bestNormIScore)) continue;
                                bestIScore = tot;
                                bestNormIScore = normTot;
                                bestWordsInSpan = newWordsInSpan;
                            }
                            boolean bl3 = foundBetter = bestNormIScore > oldNormIScore;
                            if (foundBetter) {
                                this.wordsInSpan[start][end][parentState] = bestWordsInSpan;
                            }
                        }
                        if (!foundBetter) continue;
                        this.iScore[start][end][parentState] = bestIScore;
                        if (oldIScore != Float.NEGATIVE_INFINITY) continue;
                        if (start > this.narrowLExtent[end][parentState]) {
                            this.narrowLExtent[end][parentState] = start;
                            this.wideLExtent[end][parentState] = start;
                        } else if (start < this.wideLExtent[end][parentState]) {
                            this.wideLExtent[end][parentState] = start;
                        }
                        if (end < this.narrowRExtent[start][parentState]) {
                            this.narrowRExtent[start][parentState] = end;
                            this.wideRExtent[start][parentState] = end;
                            continue;
                        }
                        if (end <= this.wideRExtent[start][parentState]) continue;
                        this.wideRExtent[start][parentState] = end;
                    }
                }
                for (int rightState = 0; rightState < this.numStates; ++rightState) {
                    boolean iPossibleR;
                    int narrowL = this.narrowLExtent[end][rightState];
                    boolean bl = iPossibleR = narrowL > start;
                    if (!iPossibleR) continue;
                    BinaryRule[] rightRules = this.bg.splitRulesWithRC(rightState);
                    for (BinaryRule r : rightRules) {
                        boolean iPossibleL;
                        int narrowR = this.narrowRExtent[start][r.leftChild];
                        boolean bl4 = iPossibleL = narrowR <= narrowL;
                        if (!iPossibleL) continue;
                        min1 = narrowR;
                        min2 = this.wideLExtent[end][rightState];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        max1 = this.wideRExtent[start][r.leftChild];
                        max2 = narrowL;
                        int n3 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        pS = r.score;
                        parentState = r.parent;
                        bestIScore = oldIScore = this.iScore[start][end][parentState];
                        if (!Test.lengthNormalization) {
                            for (split = min; split <= max; ++split) {
                                float tot3;
                                float rS;
                                float lS;
                                if (Test.constraints != null) {
                                    boolean skip = false;
                                    for (Test.Constraint c : Test.constraints) {
                                        String tag;
                                        Matcher m;
                                        if ((start < c.start && end >= c.end || start <= c.start && end > c.end) && split > c.start && split < c.end) {
                                            skip = true;
                                            break;
                                        }
                                        if (start == c.start && split == c.end && !(m = c.state.matcher(tag = (String)this.stateNumberer.object(r.leftChild))).matches()) {
                                            skip = true;
                                            break;
                                        }
                                        if (split != c.start || end != c.end || (m = c.state.matcher(tag = (String)this.stateNumberer.object(rightState))).matches()) continue;
                                        skip = true;
                                        break;
                                    }
                                    if (skip) continue;
                                }
                                if ((lS = this.iScore[start][split][r.leftChild]) == Float.NEGATIVE_INFINITY || (rS = this.iScore[split][end][rightState]) == Float.NEGATIVE_INFINITY || !((tot3 = pS + lS + rS) > bestIScore)) continue;
                                bestIScore = tot3;
                            }
                            foundBetter = bestIScore > oldIScore;
                        } else {
                            float oldNormIScore;
                            bestWordsInSpan = this.wordsInSpan[start][end][parentState];
                            float bestNormIScore = oldNormIScore = oldIScore / (float)bestWordsInSpan;
                            for (int split3 = min; split3 <= max; ++split3) {
                                float rS;
                                float lS = this.iScore[start][split3][r.leftChild];
                                if (lS == Float.NEGATIVE_INFINITY || (rS = this.iScore[split3][end][rightState]) == Float.NEGATIVE_INFINITY || !((normTot = (tot = pS + lS + rS) / (float)(newWordsInSpan = this.wordsInSpan[start][split3][r.leftChild] + this.wordsInSpan[split3][end][rightState])) > bestNormIScore)) continue;
                                bestIScore = tot;
                                bestNormIScore = normTot;
                                bestWordsInSpan = newWordsInSpan;
                            }
                            boolean bl5 = foundBetter = bestNormIScore > oldNormIScore;
                            if (foundBetter) {
                                this.wordsInSpan[start][end][parentState] = bestWordsInSpan;
                            }
                        }
                        if (!foundBetter) continue;
                        this.iScore[start][end][parentState] = bestIScore;
                        if (oldIScore != Float.NEGATIVE_INFINITY) continue;
                        if (start > this.narrowLExtent[end][parentState]) {
                            this.narrowLExtent[end][parentState] = start;
                            this.wideLExtent[end][parentState] = start;
                        } else if (start < this.wideLExtent[end][parentState]) {
                            this.wideLExtent[end][parentState] = start;
                        }
                        if (end < this.narrowRExtent[start][parentState]) {
                            this.narrowRExtent[start][parentState] = end;
                            this.wideRExtent[start][parentState] = end;
                            continue;
                        }
                        if (end <= this.wideRExtent[start][parentState]) continue;
                        this.wideRExtent[start][parentState] = end;
                    }
                }
                for (int state = 0; state < this.numStates; ++state) {
                    UnaryRule[] unaries;
                    float iS = this.iScore[start][end][state];
                    if (iS == Float.NEGATIVE_INFINITY) continue;
                    for (UnaryRule ur : unaries = this.ug.closedRulesByChild(state)) {
                        boolean foundBetter2;
                        if (Test.constraints != null) {
                            boolean skip = false;
                            for (Test.Constraint c : Test.constraints) {
                                String tag;
                                Matcher m;
                                if (start != c.start || end != c.end || (m = c.state.matcher(tag = (String)this.stateNumberer.object(ur.parent))).matches()) continue;
                                skip = true;
                                break;
                            }
                            if (skip) continue;
                        }
                        int parentState2 = ur.parent;
                        float pS2 = ur.score;
                        float tot4 = iS + pS2;
                        float cur = this.iScore[start][end][parentState2];
                        if (Test.lengthNormalization) {
                            int totWordsInSpan = this.wordsInSpan[start][end][state];
                            float normTot2 = tot4 / (float)totWordsInSpan;
                            int curWordsInSpan = this.wordsInSpan[start][end][parentState2];
                            float normCur = cur / (float)curWordsInSpan;
                            boolean bl = foundBetter2 = normTot2 > normCur;
                            if (foundBetter2) {
                                this.wordsInSpan[start][end][parentState2] = this.wordsInSpan[start][end][state];
                            }
                        } else {
                            boolean bl = foundBetter2 = tot4 > cur;
                        }
                        if (!foundBetter2) continue;
                        this.iScore[start][end][parentState2] = tot4;
                        if (cur != Float.NEGATIVE_INFINITY) continue;
                        if (start > this.narrowLExtent[end][parentState2]) {
                            this.narrowLExtent[end][parentState2] = start;
                            this.wideLExtent[end][parentState2] = start;
                        } else if (start < this.wideLExtent[end][parentState2]) {
                            this.wideLExtent[end][parentState2] = start;
                        }
                        if (end < this.narrowRExtent[start][parentState2]) {
                            this.narrowRExtent[start][parentState2] = end;
                            this.wideRExtent[start][parentState2] = end;
                            continue;
                        }
                        if (end <= this.wideRExtent[start][parentState2]) continue;
                        this.wideRExtent[start][parentState2] = end;
                    }
                }
            }
        }
    }

    private void initializeChart(LatticeReader lr) {
        List<LatticeReader.LatticeWord> latticeWords = lr.getLatticeWords();
        for (LatticeReader.LatticeWord lWord : latticeWords) {
            int state;
            int start = lWord.startNode;
            int end = lWord.endNode;
            String word = lWord.word;
            for (state = 0; state < this.numStates; ++state) {
                IntTaggedWord itw;
                float newScore;
                if (!this.isTag[state] || !((newScore = this.lex.score(itw = new IntTaggedWord(this.wordNumberer.number(word), Numberer.translate(this.stateSpace, "tags", state)), start) + (float)lWord.am) > this.iScore[start][end][state])) continue;
                this.iScore[start][end][state] = newScore;
                this.narrowRExtent[start][state] = start + 1;
                this.narrowLExtent[end][state] = end - 1;
                this.wideRExtent[start][state] = start + 1;
                this.wideLExtent[end][state] = end - 1;
            }
            if (this.floodTags && !Test.noRecoveryTagging) {
                for (state = 0; state < this.numStates; ++state) {
                    float iS = this.iScore[start][end][state];
                    if (iS != Float.NEGATIVE_INFINITY || !this.isTag[state]) continue;
                    this.iScore[start][end][state] = -1000.0f;
                    this.narrowRExtent[start][state] = end;
                    this.narrowLExtent[end][state] = start;
                    this.wideRExtent[start][state] = end;
                    this.wideLExtent[end][state] = start;
                }
            }
            for (state = 0; state < this.numStates; ++state) {
                UnaryRule[] unaries;
                float iS = this.iScore[start][end][state];
                if (iS == Float.NEGATIVE_INFINITY) continue;
                for (UnaryRule ur : unaries = this.ug.closedRulesByChild(state)) {
                    float pS = ur.score;
                    float tot = iS + pS;
                    int parentState = ur.parent;
                    if (!(tot > this.iScore[start][end][parentState])) continue;
                    this.iScore[start][end][parentState] = tot;
                    this.narrowRExtent[start][parentState] = end;
                    this.narrowLExtent[end][parentState] = start;
                    this.wideRExtent[start][parentState] = end;
                    this.wideLExtent[end][parentState] = start;
                }
            }
        }
    }

    private void initializeChart(List sentence) {
        int boundary = this.wordNumberer.number(".$.");
        int start = 0;
        while (start + 1 <= this.length) {
            if (Test.maxSpanForTags > 1) {
                for (int end = start + 1; end < this.length - 1 && end - start <= Test.maxSpanForTags || start + 1 == end; ++end) {
                    StringBuilder word = new StringBuilder();
                    for (int i = start; i < end; ++i) {
                        if (sentence.get(i) instanceof StringLabel) {
                            word.append(((StringLabel)sentence.get(i)).value());
                            continue;
                        }
                        word.append((String)sentence.get(i));
                    }
                    for (int state = 0; state < this.numStates; ++state) {
                        float iS = this.iScore[start][end][state];
                        if (iS != Float.NEGATIVE_INFINITY || !this.isTag[state]) continue;
                        IntTaggedWord itw = new IntTaggedWord(this.wordNumberer.number(word.toString()), Numberer.translate(this.stateSpace, "tags", state));
                        this.iScore[start][end][state] = this.lex.score(itw, start);
                        if (!(this.iScore[start][end][state] > Float.NEGATIVE_INFINITY)) continue;
                        this.narrowRExtent[start][state] = start + 1;
                        this.narrowLExtent[end][state] = end - 1;
                        this.wideRExtent[start][state] = start + 1;
                        this.wideLExtent[end][state] = end - 1;
                    }
                }
            } else {
                int word = this.words[start];
                int end = start + 1;
                Arrays.fill(this.tags[start], false);
                String trueTagStr = null;
                if (sentence.get(start) instanceof HasTag && "".equals(trueTagStr = ((HasTag)sentence.get(start)).tag())) {
                    trueTagStr = null;
                }
                boolean assignedSomeTag = false;
                if (!this.floodTags || word == boundary) {
                    Iterator<IntTaggedWord> taggingI = this.lex.ruleIteratorByWord(word, start);
                    while (taggingI.hasNext()) {
                        IntTaggedWord tagging = taggingI.next();
                        int state = Numberer.translate("tags", this.stateSpace, tagging.tag);
                        if (trueTagStr != null && (!Test.forceTagBeginnings && !this.tlp.basicCategory(tagging.tagString()).equals(trueTagStr) || Test.forceTagBeginnings && !tagging.tagString().startsWith(trueTagStr))) continue;
                        float lexScore = this.lex.score(tagging, start);
                        if (lexScore > Float.NEGATIVE_INFINITY) {
                            assignedSomeTag = true;
                            this.iScore[start][end][state] = lexScore;
                            this.narrowRExtent[start][state] = end;
                            this.narrowLExtent[end][state] = start;
                            this.wideRExtent[start][state] = end;
                            this.wideLExtent[end][state] = start;
                        }
                        short tag = tagging.tag;
                        this.tags[start][tag] = true;
                    }
                }
                if (!assignedSomeTag) {
                    for (int state = 0; state < this.numStates; ++state) {
                        float lexScore;
                        String tagString;
                        if (!this.isTag[state] || this.iScore[start][end][state] != Float.NEGATIVE_INFINITY || trueTagStr != null && !this.tlp.basicCategory(tagString = (String)this.stateNumberer.object(state)).equals(trueTagStr) || !((lexScore = this.lex.score(new IntTaggedWord(word, Numberer.translate(this.stateSpace, "tags", state)), start)) > Float.NEGATIVE_INFINITY)) continue;
                        this.iScore[start][end][state] = lexScore;
                        this.narrowRExtent[start][state] = end;
                        this.narrowLExtent[end][state] = start;
                        this.wideRExtent[start][state] = end;
                        this.wideLExtent[end][state] = start;
                    }
                }
                if (this.op.dcTags) {
                    for (int state = 0; state < this.numStates; ++state) {
                        if (!this.isTag[state]) continue;
                        float[] fArray = this.iScore[start][end];
                        int n = state;
                        fArray[n] = (float)((double)fArray[n] * (1.0 + Test.depWeight));
                    }
                }
                if (this.floodTags && !Test.noRecoveryTagging && word != boundary) {
                    for (int state = 0; state < this.numStates; ++state) {
                        if (!this.isTag[state] || this.iScore[start][end][state] != Float.NEGATIVE_INFINITY) continue;
                        this.iScore[start][end][state] = -1000.0f;
                        this.narrowRExtent[start][state] = end;
                        this.narrowLExtent[end][state] = start;
                        this.wideRExtent[start][state] = end;
                        this.wideLExtent[end][state] = start;
                    }
                }
                for (int state = 0; state < this.numStates; ++state) {
                    UnaryRule[] unaries;
                    float iS = this.iScore[start][end][state];
                    if (iS == Float.NEGATIVE_INFINITY) continue;
                    for (UnaryRule ur : unaries = this.ug.closedRulesByChild(state)) {
                        float pS = ur.score;
                        float tot = iS + pS;
                        int parentState = ur.parent;
                        if (!(tot > this.iScore[start][end][parentState])) continue;
                        this.iScore[start][end][parentState] = tot;
                        this.narrowRExtent[start][parentState] = end;
                        this.narrowLExtent[end][parentState] = start;
                        this.wideRExtent[start][parentState] = end;
                        this.wideLExtent[end][parentState] = start;
                    }
                }
            }
            ++start;
        }
    }

    @Override
    public boolean hasParse() {
        return this.getBestScore() > Double.NEGATIVE_INFINITY;
    }

    protected static boolean matches(double x, double y) {
        return Math.abs(x - y) / (Math.abs(x) + Math.abs(y) + 1.0E-10) < 1.0E-5;
    }

    @Override
    public double getBestScore() {
        return this.getBestScore(this.goalStr);
    }

    public double getBestScore(String stateName) {
        if (this.length > this.arraySize) {
            return Double.NEGATIVE_INFINITY;
        }
        if (!this.stateNumberer.hasSeen(stateName)) {
            return Double.NEGATIVE_INFINITY;
        }
        int goal = this.stateNumberer.number(stateName);
        return this.iScore[0][this.length][goal];
    }

    @Override
    public Tree getBestParse() {
        int start = 0;
        int end = this.length;
        int goal = this.stateNumberer.number(this.goalStr);
        Tree internalTree = this.extractBestParse(goal, start, end);
        if (internalTree == null) {
            System.err.println("Warning: no parse found in ExhaustivePCFGParser.extractBestParse");
        }
        return internalTree;
    }

    protected Tree extractBestParse(int goal, int start, int end) {
        double bestScore = this.iScore[start][end][goal];
        double normBestScore = Test.lengthNormalization ? bestScore / (double)this.wordsInSpan[start][end][goal] : bestScore;
        String goalStr = (String)this.stateNumberer.object(goal);
        if (end - start <= Test.maxSpanForTags && this.tagNumberer.hasSeen(goalStr)) {
            if (Test.maxSpanForTags > 1) {
                Tree wordNode = null;
                if (this.sentence != null) {
                    StringBuilder word = new StringBuilder();
                    for (int i = start; i < end; ++i) {
                        if (this.sentence.get(i) instanceof StringLabel) {
                            word.append(((StringLabel)this.sentence.get(i)).value());
                            continue;
                        }
                        word.append((String)this.sentence.get(i));
                    }
                    wordNode = this.tf.newLeaf(new StringLabel(word.toString()));
                } else if (this.lr != null) {
                    List<LatticeReader.LatticeWord> latticeWords = this.lr.getWordsOverSpan(start, end);
                    for (LatticeReader.LatticeWord lWord : latticeWords) {
                        IntTaggedWord itw = new IntTaggedWord(this.wordNumberer.number(lWord.word), Numberer.translate(this.stateSpace, "tags", goal));
                        float tagScore = this.lex.score(itw, start);
                        if (!ExhaustivePCFGParser.matches(bestScore, tagScore + (float)lWord.am)) continue;
                        wordNode = this.tf.newLeaf(new StringLabel(lWord.word));
                        break;
                    }
                    if (wordNode == null) {
                        throw new RuntimeException("could not find matching word from lattice in parse reconstruction");
                    }
                } else {
                    throw new RuntimeException("attempt to get word when sentence and lattice are null!");
                }
                Tree tagNode = this.tf.newTreeNode(new StringLabel(goalStr), Collections.singletonList(wordNode));
                tagNode.setScore(bestScore);
                return tagNode;
            }
            IntTaggedWord tagging = new IntTaggedWord(this.words[start], this.tagNumberer.number(goalStr));
            float tagScore = this.lex.score(tagging, start);
            if (tagScore > Float.NEGATIVE_INFINITY || this.floodTags) {
                String wordStr = (String)this.wordNumberer.object(this.words[start]);
                StringLabel leafLabel = this.offsets[start] != null ? new StringLabel(wordStr, this.offsets[start].getSource(), this.offsets[start].getTarget()) : new StringLabel(wordStr);
                Tree wordNode = this.tf.newLeaf(leafLabel);
                Tree tagNode = this.tf.newTreeNode(new StringLabel(goalStr), Collections.singletonList(wordNode));
                tagNode.setScore(bestScore);
                return tagNode;
            }
        }
        for (int split = start + 1; split < end; ++split) {
            Iterator<BinaryRule> binaryI = this.bg.ruleIteratorByParent(goal);
            while (binaryI.hasNext()) {
                boolean matches;
                BinaryRule br = binaryI.next();
                double score = br.score + this.iScore[start][split][br.leftChild] + this.iScore[split][end][br.rightChild];
                if (Test.lengthNormalization) {
                    double normScore = score / (double)(this.wordsInSpan[start][split][br.leftChild] + this.wordsInSpan[split][end][br.rightChild]);
                    matches = ExhaustivePCFGParser.matches(normScore, normBestScore);
                } else {
                    matches = ExhaustivePCFGParser.matches(score, bestScore);
                }
                if (!matches) continue;
                Tree leftChildTree = this.extractBestParse(br.leftChild, start, split);
                Tree rightChildTree = this.extractBestParse(br.rightChild, split, end);
                ArrayList<Tree> children = new ArrayList<Tree>();
                children.add(leftChildTree);
                children.add(rightChildTree);
                Tree result = this.tf.newTreeNode(new StringLabel(goalStr), children);
                result.setScore(score);
                return result;
            }
        }
        Iterator<UnaryRule> unaryI = this.ug.ruleIteratorByParent(goal);
        while (unaryI.hasNext()) {
            boolean matches;
            UnaryRule ur = unaryI.next();
            double score = ur.score + this.iScore[start][end][ur.child];
            if (Test.lengthNormalization) {
                double normScore = score / (double)this.wordsInSpan[start][end][ur.child];
                matches = ExhaustivePCFGParser.matches(normScore, normBestScore);
            } else {
                matches = ExhaustivePCFGParser.matches(score, bestScore);
            }
            if (ur.child == ur.parent || !matches) continue;
            Tree childTree = this.extractBestParse(ur.child, start, end);
            Tree result = this.tf.newTreeNode(new StringLabel(goalStr), Collections.singletonList(childTree));
            result.setScore(score);
            return result;
        }
        System.err.println("Warning: no parse found in ExhaustivePCFGParser.extractBestParse: failing on: [" + start + ", " + end + "] looking for " + goalStr);
        return null;
    }

    protected List<Tree> extractBestParses(int goal, int start, int end) {
        IntTaggedWord tagging;
        float tagScore;
        double bestScore = this.iScore[start][end][goal];
        String goalStr = (String)this.stateNumberer.object(goal);
        if (end - start == 1 && this.tagNumberer.hasSeen(goalStr) && ((tagScore = this.lex.score(tagging = new IntTaggedWord(this.words[start], this.tagNumberer.number(goalStr)), start)) > Float.NEGATIVE_INFINITY || this.floodTags)) {
            String wordStr = (String)this.wordNumberer.object(this.words[start]);
            Tree wordNode = this.tf.newLeaf(new StringLabel(wordStr));
            Tree tagNode = this.tf.newTreeNode(new StringLabel(goalStr), Collections.singletonList(wordNode));
            return Collections.singletonList(tagNode);
        }
        ArrayList<Tree> bestTrees = new ArrayList<Tree>();
        for (int split = start + 1; split < end; ++split) {
            Iterator<BinaryRule> binaryI = this.bg.ruleIteratorByParent(goal);
            while (binaryI.hasNext()) {
                BinaryRule br = binaryI.next();
                double score = br.score + this.iScore[start][split][br.leftChild] + this.iScore[split][end][br.rightChild];
                if (!ExhaustivePCFGParser.matches(score, bestScore)) continue;
                List<Tree> leftChildTrees = this.extractBestParses(br.leftChild, start, split);
                List<Tree> rightChildTrees = this.extractBestParses(br.rightChild, split, end);
                for (Tree leftChildTree : leftChildTrees) {
                    for (Tree rightChildTree : rightChildTrees) {
                        ArrayList<Tree> children = new ArrayList<Tree>();
                        children.add(leftChildTree);
                        children.add(rightChildTree);
                        Tree result = this.tf.newTreeNode(new StringLabel(goalStr), children);
                        bestTrees.add(result);
                    }
                }
            }
        }
        Iterator<UnaryRule> unaryI = this.ug.ruleIteratorByParent(goal);
        while (unaryI.hasNext()) {
            UnaryRule ur = unaryI.next();
            double score = ur.score + this.iScore[start][end][ur.child];
            if (ur.child == ur.parent || !ExhaustivePCFGParser.matches(score, bestScore)) continue;
            List<Tree> childTrees = this.extractBestParses(ur.child, start, end);
            for (Tree childTree : childTrees) {
                Tree result = this.tf.newTreeNode(new StringLabel(goalStr), Collections.singletonList(childTree));
                bestTrees.add(result);
            }
        }
        if (bestTrees.isEmpty()) {
            System.err.println("Warning: no parse found in ExhaustivePCFGParser.extractBestParse: failing on: [" + start + ", " + end + "] looking for " + goalStr);
        }
        return bestTrees;
    }

    @Override
    public List<ScoredObject<Tree>> getKGoodParses(int k) {
        return this.getKBestParses(k);
    }

    @Override
    public List<ScoredObject<Tree>> getKSampledParses(int k) {
        throw new UnsupportedOperationException("ExhaustivePCFGParser doesn't sample.");
    }

    @Override
    public List<ScoredObject<Tree>> getKBestParses(int k) {
        Tree internalTree;
        this.cand = new HashMap<Vertex, PriorityQueue<Derivation>>();
        this.dHat = new HashMap<Vertex, LinkedList<Derivation>>();
        int start = 0;
        int end = this.length;
        int goal = this.stateNumberer.number(this.goalStr);
        Vertex v = new Vertex(goal, start, end);
        ArrayList<ScoredObject<Tree>> kBestTrees = new ArrayList<ScoredObject<Tree>>();
        for (int i = 1; i <= k && (internalTree = this.getTree(v, i, k)) != null; ++i) {
            kBestTrees.add(new ScoredObject<Tree>(internalTree, this.dHat.get((Object)v).get((int)(i - 1)).score));
        }
        return kBestTrees;
    }

    private Tree getTree(Vertex v, int k, int kPrime) {
        this.lazyKthBest(v, k, kPrime);
        String goalStr = (String)this.stateNumberer.object(v.goal);
        int start = v.start;
        List dHatV = this.dHat.get(v);
        if (this.isTag[v.goal]) {
            IntTaggedWord tagging = new IntTaggedWord(this.words[start], this.tagNumberer.number(goalStr));
            float tagScore = this.lex.score(tagging, start);
            if (tagScore > Float.NEGATIVE_INFINITY || this.floodTags) {
                String wordStr = (String)this.wordNumberer.object(this.words[start]);
                Tree wordNode = this.tf.newLeaf(new StringLabel(wordStr));
                return this.tf.newTreeNode(new StringLabel(goalStr), Collections.singletonList(wordNode));
            }
            assert (false);
        }
        if (k - 1 >= dHatV.size()) {
            return null;
        }
        Derivation d = (Derivation)dHatV.get(k - 1);
        ArrayList<Tree> children = new ArrayList<Tree>();
        for (int i = 0; i < d.arc.size(); ++i) {
            Vertex child = d.arc.tails.get(i);
            Tree t = this.getTree(child, d.j.get(i), kPrime);
            assert (t != null);
            children.add(t);
        }
        return this.tf.newTreeNode(new StringLabel(goalStr), children);
    }

    private List<Arc> getBackwardsStar(Vertex v) {
        ArrayList<Arc> bs = new ArrayList<Arc>();
        if (this.isTag[v.goal]) {
            ArrayList<Vertex> tails = new ArrayList<Vertex>();
            double score = this.iScore[v.start][v.end][v.goal];
            Arc arc = new Arc(tails, v, score);
            bs.add(arc);
        }
        for (int split = v.start + 1; split < v.end; ++split) {
            for (BinaryRule br : this.bg.ruleListByParent(v.goal)) {
                Vertex lChild = new Vertex(br.leftChild, v.start, split);
                Vertex rChild = new Vertex(br.rightChild, split, v.end);
                ArrayList<Vertex> tails = new ArrayList<Vertex>();
                tails.add(lChild);
                tails.add(rChild);
                Arc arc = new Arc(tails, v, br.score);
                bs.add(arc);
            }
        }
        for (UnaryRule ur : this.ug.rulesByParent(v.goal)) {
            Vertex child = new Vertex(ur.child, v.start, v.end);
            ArrayList<Vertex> tails = new ArrayList<Vertex>();
            tails.add(child);
            Arc arc = new Arc(tails, v, ur.score);
            bs.add(arc);
        }
        return bs;
    }

    private PriorityQueue<Derivation> getCandidates(Vertex v, int k) {
        PriorityQueue<Derivation> candV = this.cand.get(v);
        if (candV == null) {
            candV = new BinaryHeapPriorityQueue<Derivation>();
            List<Arc> bsV = this.getBackwardsStar(v);
            for (Arc arc : bsV) {
                int size = arc.size();
                double score = arc.ruleScore;
                ArrayList<Double> childrenScores = new ArrayList<Double>();
                for (int i = 0; i < size; ++i) {
                    Vertex child = arc.tails.get(i);
                    double s = this.iScore[child.start][child.end][child.goal];
                    childrenScores.add(s);
                    score += s;
                }
                if (score == Double.NEGATIVE_INFINITY) continue;
                ArrayList<Integer> j = new ArrayList<Integer>();
                for (int i = 0; i < size; ++i) {
                    j.add(1);
                }
                Derivation d = new Derivation(arc, j, score, childrenScores);
                candV.add(d, score);
            }
            BinaryHeapPriorityQueue<Derivation> tmp = new BinaryHeapPriorityQueue<Derivation>();
            for (int i = 0; i < k && !candV.isEmpty(); ++i) {
                Derivation d = candV.removeFirst();
                tmp.add(d, d.score);
            }
            candV = tmp;
            this.cand.put(v, candV);
        }
        return candV;
    }

    private void lazyKthBest(Vertex v, int k, int kPrime) {
        PriorityQueue<Derivation> candV = this.getCandidates(v, kPrime);
        LinkedList<Derivation> dHatV = this.dHat.get(v);
        if (dHatV == null) {
            dHatV = new LinkedList();
            this.dHat.put(v, dHatV);
        }
        while (dHatV.size() < k) {
            if (!dHatV.isEmpty()) {
                Derivation derivation = dHatV.getLast();
                this.lazyNext(candV, derivation, kPrime);
            }
            if (candV.isEmpty()) break;
            Derivation d = candV.removeFirst();
            dHatV.add(d);
        }
    }

    private void lazyNext(PriorityQueue<Derivation> candV, Derivation derivation, int kPrime) {
        List<Vertex> tails = derivation.arc.tails;
        int sz = derivation.arc.size();
        for (int i = 0; i < sz; ++i) {
            ArrayList<Integer> j = new ArrayList<Integer>(derivation.j);
            j.set(i, (Integer)j.get(i) + 1);
            Vertex Ti = tails.get(i);
            this.lazyKthBest(Ti, (Integer)j.get(i), kPrime);
            LinkedList<Derivation> dHatTi = this.dHat.get(Ti);
            if ((Integer)j.get(i) - 1 >= dHatTi.size()) continue;
            Derivation d = dHatTi.get((Integer)j.get(i) - 1);
            double newScore = derivation.score - derivation.childrenScores.get(i) + d.score;
            ArrayList<Double> childrenScores = new ArrayList<Double>(derivation.childrenScores);
            childrenScores.set(i, d.score);
            Derivation newDerivation = new Derivation(derivation.arc, j, newScore, childrenScores);
            if (candV.contains(newDerivation) || !(newScore > Double.NEGATIVE_INFINITY)) continue;
            candV.add(newDerivation, newScore);
        }
    }

    @Override
    public List<ScoredObject<Tree>> getBestParses() {
        int start = 0;
        int end = this.length;
        int goal = this.stateNumberer.number(this.goalStr);
        double bestScore = this.iScore[start][end][goal];
        List<Tree> internalTrees = this.extractBestParses(goal, start, end);
        ArrayList<ScoredObject<Tree>> scoredTrees = new ArrayList<ScoredObject<Tree>>(internalTrees.size());
        for (Tree tr : internalTrees) {
            scoredTrees.add(new ScoredObject<Tree>(tr, bestScore));
        }
        return scoredTrees;
    }

    public ExhaustivePCFGParser(BinaryGrammar bg, UnaryGrammar ug, Lexicon lex, Options op) {
        this.op = op;
        this.tlp = op.langpack();
        this.goalStr = this.tlp.startSymbol();
        this.stateSpace = bg.stateSpace();
        this.stateNumberer = Numberer.getGlobalNumberer(this.stateSpace);
        this.bg = bg;
        this.ug = ug;
        this.lex = lex;
        this.tf = new LabeledScoredTreeFactory(new StringLabelFactory());
        this.numStates = this.stateNumberer.total();
        this.isTag = new boolean[this.numStates];
        for (int state = 0; state < this.numStates; ++state) {
            this.isTag[state] = this.tagNumberer.hasSeen(this.stateNumberer.object(state));
        }
    }

    public void nudgeDownArraySize() {
        try {
            if (this.arraySize > 2) {
                this.considerCreatingArrays(this.arraySize - 2);
            }
        }
        catch (OutOfMemoryError oome) {
            oome.printStackTrace();
        }
    }

    private void considerCreatingArrays(int length) {
        if (length > Test.maxLength + 1 || length >= this.myMaxLength) {
            throw new OutOfMemoryError("Refusal to create such large arrays.");
        }
        try {
            this.createArrays(length + 1);
        }
        catch (OutOfMemoryError e) {
            this.myMaxLength = length;
            if (this.arraySize > 0) {
                try {
                    this.createArrays(this.arraySize);
                }
                catch (OutOfMemoryError e2) {
                    throw new RuntimeException("CANNOT EVEN CREATE ARRAYS OF ORIGINAL SIZE!!");
                }
            }
            throw e;
        }
        this.arraySize = length + 1;
        if (Test.verbose) {
            System.err.println("Created PCFG parser arrays of size " + this.arraySize);
        }
    }

    protected void createArrays(int length) {
        int end;
        int start;
        this.clearArrays();
        int numTags = this.tagNumberer.total();
        this.iScore = new float[length + 1][length + 1][];
        for (start = 0; start <= length; ++start) {
            for (end = start + 1; end <= length; ++end) {
                this.iScore[start][end] = new float[this.numStates];
            }
        }
        if (this.op.doDep && !Test.useFastFactored) {
            this.oScore = new float[length + 1][length + 1][];
            for (start = 0; start <= length; ++start) {
                for (end = start + 1; end <= length; ++end) {
                    this.oScore[start][end] = new float[this.numStates];
                }
            }
        }
        this.iPossibleByL = new boolean[length + 1][this.numStates];
        this.iPossibleByR = new boolean[length + 1][this.numStates];
        this.narrowRExtent = new int[length + 1][this.numStates];
        this.wideRExtent = new int[length + 1][this.numStates];
        this.narrowLExtent = new int[length + 1][this.numStates];
        this.wideLExtent = new int[length + 1][this.numStates];
        if (this.op.doDep && !Test.useFastFactored) {
            this.oPossibleByL = new boolean[length + 1][this.numStates];
            this.oPossibleByR = new boolean[length + 1][this.numStates];
            this.oFilteredStart = new boolean[length + 1][this.numStates];
            this.oFilteredEnd = new boolean[length + 1][this.numStates];
        }
        this.tags = new boolean[length + 1][numTags];
        if (Test.lengthNormalization) {
            this.wordsInSpan = new int[length + 1][length + 1][];
            for (start = 0; start <= length; ++start) {
                for (end = start + 1; end <= length; ++end) {
                    this.wordsInSpan[start][end] = new int[this.numStates];
                }
            }
        }
    }

    private void clearArrays() {
        this.oScore = null;
        this.iScore = this.oScore;
        this.tags = null;
        this.oPossibleByR = this.tags;
        this.oPossibleByL = this.tags;
        this.oFilteredStart = this.tags;
        this.oFilteredEnd = this.tags;
        this.iPossibleByR = this.tags;
        this.iPossibleByL = this.tags;
        this.wideLExtent = null;
        this.narrowLExtent = this.wideLExtent;
        this.wideRExtent = this.wideLExtent;
        this.narrowRExtent = this.wideLExtent;
    }

    private static class Derivation {
        public final Arc arc;
        public final List<Integer> j;
        public final double score;
        public final List<Double> childrenScores;
        private int hc = -1;

        public Derivation(Arc arc, List<Integer> j, double score, List<Double> childrenScores) {
            this.arc = arc;
            this.j = Collections.unmodifiableList(j);
            this.score = score;
            this.childrenScores = Collections.unmodifiableList(childrenScores);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Derivation)) {
                return false;
            }
            Derivation d = (Derivation)o;
            if (this.arc == null && d.arc != null || this.arc != null && d.arc == null) {
                return false;
            }
            return (this.arc == null && d.arc == null || d.arc.equals(this.arc)) && ((Object)d.j).equals(this.j);
        }

        public int hashCode() {
            if (this.hc == -1) {
                this.hc = (this.arc == null ? 0 : this.arc.hashCode()) + 17 * ((Object)this.j).hashCode();
            }
            return this.hc;
        }
    }

    private static class Arc {
        public final List<Vertex> tails;
        public final Vertex head;
        public final double ruleScore;
        private int hc = -1;

        public Arc(List<Vertex> tails, Vertex head, double ruleScore) {
            this.tails = Collections.unmodifiableList(tails);
            this.head = head;
            this.ruleScore = ruleScore;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Arc)) {
                return false;
            }
            Arc a = (Arc)o;
            return a.head.equals(this.head) && ((Object)a.tails).equals(this.tails);
        }

        public int hashCode() {
            if (this.hc == -1) {
                this.hc = this.head.hashCode() + 17 * ((Object)this.tails).hashCode();
            }
            return this.hc;
        }

        public int size() {
            return this.tails.size();
        }
    }

    private static class Vertex {
        public final int goal;
        public final int start;
        public final int end;
        private int hc = -1;

        public Vertex(int goal, int start, int end) {
            this.goal = goal;
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Vertex)) {
                return false;
            }
            Vertex v = (Vertex)o;
            return v.goal == this.goal && v.start == this.start && v.end == this.end;
        }

        public int hashCode() {
            if (this.hc == -1) {
                this.hc = this.goal + 17 * (this.start + 17 * this.end);
            }
            return this.hc;
        }

        public String toString() {
            return this.goal + "[" + this.start + "," + this.end + "]";
        }
    }
}

