/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.lexparser.AbstractEval;
import edu.stanford.nlp.parser.lexparser.LabeledConstituentEval;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.trees.LabeledConstituent;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConstituentEvalByCat
extends AbstractEval {
    private LabeledConstituentEval lce;
    private static final Set emptySet = new HashSet();
    Map<Label, Set<LabeledConstituent>> guessDeps = new HashMap<Label, Set<LabeledConstituent>>();
    Map<Label, Set<LabeledConstituent>> goldDeps = new HashMap<Label, Set<LabeledConstituent>>();
    ClassicCounter<Label> precisions = new ClassicCounter();
    ClassicCounter<Label> recalls = new ClassicCounter();
    ClassicCounter<Label> f1s = new ClassicCounter();
    ClassicCounter<Label> precisions2 = new ClassicCounter();
    ClassicCounter<Label> recalls2 = new ClassicCounter();
    ClassicCounter<Label> pnums2 = new ClassicCounter();
    ClassicCounter<Label> rnums2 = new ClassicCounter();

    public ConstituentEvalByCat(String str, TreebankLanguagePack tlp, boolean runningAverages) {
        super(str, runningAverages);
        this.lce = new LabeledConstituentEval(str, false, tlp);
    }

    @Override
    Set makeObjects(Tree tree) {
        return this.lce.makeObjects(tree);
    }

    private Map<Label, Set<LabeledConstituent>> makeObjectsByCat(Tree t) {
        HashMap<Label, Set<LabeledConstituent>> objMap = new HashMap<Label, Set<LabeledConstituent>>();
        Set objSet = this.makeObjects(t);
        for (LabeledConstituent lc : objSet) {
            Label l = lc.label();
            if (!objMap.keySet().contains(l)) {
                objMap.put(l, new HashSet());
            }
            ((Set)objMap.get(l)).add(lc);
        }
        return objMap;
    }

    @Override
    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        this.guessDeps = this.makeObjectsByCat(guess);
        this.goldDeps = this.makeObjectsByCat(gold);
        HashSet<Label> cats = new HashSet<Label>();
        cats.addAll(this.guessDeps.keySet());
        cats.addAll(this.goldDeps.keySet());
        if (pw != null && this.runningAverages) {
            pw.println("========================================");
            pw.println("Labeled Bracketed Evaluation by Category");
            pw.println("========================================");
        }
        this.num += 1.0;
        for (Label cat : cats) {
            Set thisGuessDeps = this.guessDeps.get(cat);
            Set thisGoldDeps = this.goldDeps.get(cat);
            if (thisGuessDeps == null) {
                thisGuessDeps = emptySet;
            }
            if (thisGoldDeps == null) {
                thisGoldDeps = emptySet;
            }
            double currentPrecision = ConstituentEvalByCat.precision(thisGuessDeps, thisGoldDeps);
            double currentRecall = ConstituentEvalByCat.precision(thisGoldDeps, thisGuessDeps);
            double currentF1 = currentPrecision > 0.0 && currentRecall > 0.0 ? 2.0 / (1.0 / currentPrecision + 1.0 / currentRecall) : 0.0;
            this.precisions.incrementCount(cat, currentPrecision);
            this.recalls.incrementCount(cat, currentRecall);
            this.f1s.incrementCount(cat, currentF1);
            this.precisions2.incrementCount(cat, (double)thisGuessDeps.size() * currentPrecision);
            this.pnums2.incrementCount(cat, thisGuessDeps.size());
            this.recalls2.incrementCount(cat, (double)thisGoldDeps.size() * currentRecall);
            this.rnums2.incrementCount(cat, thisGoldDeps.size());
            if (pw == null || !this.runningAverages) continue;
            pw.println(cat + "\tP: " + (double)((int)(currentPrecision * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(this.precisions.getCount(cat) * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.precisions2.getCount(cat) * 10000.0 / this.pnums2.getCount(cat))) / 100.0 + ")");
            pw.println("\tR: " + (double)((int)(currentRecall * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(this.recalls.getCount(cat) * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.recalls2.getCount(cat) * 10000.0 / this.rnums2.getCount(cat))) / 100.0 + ")");
            double cF1 = 2.0 / (this.rnums2.getCount(cat) / this.recalls2.getCount(cat) + this.pnums2.getCount(cat) / this.precisions2.getCount(cat));
            String emit = this.str + " F1: " + (double)((int)(currentF1 * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(10000.0 * this.f1s.getCount(cat) / this.num)) / 100.0 + ", evalb " + (double)((int)(10000.0 * cF1)) / 100.0 + ")";
            pw.println(emit);
        }
        if (pw != null && this.runningAverages) {
            pw.println("========================================");
        }
    }

    @Override
    public void display(boolean verbose, PrintWriter pw) {
        DecimalFormat nf = new DecimalFormat("0.00");
        HashSet<Label> cats = new HashSet<Label>();
        cats.addAll(this.precisions.keySet());
        cats.addAll(this.recalls.keySet());
        pw.println("========================================");
        pw.println("Labeled Bracketed Evaluation by Category -- final statistics");
        pw.println("========================================");
        for (Label cat : cats) {
            double pnum2 = this.pnums2.getCount(cat);
            double rnum2 = this.rnums2.getCount(cat);
            double prec = this.precisions2.getCount(cat) / pnum2;
            double rec = this.recalls2.getCount(cat) / rnum2;
            double f = 2.0 / (1.0 / prec + 1.0 / rec);
            pw.println(cat + "\tLP: " + (pnum2 == 0.0 ? " N/A" : nf.format(prec)) + "\tguessed: " + (int)pnum2 + "\tLR: " + (rnum2 == 0.0 ? " N/A" : nf.format(rec)) + "\tgold:  " + (int)rnum2 + "\tF1: " + (pnum2 == 0.0 || rnum2 == 0.0 ? " N/A" : nf.format(f)));
        }
        pw.println("========================================");
    }
}

