/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.RandomWalk;
import edu.stanford.nlp.trees.Tree;
import java.util.Collection;

public class ChineseLexicon
extends BaseLexicon {
    private static final long serialVersionUID = -7836464391021114960L;
    private static final boolean useRandomWalk = false;
    public static boolean useCharBasedUnknownWordModel = false;
    public static boolean useGoodTuringUnknownWordModel = false;
    private static final int STEPS = 1;
    private RandomWalk probRandomWalk;

    public ChineseLexicon(Options.LexOptions op) {
        super(op);
    }

    @Override
    public void train(Collection<Tree> trees) {
        super.train(trees);
    }

    @Override
    public float score(IntTaggedWord iTW, int loc) {
        boolean seen;
        double c_W = this.seenCounter.getCount(iTW);
        boolean bl = seen = c_W > 0.0;
        if (seen) {
            return super.score(iTW, loc);
        }
        float score = this.getUnknownWordModel().score(iTW, loc, 0.0, 0.0, 0.0);
        return score;
    }

    private double scoreRandomWalk(IntTaggedWord itw) {
        TaggedWord tw = itw.toTaggedWord();
        String word = tw.value();
        String tag = tw.tag();
        return this.probRandomWalk.score(tag, word);
    }
}

