/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.Extractor;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammarExtractor;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.stats.EquivalenceClasser;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.DependencyTyper;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledConstituent;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.SimpleConstituent;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTokenizerFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractTreebankParserParams
implements TreebankLangParserParams {
    protected boolean evalGF = true;
    protected String inputEncoding;
    protected String outputEncoding;
    protected TreebankLanguagePack tlp;
    private static final String leftHeaded = "leftHeaded";
    private static final String rightHeaded = "rightHeaded";
    private static final long serialVersionUID = 4299501909017975915L;

    protected AbstractTreebankParserParams(TreebankLanguagePack tlp) {
        this.tlp = tlp;
        this.inputEncoding = tlp.getEncoding();
        this.outputEncoding = tlp.getEncoding();
    }

    @Override
    public void setEvaluateGrammaticalFunctions(boolean evalGFs) {
        this.evalGF = evalGFs;
    }

    @Override
    public void setInputEncoding(String encoding) {
        this.inputEncoding = encoding;
    }

    @Override
    public void setOutputEncoding(String encoding) {
        this.outputEncoding = encoding;
    }

    @Override
    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    @Override
    public String getInputEncoding() {
        return this.inputEncoding;
    }

    @Override
    public abstract MemoryTreebank memoryTreebank();

    @Override
    public MemoryTreebank testMemoryTreebank() {
        return this.memoryTreebank();
    }

    @Override
    public Treebank treebank() {
        return this.diskTreebank();
    }

    @Override
    public PrintWriter pw() {
        return this.pw(System.out);
    }

    @Override
    public PrintWriter pw(OutputStream o) {
        String encoding = this.outputEncoding;
        if (!Charset.isSupported(encoding)) {
            System.out.println("Warning: desired encoding " + encoding + " not accepted. ");
            System.out.println("Using UTF-8 to construct PrintWriter");
            encoding = "UTF-8";
        }
        try {
            return new PrintWriter((Writer)new OutputStreamWriter(o, encoding), true);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Warning: desired encoding " + this.outputEncoding + " not accepted. " + e);
            try {
                return new PrintWriter((Writer)new OutputStreamWriter(o, "UTF-8"), true);
            }
            catch (UnsupportedEncodingException e1) {
                System.out.println("Something is really wrong.  Your system doesn't even support UTF-8!" + e1);
                return new PrintWriter(o, true);
            }
        }
    }

    @Override
    public TreebankLanguagePack treebankLanguagePack() {
        return this.tlp;
    }

    @Override
    public abstract HeadFinder headFinder();

    public Lexicon lex() {
        return new BaseLexicon();
    }

    @Override
    public Lexicon lex(Options.LexOptions op) {
        return new BaseLexicon(op);
    }

    @Override
    public double[] MLEDependencyGrammarSmoothingParams() {
        return new double[]{16.0, 16.0, 4.0, 0.6};
    }

    public static Collection<Constituent> parsevalObjectify(Tree t, TreeTransformer collinizer) {
        return AbstractTreebankParserParams.parsevalObjectify(t, collinizer, true);
    }

    public static Collection<Constituent> parsevalObjectify(Tree t, TreeTransformer collinizer, boolean labelConstituents) {
        ArrayList<Constituent> spans = new ArrayList<Constituent>();
        Tree t1 = collinizer.transformTree(t);
        if (t1 == null) {
            return spans;
        }
        for (Tree node : t1) {
            if (node.isLeaf() || node.isPreTerminal() || node != t1 && node.parent(t1) == null) continue;
            int leftEdge = t1.leftCharEdge(node);
            int rightEdge = t1.rightCharEdge(node);
            if (labelConstituents) {
                spans.add(new LabeledConstituent(leftEdge, rightEdge, node.label()));
                continue;
            }
            spans.add(new SimpleConstituent(leftEdge, rightEdge));
        }
        return spans;
    }

    public static Collection<List<String>> untypedDependencyObjectify(Tree t, HeadFinder hf, TreeTransformer collinizer) {
        return AbstractTreebankParserParams.dependencyObjectify(t, hf, collinizer, new UntypedDependencyTyper(hf));
    }

    public static Collection<List<String>> unorderedUntypedDependencyObjectify(Tree t, HeadFinder hf, TreeTransformer collinizer) {
        return AbstractTreebankParserParams.dependencyObjectify(t, hf, collinizer, new UnorderedUntypedDependencyTyper(hf));
    }

    public static Collection<List<String>> typedDependencyObjectify(Tree t, HeadFinder hf, TreeTransformer collinizer) {
        return AbstractTreebankParserParams.dependencyObjectify(t, hf, collinizer, new TypedDependencyTyper(hf));
    }

    public static Collection<List<String>> unorderedTypedDependencyObjectify(Tree t, HeadFinder hf, TreeTransformer collinizer) {
        return AbstractTreebankParserParams.dependencyObjectify(t, hf, collinizer, new UnorderedTypedDependencyTyper(hf));
    }

    public static <E> Collection<E> dependencyObjectify(Tree t, HeadFinder hf, TreeTransformer collinizer, DependencyTyper<E> typer) {
        ArrayList deps = new ArrayList();
        Tree t1 = collinizer.transformTree(t);
        if (t1 == null) {
            return deps;
        }
        AbstractTreebankParserParams.dependencyObjectifyHelper(t1, t1, hf, deps, typer);
        return deps;
    }

    private static <E> void dependencyObjectifyHelper(Tree t, Tree root, HeadFinder hf, Collection<E> c, DependencyTyper<E> typer) {
        if (t.isLeaf() || t.isPreTerminal()) {
            return;
        }
        Tree headDtr = hf.determineHead(t);
        for (Tree child : t.children()) {
            AbstractTreebankParserParams.dependencyObjectifyHelper(child, root, hf, c, typer);
            if (child == headDtr) continue;
            c.add(typer.makeDependency(headDtr, child, root));
        }
    }

    public static EquivalenceClasser<List<String>, String> typedDependencyClasser() {
        return new EquivalenceClasser<List<String>, String>(){

            @Override
            public String equivalenceClass(List<String> s) {
                if (s.get(5).equals(AbstractTreebankParserParams.leftHeaded)) {
                    return s.get(2) + '(' + s.get(3) + "->" + s.get(4) + ')';
                }
                return s.get(2) + '(' + s.get(4) + "<-" + s.get(3) + ')';
            }
        };
    }

    @Override
    public abstract TreeTransformer collinizer();

    @Override
    public abstract TreeTransformer collinizerEvalb();

    @Override
    public abstract String[] sisterSplitters();

    @Override
    public TreeTransformer subcategoryStripper() {
        if (this.evalGF) {
            return new SubcategoryStripper();
        }
        return new RemoveGFSubcategoryStripper();
    }

    @Override
    public abstract Tree transformTree(Tree var1, Tree var2);

    @Override
    public abstract void display();

    @Override
    public int setOptionFlag(String[] args, int i) {
        return i;
    }

    @Override
    public TokenizerFactory<Tree> treeTokenizerFactory() {
        return new TreeTokenizerFactory(this.treeReaderFactory());
    }

    @Override
    public Extractor<MLEDependencyGrammar> dependencyGrammarExtractor(Options op) {
        return new MLEDependencyGrammarExtractor(op);
    }

    public boolean isEvalGF() {
        return this.evalGF;
    }

    public void setEvalGF(boolean evalGF) {
        this.evalGF = evalGF;
    }

    private static class UnorderedTypedDependencyTyper
    implements DependencyTyper<List<String>> {
        HeadFinder hf;

        public UnorderedTypedDependencyTyper(HeadFinder hf) {
            this.hf = hf;
        }

        @Override
        public List<String> makeDependency(Tree head, Tree dep, Tree root) {
            ArrayList<String> result = new ArrayList<String>(6);
            Tree headTerm = head.headTerminal(this.hf);
            Tree depTerm = dep.headTerminal(this.hf);
            result.add(headTerm.value());
            result.add(depTerm.value());
            result.add(head.parent(root).value());
            result.add(head.value());
            result.add(dep.value());
            return result;
        }
    }

    private static class TypedDependencyTyper
    implements DependencyTyper<List<String>> {
        HeadFinder hf;

        public TypedDependencyTyper(HeadFinder hf) {
            this.hf = hf;
        }

        @Override
        public List<String> makeDependency(Tree head, Tree dep, Tree root) {
            ArrayList<String> result = new ArrayList<String>(6);
            Tree headTerm = head.headTerminal(this.hf);
            Tree depTerm = dep.headTerminal(this.hf);
            boolean headLeft = root.leftCharEdge(headTerm) < root.leftCharEdge(depTerm);
            result.add(headTerm.value());
            result.add(depTerm.value());
            result.add(head.parent(root).value());
            result.add(head.value());
            result.add(dep.value());
            if (headLeft) {
                result.add(AbstractTreebankParserParams.leftHeaded);
            } else {
                result.add(AbstractTreebankParserParams.rightHeaded);
            }
            return result;
        }
    }

    private static class UnorderedUntypedDependencyTyper
    implements DependencyTyper<List<String>> {
        HeadFinder hf;

        public UnorderedUntypedDependencyTyper(HeadFinder hf) {
            this.hf = hf;
        }

        @Override
        public List<String> makeDependency(Tree head, Tree dep, Tree root) {
            ArrayList<String> result = new ArrayList<String>(3);
            Tree headTerm = head.headTerminal(this.hf);
            Tree depTerm = dep.headTerminal(this.hf);
            result.add(headTerm.value());
            result.add(depTerm.value());
            return result;
        }
    }

    private static class UntypedDependencyTyper
    implements DependencyTyper<List<String>> {
        HeadFinder hf;

        public UntypedDependencyTyper(HeadFinder hf) {
            this.hf = hf;
        }

        @Override
        public List<String> makeDependency(Tree head, Tree dep, Tree root) {
            ArrayList<String> result = new ArrayList<String>(3);
            Tree headTerm = head.headTerminal(this.hf);
            Tree depTerm = dep.headTerminal(this.hf);
            boolean headLeft = root.leftCharEdge(headTerm) < root.leftCharEdge(depTerm);
            result.add(headTerm.value());
            result.add(depTerm.value());
            if (headLeft) {
                result.add(AbstractTreebankParserParams.leftHeaded);
            } else {
                result.add(AbstractTreebankParserParams.rightHeaded);
            }
            return result;
        }
    }

    protected class RemoveGFSubcategoryStripper
    implements TreeTransformer {
        protected TreeFactory tf = new LabeledScoredTreeFactory();

        protected RemoveGFSubcategoryStripper() {
        }

        @Override
        public Tree transformTree(Tree tree) {
            Label lab = tree.label();
            if (tree.isLeaf()) {
                Tree leaf = this.tf.newLeaf(lab);
                leaf.setScore(tree.score());
                return leaf;
            }
            String s = lab.value();
            s = AbstractTreebankParserParams.this.treebankLanguagePack().basicCategory(s);
            s = AbstractTreebankParserParams.this.treebankLanguagePack().stripGF(s);
            int numKids = tree.numChildren();
            ArrayList<Tree> children = new ArrayList<Tree>(numKids);
            for (int cNum = 0; cNum < numKids; ++cNum) {
                Tree child = tree.getChild(cNum);
                Tree newChild = this.transformTree(child);
                children.add(newChild);
            }
            CategoryWordTag newLabel = new CategoryWordTag(lab);
            newLabel.setCategory(s);
            if (lab instanceof HasTag) {
                String tag = ((HasTag)((Object)lab)).tag();
                tag = AbstractTreebankParserParams.this.treebankLanguagePack().basicCategory(tag);
                tag = AbstractTreebankParserParams.this.treebankLanguagePack().stripGF(tag);
                newLabel.setTag(tag);
            }
            Tree node = this.tf.newTreeNode(newLabel, children);
            node.setScore(tree.score());
            return node;
        }
    }

    protected class SubcategoryStripper
    implements TreeTransformer {
        protected TreeFactory tf = new LabeledScoredTreeFactory();

        protected SubcategoryStripper() {
        }

        @Override
        public Tree transformTree(Tree tree) {
            Label lab = tree.label();
            if (tree.isLeaf()) {
                Tree leaf = this.tf.newLeaf(lab);
                leaf.setScore(tree.score());
                return leaf;
            }
            String s = lab.value();
            s = AbstractTreebankParserParams.this.treebankLanguagePack().basicCategory(s);
            int numKids = tree.numChildren();
            ArrayList<Tree> children = new ArrayList<Tree>(numKids);
            for (int cNum = 0; cNum < numKids; ++cNum) {
                Tree child = tree.getChild(cNum);
                Tree newChild = this.transformTree(child);
                children.add(newChild);
            }
            CategoryWordTag newLabel = new CategoryWordTag(lab);
            newLabel.setCategory(s);
            if (lab instanceof HasTag) {
                String tag = ((HasTag)((Object)lab)).tag();
                tag = AbstractTreebankParserParams.this.treebankLanguagePack().basicCategory(tag);
                newLabel.setTag(tag);
            }
            Tree node = this.tf.newTreeNode(newLabel, children);
            node.setScore(tree.score());
            return node;
        }
    }
}

