/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Extractor;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Function;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractTreeExtractor<T>
implements Extractor<T> {
    protected double weight = 1.0;

    protected void tallyLeaf(Tree lt) {
    }

    protected void tallyPreTerminal(Tree lt) {
    }

    protected void tallyInternalNode(Tree lt) {
    }

    protected void tallyRoot(Tree lt) {
    }

    public T formResult() {
        return null;
    }

    protected void tallyLocalTree(Tree lt) {
        if (lt.isLeaf()) {
            this.tallyLeaf(lt);
        } else if (lt.isPreTerminal()) {
            this.tallyPreTerminal(lt);
        } else {
            this.tallyInternalNode(lt);
        }
    }

    public void tallyTree(Tree t) {
        this.tallyRoot(t);
        for (Tree localTree : t.subTreeList()) {
            this.tallyLocalTree(localTree);
        }
    }

    protected void tallyTrees(Collection<Tree> trees) {
        for (Tree tree : trees) {
            this.tallyTree(tree);
        }
    }

    protected void tallyTreeIterator(Iterator<Tree> treeIterator, Function<Tree, Tree> f) {
        while (treeIterator.hasNext()) {
            Tree tree;
            block3: {
                tree = treeIterator.next();
                try {
                    tree = f.apply(tree);
                }
                catch (Exception e) {
                    if (!Test.verbose) break block3;
                    e.printStackTrace();
                }
            }
            this.tallyTree(tree);
        }
    }

    public T extract() {
        return this.formResult();
    }

    @Override
    public T extract(Collection<Tree> treeList) {
        this.tallyTrees(treeList);
        return this.formResult();
    }

    public T extract(Collection<Tree> trees1, Collection<Tree> trees2, double weight) {
        this.tallyTrees(trees1);
        double oldWeight = this.weight;
        this.weight = weight;
        this.tallyTrees(trees2);
        this.weight = oldWeight;
        return this.formResult();
    }

    @Override
    public T extract(Iterator<Tree> treeIterator, Function<Tree, Tree> f) {
        this.tallyTreeIterator(treeIterator, f);
        return this.formResult();
    }
}

