/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.UnnamedDependency;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Pair;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractEval {
    private static final boolean DEBUG = false;
    protected final String str;
    protected final boolean runningAverages;
    private double precision = 0.0;
    private double recall = 0.0;
    private double f1 = 0.0;
    protected double num = 0.0;
    private double exact = 0.0;
    private double precision2 = 0.0;
    private double recall2 = 0.0;
    private double pnum2 = 0.0;
    private double rnum2 = 0.0;

    public AbstractEval() {
        this(true);
    }

    public AbstractEval(boolean runningAverages) {
        this("", runningAverages);
    }

    public AbstractEval(String str) {
        this(str, true);
    }

    public AbstractEval(String str, boolean runningAverages) {
        this.str = str;
        this.runningAverages = runningAverages;
    }

    public double getSentAveF1() {
        return this.f1 / this.num;
    }

    public double getEvalbF1() {
        return 2.0 / (this.rnum2 / this.recall2 + this.pnum2 / this.precision2);
    }

    public double getEvalbF1Percent() {
        return this.getEvalbF1() * 100.0;
    }

    public double getExact() {
        return this.exact / this.num;
    }

    public double getExactPercent() {
        return this.getExact() * 100.0;
    }

    public int getNum() {
        return (int)this.num;
    }

    protected static double precision(Set s1, Set s2) {
        double n = 0.0;
        double p = 0.0;
        for (Object o1 : s1) {
            if (s2.contains(o1)) {
                p += 1.0;
            }
            n += 1.0;
        }
        return n > 0.0 ? p / n : 0.0;
    }

    abstract Set makeObjects(Tree var1);

    public void evaluate(Tree guess, Tree gold) {
        this.evaluate(guess, gold, new PrintWriter(System.out, true));
    }

    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        Set dep1 = this.makeObjects(guess);
        Set dep2 = this.makeObjects(gold);
        double curPrecision = AbstractEval.precision(dep1, dep2);
        double curRecall = AbstractEval.precision(dep2, dep1);
        double curF1 = curPrecision > 0.0 && curRecall > 0.0 ? 2.0 / (1.0 / curPrecision + 1.0 / curRecall) : 0.0;
        this.precision += curPrecision;
        this.recall += curRecall;
        this.f1 += curF1;
        this.num += 1.0;
        this.precision2 += (double)dep1.size() * curPrecision;
        this.pnum2 += (double)dep1.size();
        this.recall2 += (double)dep2.size() * curRecall;
        this.rnum2 += (double)dep2.size();
        if (curF1 > 0.9999) {
            this.exact += 1.0;
        }
        if (pw != null) {
            pw.print(" P: " + (double)((int)(curPrecision * 10000.0)) / 100.0);
            if (this.runningAverages) {
                pw.println(" (sent ave " + (double)((int)(this.precision * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.precision2 * 10000.0 / this.pnum2)) / 100.0 + ")");
            }
            pw.print(" R: " + (double)((int)(curRecall * 10000.0)) / 100.0);
            if (this.runningAverages) {
                pw.print(" (sent ave " + (double)((int)(this.recall * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.recall2 * 10000.0 / this.rnum2)) / 100.0 + ")");
            }
            pw.println();
            double cF1 = 2.0 / (this.rnum2 / this.recall2 + this.pnum2 / this.precision2);
            pw.print(this.str + " F1: " + (double)((int)(curF1 * 10000.0)) / 100.0);
            if (this.runningAverages) {
                pw.print(" (sent ave " + (double)((int)(10000.0 * this.f1 / this.num)) / 100.0 + ", evalb " + (double)((int)(10000.0 * cF1)) / 100.0 + ")   Exact: " + (double)((int)(10000.0 * this.exact / this.num)) / 100.0);
            }
            pw.println(" N: " + this.getNum());
        }
    }

    public void display(boolean verbose) {
        this.display(verbose, new PrintWriter(System.out, true));
    }

    public void display(boolean verbose, PrintWriter pw) {
        double prec = this.precision2 / this.pnum2;
        double rec = this.recall2 / this.rnum2;
        double f = 2.0 / (1.0 / prec + 1.0 / rec);
        pw.println(this.str + " summary evalb: LP: " + (double)((int)(10000.0 * prec)) / 100.0 + " LR: " + (double)((int)(10000.0 * rec)) / 100.0 + " F1: " + (double)((int)(10000.0 * f)) / 100.0 + " Exact: " + (double)((int)(10000.0 * this.exact / this.num)) / 100.0 + " N: " + this.getNum());
    }

    public static class ScoreEval
    extends AbstractEval {
        double totScore = 0.0;
        double n = 0.0;
        NumberFormat nf = new DecimalFormat("0.000");

        @Override
        Set makeObjects(Tree tree) {
            return null;
        }

        public void recordScore(KBestViterbiParser parser, PrintWriter pw) {
            double score = parser.getBestScore();
            this.totScore += score;
            this.n += 1.0;
            if (pw != null) {
                pw.print(this.str + " score: " + this.nf.format(score));
                if (this.runningAverages) {
                    pw.print(" average score: " + this.nf.format(this.totScore / this.n));
                }
                pw.println();
            }
        }

        @Override
        public void display(boolean verbose, PrintWriter pw) {
            if (pw != null) {
                pw.println(this.str + " total score: " + this.nf.format(this.totScore) + " average score: " + (this.n == 0.0 ? "N/A" : this.nf.format(this.totScore / this.n)));
            }
        }

        public ScoreEval(String str, boolean runningAverages) {
            super(str, runningAverages);
        }
    }

    public static class CatErrorEval
    extends AbstractEval {
        private ClassicCounter over = new ClassicCounter();
        private ClassicCounter under = new ClassicCounter();

        @Override
        Set makeObjects(Tree tree) {
            return null;
        }

        List myMakeObjects(Tree tree) {
            LinkedList<String> cats = new LinkedList<String>();
            for (Tree st : tree.subTreeList()) {
                cats.add(st.value());
            }
            return cats;
        }

        @Override
        public void evaluate(Tree t1, Tree t2, PrintWriter pw) {
            List s1 = this.myMakeObjects(t1);
            List s2 = this.myMakeObjects(t2);
            LinkedList del2 = new LinkedList(s2);
            for (Object o1 : s1) {
                if (del2.remove(o1)) continue;
                this.over.incrementCount(o1);
            }
            for (Object o2 : s2) {
                if (s1.remove(o2)) continue;
                this.under.incrementCount(o2);
            }
        }

        protected void display(ClassicCounter c, PrintWriter pw) {
            ArrayList cats = new ArrayList(c.keySet());
            Collections.sort(cats, Counters.toComparatorDescending(c));
            for (Object ob : cats) {
                pw.println(ob + " " + c.getCount(ob));
            }
        }

        @Override
        public void display(boolean verbose, PrintWriter pw) {
            pw.println("Most frequently underproposed categories:");
            this.display(this.under, pw);
            pw.println("Most frequently overproposed categories:");
            this.display(this.over, pw);
        }

        public CatErrorEval(String str) {
            super(str);
        }
    }

    public static class RuleErrorEval
    extends AbstractEval {
        private boolean verbose = false;
        private ClassicCounter over = new ClassicCounter();
        private ClassicCounter under = new ClassicCounter();

        protected static String localize(Tree tree) {
            if (tree.isLeaf()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(tree.label());
            sb.append(" ->");
            for (int i = 0; i < tree.children().length; ++i) {
                sb.append(" ");
                sb.append(tree.children()[i].label());
            }
            return sb.toString();
        }

        @Override
        Set makeObjects(Tree tree) {
            HashSet<String> localTrees = new HashSet<String>();
            for (Tree st : tree.subTreeList()) {
                localTrees.add(RuleErrorEval.localize(st));
            }
            return localTrees;
        }

        @Override
        public void evaluate(Tree t1, Tree t2, PrintWriter pw) {
            Set s1 = this.makeObjects(t1);
            Set s2 = this.makeObjects(t2);
            for (Object o1 : s1) {
                if (s2.contains(o1)) continue;
                this.over.incrementCount(o1);
            }
            for (Object o2 : s2) {
                if (s1.contains(o2)) continue;
                this.under.incrementCount(o2);
            }
        }

        protected void display(ClassicCounter c, int num, PrintWriter pw) {
            ArrayList rules = new ArrayList(c.keySet());
            Collections.sort(rules, Counters.toComparatorDescending(c));
            int rSize = rules.size();
            if (num > rSize) {
                num = rSize;
            }
            for (int i = 0; i < num; ++i) {
                pw.println(rules.get(i) + " " + c.getCount(rules.get(i)));
            }
        }

        @Override
        public void display(boolean verbose, PrintWriter pw) {
            this.verbose = verbose;
            pw.println("Most frequently underproposed rules:");
            this.display(this.under, verbose ? 100 : 10, pw);
            pw.println("Most frequently overproposed rules:");
            this.display(this.over, verbose ? 100 : 10, pw);
        }

        public RuleErrorEval(String str) {
            super(str);
        }
    }

    public static class TaggingEval
    extends AbstractEval {
        private static final boolean DEBUG = false;
        private static final boolean DEBUG_MORE = false;
        private final Lexicon lex;
        private final boolean useTag;

        @Override
        Set makeObjects(Tree tree) {
            Sentence<TaggedWord> twList = this.useTag ? TaggingEval.myExtractor(tree) : tree.taggedYield();
            HashSet<Pair<Integer, WordTag>> set = new HashSet<Pair<Integer, WordTag>>();
            int sz = twList.size();
            for (int i = 0; i < sz; ++i) {
                TaggedWord tw = (TaggedWord)twList.get(i);
                Pair<Integer, WordTag> positionWT = new Pair<Integer, WordTag>(i, new WordTag(tw.value(), tw.tag()));
                set.add(positionWT);
            }
            return set;
        }

        public TaggingEval(String str) {
            this(str, true, null);
        }

        public TaggingEval(String str, boolean runningAverages, Lexicon lex) {
            this(str, runningAverages, lex, false);
        }

        public TaggingEval(String str, boolean runningAverages, Lexicon lex, boolean useTag) {
            super(str, runningAverages);
            this.lex = lex;
            this.useTag = useTag;
        }

        private static Sentence<TaggedWord> myExtractor(Tree t) {
            return TaggingEval.myExtractor(t, new Sentence<TaggedWord>());
        }

        private static Sentence<TaggedWord> myExtractor(Tree t, Sentence<TaggedWord> ty) {
            Tree[] kids = t.children();
            if (kids.length == 1 && kids[0].isLeaf()) {
                if (t.label() instanceof HasTag) {
                    ty.add(new TaggedWord(kids[0].label().value(), ((HasTag)((Object)t.label())).tag()));
                } else {
                    ty.add(new TaggedWord(kids[0].label().value(), t.label().value()));
                }
            } else {
                for (int i = 0; i < kids.length; ++i) {
                    TaggingEval.myExtractor(kids[i], ty);
                }
            }
            return ty;
        }

        @Override
        public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
            Sentence<TaggedWord> sGold = gold.taggedYield();
            Sentence<TaggedWord> sGuess = this.useTag ? TaggingEval.myExtractor(guess) : guess.taggedYield();
            if (sGuess.size() != sGold.size()) {
                pw.println("Warning: yield length differs:");
                pw.println("Guess: " + sGuess);
                pw.println("Gold:  " + sGold);
            }
            super.evaluate(guess, gold, pw);
        }
    }

    public static class DependencyEval
    extends AbstractEval {
        private static final boolean DEBUG = false;
        Filter<String> punctFilter;

        @Override
        Set makeObjects(Tree tree) {
            HashSet<UnnamedDependency> deps = new HashSet<UnnamedDependency>();
            for (Tree node : tree.subTreeList()) {
                if (node.isLeaf() || node.children().length < 2) continue;
                String head = ((HasWord)((Object)node.label())).word();
                boolean seenHead = false;
                for (int cNum = 0; cNum < node.children().length; ++cNum) {
                    Tree child = node.children()[cNum];
                    String arg = ((HasWord)((Object)child.label())).word();
                    if (head.equals(arg) && !seenHead) {
                        seenHead = true;
                        continue;
                    }
                    if (this.punctFilter.accept(arg)) continue;
                    deps.add(new UnnamedDependency(head, arg));
                }
            }
            return deps;
        }

        public DependencyEval(String str, boolean runningAverages, Filter<String> punctFilter) {
            super(str, runningAverages);
            this.punctFilter = punctFilter;
        }
    }
}

