/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.objectbank.IdentityFunction;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.XMLUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

public class XMLBeginEndIterator<E>
extends AbstractIterator<E>
implements Tokenizer<E> {
    private final Pattern tagNamePattern;
    private final BufferedReader in;
    private final Function<String, E> op;
    private final boolean keepInternalTags;
    private final boolean keepDelimitingTags;
    private E nextToken;

    public XMLBeginEndIterator(Reader in, String tagNameRegexp) {
        this(in, tagNameRegexp, new IdentityFunction(), false);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, boolean keepInternalTags) {
        this(in, tagNameRegexp, new IdentityFunction(), keepInternalTags);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, Function<String, E> op, boolean keepInternalTags) {
        this(in, tagNameRegexp, op, keepInternalTags, false);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, boolean keepInternalTags, boolean keepDelimitingTags) {
        this(in, tagNameRegexp, new IdentityFunction(), keepInternalTags, keepDelimitingTags);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, Function<String, E> op, boolean keepInternalTags, boolean keepDelimitingTags) {
        this.tagNamePattern = Pattern.compile(tagNameRegexp);
        this.op = op;
        this.keepInternalTags = keepInternalTags;
        this.keepDelimitingTags = keepDelimitingTags;
        this.in = new BufferedReader(in);
        this.setNext();
    }

    private void setNext() {
        String s = this.getNext();
        this.nextToken = this.parseString(s);
    }

    private String getNext() {
        StringBuilder result = new StringBuilder();
        try {
            XMLUtils.XMLTag tag;
            do {
                XMLUtils.readUntilTag(this.in);
                tag = XMLUtils.readAndParseTag(this.in);
                if (tag != null) continue;
                return null;
            } while (!this.tagNamePattern.matcher(tag.name).matches() || tag.isEndTag);
            if (this.keepDelimitingTags) {
                result.append(tag.toString());
            }
            while (true) {
                String tagString;
                String text;
                if ((text = XMLUtils.readUntilTag(this.in)) != null) {
                    result.append(text);
                }
                if ((tag = XMLUtils.parseTag(tagString = XMLUtils.readTag(this.in))) == null) {
                    return null;
                }
                if (this.tagNamePattern.matcher(tag.name).matches() && tag.isEndTag) {
                    if (this.keepDelimitingTags) {
                        result.append(tagString);
                    }
                    break;
                }
                if (!this.keepInternalTags) continue;
                result.append(tagString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    protected E parseString(String s) {
        return this.op.apply(s);
    }

    @Override
    public boolean hasNext() {
        return this.nextToken != null;
    }

    @Override
    public E next() {
        if (this.nextToken == null) {
            throw new NoSuchElementException();
        }
        E token = this.nextToken;
        this.setNext();
        return token;
    }

    @Override
    public E peek() {
        return this.nextToken;
    }

    @Override
    public List<E> tokenize() {
        ArrayList<E> result = new ArrayList<E>();
        while (this.hasNext()) {
            result.add(this.next());
        }
        return result;
    }

    public static IteratorFromReaderFactory<String> getFactory(String tag) {
        return new XMLBeginEndIteratorFactory<String>(tag, new IdentityFunction(), false, false);
    }

    public static IteratorFromReaderFactory<String> getFactory(String tag, boolean keepInternalTags, boolean keepDelimitingTags) {
        return new XMLBeginEndIteratorFactory<String>(tag, new IdentityFunction(), keepInternalTags, keepDelimitingTags);
    }

    public static <E> IteratorFromReaderFactory<E> getFactory(String tag, Function<String, E> op) {
        return new XMLBeginEndIteratorFactory<E>(tag, op, false, false);
    }

    public static <E> IteratorFromReaderFactory<E> getFactory(String tag, Function<String, E> op, boolean keepInternalTags, boolean keepDelimitingTags) {
        return new XMLBeginEndIteratorFactory<E>(tag, op, keepInternalTags, keepDelimitingTags);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("usage: XMLBeginEndIterator file element keepInternalBoolean");
            return;
        }
        FileReader in = new FileReader(args[0]);
        XMLBeginEndIterator iter = new XMLBeginEndIterator(in, args[1], args[2].equalsIgnoreCase("true"));
        while (iter.hasNext()) {
            String s = (String)iter.next();
            System.out.println("*************************************************");
            System.out.println(s);
        }
        ((Reader)in).close();
    }

    static class XMLBeginEndIteratorFactory<E>
    implements IteratorFromReaderFactory<E> {
        private final String tag;
        private final Function<String, E> op;
        private final boolean keepInternalTags;
        private final boolean keepDelimitingTags;

        public XMLBeginEndIteratorFactory(String tag, Function<String, E> op, boolean keepInternalTags, boolean keepDelimitingTags) {
            this.tag = tag;
            this.op = op;
            this.keepInternalTags = keepInternalTags;
            this.keepDelimitingTags = keepDelimitingTags;
        }

        @Override
        public Iterator<E> getIterator(Reader r) {
            return new XMLBeginEndIterator<E>(r, this.tag, this.op, this.keepInternalTags, this.keepDelimitingTags);
        }
    }
}

