/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.objectbank.IdentityFunction;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.objectbank.LineIterator;
import edu.stanford.nlp.objectbank.ReaderIteratorFactory;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.Function;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ObjectBank<E>
implements Collection<E>,
Serializable {
    protected ReaderIteratorFactory rif;
    protected IteratorFromReaderFactory<E> ifrf;
    private List<E> contents;
    private boolean keepInMemory;
    private static final long serialVersionUID = -4030295596701541770L;

    public ObjectBank(ReaderIteratorFactory rif, IteratorFromReaderFactory<E> ifrf) {
        this.rif = rif;
        this.ifrf = ifrf;
    }

    public static <X> ObjectBank<X> getLineIteratorObjectBank(String fileOrString, Function<String, X> op) {
        ArrayList<String> c = new ArrayList<String>();
        c.add(fileOrString);
        return ObjectBank.getLineIteratorObjectBank(c, op);
    }

    public static <X> ObjectBank<X> getLineIteratorObjectBank(Collection files, Function<String, X> op) {
        return ObjectBank.getLineIteratorObjectBank(files, op, "utf-8");
    }

    public static <X> ObjectBank<X> getLineIteratorObjectBank(Collection files, Function<String, X> op, String encoding) {
        ReaderIteratorFactory rif = new ReaderIteratorFactory(files, encoding);
        IteratorFromReaderFactory<X> ifrf = LineIterator.getFactory(op);
        return new ObjectBank<X>(rif, ifrf);
    }

    public static ObjectBank<String> getLineIteratorObjectBank(String filename, String encoding) {
        return ObjectBank.getLineIteratorObjectBank(Collections.singleton(filename), new IdentityFunction(), encoding);
    }

    public static ObjectBank<String> getLineIteratorObjectBank(String filename) {
        return ObjectBank.getLineIteratorObjectBank(filename, "utf-8");
    }

    @Override
    public Iterator<E> iterator() {
        if (this.keepInMemory) {
            if (this.contents == null) {
                this.contents = new ArrayList();
                OBIterator iter = new OBIterator();
                while (iter.hasNext()) {
                    this.contents.add(iter.next());
                }
            }
            return this.contents.iterator();
        }
        return new OBIterator();
    }

    public void keepInMemory(boolean keep) {
        this.keepInMemory = keep;
    }

    public void clearMemory() {
        this.contents = null;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public boolean contains(Object o) {
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        Iterator<E> iter = this.iterator();
        int size = 0;
        while (iter.hasNext()) {
            ++size;
            iter.next();
        }
        return size;
    }

    @Override
    public void clear() {
        this.rif = new ReaderIteratorFactory();
    }

    @Override
    public Object[] toArray() {
        Iterator<E> iter = this.iterator();
        ArrayList<E> al = new ArrayList<E>();
        while (iter.hasNext()) {
            al.add(iter.next());
        }
        return al.toArray();
    }

    @Override
    public <T> T[] toArray(T[] o) {
        Iterator<E> iter = this.iterator();
        ArrayList<E> al = new ArrayList<E>();
        while (iter.hasNext()) {
            al.add(iter.next());
        }
        return al.toArray(o);
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    class OBIterator
    extends AbstractIterator<E> {
        Iterator<Reader> readerIterator;
        Iterator<E> tok;
        E nextObject;
        Reader currReader = null;

        public OBIterator() {
            this.readerIterator = ObjectBank.this.rif.iterator();
            this.currReader = this.readerIterator.next();
            this.tok = ObjectBank.this.ifrf.getIterator(this.currReader);
            this.setNextObject();
        }

        private void setNextObject() {
            if (this.tok.hasNext()) {
                this.nextObject = this.tok.next();
                return;
            }
            do {
                if (this.readerIterator.hasNext()) {
                    try {
                        this.currReader.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.nextObject = null;
                    return;
                }
                this.currReader = this.readerIterator.next();
                this.tok = ObjectBank.this.ifrf.getIterator(this.currReader);
            } while (!this.tok.hasNext());
            this.nextObject = this.tok.next();
        }

        @Override
        public boolean hasNext() {
            return this.nextObject != null;
        }

        @Override
        public E next() {
            if (this.nextObject == null) {
                throw new NoSuchElementException();
            }
            Object tmp = this.nextObject;
            this.setNextObject();
            return tmp;
        }
    }
}

