/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.objectbank.IdentityFunction;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.Function;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Iterator;

public class LineIterator<X>
extends AbstractIterator<X> {
    private Function<String, X> op;
    private BufferedReader in;
    private X nextToken;

    public LineIterator(Reader r) {
        this(r, new IdentityFunction());
    }

    public LineIterator(Reader r, Function<String, X> op) {
        this.op = op;
        this.in = new BufferedReader(r);
        this.setNext();
    }

    private void setNext() {
        String line = null;
        try {
            line = this.in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.nextToken = line != null ? this.op.apply(line) : null;
    }

    @Override
    public boolean hasNext() {
        return this.nextToken != null;
    }

    @Override
    public X next() {
        X token = this.nextToken;
        this.setNext();
        return token;
    }

    public Object peek() {
        return this.nextToken;
    }

    public static <X> IteratorFromReaderFactory<X> getFactory() {
        return new LineIteratorFactory();
    }

    public static <X> IteratorFromReaderFactory<X> getFactory(Function<String, X> op) {
        return new LineIteratorFactory<X>(op);
    }

    public static void main(String[] args) {
        String s = "\n\n@@123\nthis\nis\na\nsentence\n\n@@124\nThis\nis\nanother\n.\n\n@125\nThis\nis\nthe\nlast\n";
        LineIterator di = new LineIterator(new StringReader(s), new IdentityFunction());
        System.out.println("--- start ---");
        while (di.hasNext()) {
            System.out.println((String)di.next());
        }
        System.out.println("---- end ----");
    }

    public static class LineIteratorFactory<X>
    implements IteratorFromReaderFactory<X>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Function<String, X> oper;

        public LineIteratorFactory() {
            this(new IdentityFunction());
        }

        public LineIteratorFactory(Function<String, X> op) {
            this.oper = op;
        }

        @Override
        public Iterator<X> getIterator(Reader r) {
            return new LineIterator<X>(r, this.oper);
        }
    }
}

