/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.WordLemmaTagFactory;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.process.Morphology;

public class WordLemmaTag
implements Label,
Comparable<WordLemmaTag>,
HasWord,
HasTag {
    private String word;
    private String lemma;
    private String tag;
    private static String divider = "/";
    private static final long serialVersionUID = -5993410244163988138L;

    public WordLemmaTag(String word) {
        this.word = word;
        this.lemma = null;
        this.setTag(null);
    }

    public WordLemmaTag(Label word) {
        this(word.value());
    }

    public WordLemmaTag() {
    }

    public WordLemmaTag(String word, String tag) {
        WordTag wT = new WordTag(word, tag);
        this.word = word;
        this.lemma = Morphology.stemStatic(wT).word();
        this.setTag(tag);
    }

    public WordLemmaTag(String word, String lemma, String tag) {
        this(word);
        this.lemma = lemma;
        this.setTag(tag);
    }

    public WordLemmaTag(Label word, Label tag) {
        this(word);
        WordTag wT = new WordTag(word, tag);
        this.lemma = Morphology.stemStatic(wT).word();
        this.setTag(tag.value());
    }

    @Override
    public String value() {
        return this.word;
    }

    @Override
    public String word() {
        return this.value();
    }

    @Override
    public void setValue(String value) {
        this.word = value;
    }

    @Override
    public void setWord(String word) {
        this.setValue(word);
    }

    public void setLemma(String lemma) {
        this.lemma = lemma;
    }

    @Override
    public final void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public String tag() {
        return this.tag;
    }

    public String lemma() {
        return this.lemma;
    }

    @Override
    public String toString() {
        return this.word() + divider + this.lemma + divider + this.tag;
    }

    @Override
    public void setFromString(String labelStr) {
        int second;
        int first = labelStr.indexOf(divider);
        if (first == (second = labelStr.lastIndexOf(divider))) {
            this.setWord(labelStr.substring(0, first));
            this.setTag(labelStr.substring(first + 1));
            this.setLemma(Morphology.stemStatic(labelStr.substring(0, first), labelStr.substring(first + 1)).word());
        } else if (first >= 0) {
            this.setWord(labelStr.substring(0, first));
            this.setLemma(labelStr.substring(first + 1, second));
            this.setTag(labelStr.substring(second + 1));
        } else {
            this.setWord(labelStr);
            this.setLemma(null);
            this.setTag(null);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WordLemmaTag)) {
            return false;
        }
        WordLemmaTag other = (WordLemmaTag)o;
        return this.word().equals(other.word()) && this.lemma().equals(other.lemma()) && this.tag().equals(other.tag());
    }

    public int hashCode() {
        int result = this.word != null ? this.word.hashCode() : 3;
        result = 29 * result + (this.tag != null ? this.tag.hashCode() : 0);
        result = 29 * result + (this.lemma != null ? this.lemma.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(WordLemmaTag wordLemmaTag) {
        int first = this.word().compareTo(wordLemmaTag.word());
        if (first != 0) {
            return first;
        }
        int second = this.lemma().compareTo(wordLemmaTag.lemma());
        if (second != 0) {
            return second;
        }
        return this.tag().compareTo(wordLemmaTag.tag());
    }

    @Override
    public LabelFactory labelFactory() {
        return new WordLemmaTagFactory();
    }

    public static void setDivider(String divider) {
        WordLemmaTag.divider = divider;
    }

    public static void main(String[] args) {
        WordLemmaTag wLT = new WordLemmaTag();
        wLT.setFromString("hunter/NN");
        System.out.println(wLT.word());
        System.out.println(wLT.lemma());
        System.out.println(wLT.tag());
        WordLemmaTag wLT2 = new WordLemmaTag();
        wLT2.setFromString("bought/buy/V");
        System.out.println(wLT2.word());
        System.out.println(wLT2.lemma());
        System.out.println(wLT2.tag());
        WordLemmaTag wLT3 = new WordLemmaTag();
        wLT2.setFromString("life");
        System.out.println(wLT3.word());
        System.out.println(wLT3.lemma());
        System.out.println(wLT3.tag());
    }
}

