/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabel;

public class Tag
extends StringLabel
implements HasTag {
    public Tag() {
    }

    public Tag(String tag) {
        super(tag);
    }

    public Tag(Label lab) {
        super(lab);
    }

    @Override
    public String tag() {
        return this.value();
    }

    @Override
    public void setTag(String tag) {
        this.setValue(tag);
    }

    @Override
    public LabelFactory labelFactory() {
        return LabelFactoryHolder.lf;
    }

    public static LabelFactory factory() {
        return LabelFactoryHolder.lf;
    }

    private static class LabelFactoryHolder {
        private static final LabelFactory lf = new TagFactory();

        private LabelFactoryHolder() {
        }
    }

    private static class TagFactory
    implements LabelFactory {
        @Override
        public Label newLabel(String cat) {
            return new Tag(cat);
        }

        @Override
        public Label newLabel(String cat, int options) {
            return new Tag(cat);
        }

        @Override
        public Label newLabelFromString(String cat) {
            return new Tag(cat);
        }

        @Override
        public Label newLabel(Label oldLabel) {
            return new Tag(oldLabel);
        }
    }
}

