/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.util.Pair;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NumberRangesFileFilter
implements FileFilter {
    private List<Pair<Integer, Integer>> ranges = new ArrayList<Pair<Integer, Integer>>();
    private boolean recursively;

    public NumberRangesFileFilter(String ranges, boolean recurse) {
        this.recursively = recurse;
        try {
            String[] ra = ranges.split(",");
            for (int i = 0; i < ra.length; ++i) {
                String[] one = ra[i].split("-");
                if (one.length > 2) {
                    throw new IllegalArgumentException("Too many hyphens");
                }
                int low = Integer.parseInt(one[0].trim());
                int high = one.length == 2 ? Integer.parseInt(one[1].trim()) : low;
                Pair<Integer, Integer> p = new Pair<Integer, Integer>(low, high);
                this.ranges.add(p);
            }
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Constructor argument not valid: " + ranges);
            iae.initCause(e);
            throw iae;
        }
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return this.recursively;
        }
        String filename = file.getName();
        return this.accept(filename);
    }

    public boolean accept(String str) {
        int k = str.length() - 1;
        char c = str.charAt(k);
        while (k >= 0 && !Character.isDigit(c)) {
            if (--k < 0) continue;
            c = str.charAt(k);
        }
        if (k < 0) {
            return false;
        }
        int j = k;
        c = str.charAt(j);
        while (j >= 0 && Character.isDigit(c)) {
            if (--j < 0) continue;
            c = str.charAt(j);
        }
        String theNumber = str.substring(++j, ++k);
        int number = Integer.parseInt(theNumber);
        for (Pair<Integer, Integer> p : this.ranges) {
            int low = p.first();
            int high = p.second();
            if (number < low || number > high) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = this.recursively ? new StringBuilder("recursively ") : new StringBuilder();
        Iterator<Pair<Integer, Integer>> it = this.ranges.iterator();
        while (it.hasNext()) {
            int high;
            Pair<Integer, Integer> p = it.next();
            int low = p.first();
            if (low == (high = p.second().intValue())) {
                sb.append(low);
            } else {
                sb.append(low);
                sb.append("-");
                sb.append(high);
            }
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

