/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.FilterFunction;
import edu.cmu.cs.lti.relationFilter.Relation;
import edu.cmu.cs.lti.relationFilter.SentenceData;
import edu.cmu.cs.lti.relationFilter.Token;
import edu.stanford.nlp.trees.Tree;
import java.util.ArrayList;

public class SentenceLikeBoundaryFeature
implements FilterFunction {
    @Override
    public boolean filter(SentenceData s, Relation r) {
        Tree e2;
        Object s_parent = null;
        Tree e1 = this.GetFirstTreeNode(r._e1, s);
        Tree anc1 = Tree.leastCommonAncestor(e1, e2 = this.GetFirstTreeNode(r._e2, s));
        if (((Object)anc1.label()).toString().equals("S") && !this.isCrossOverSemiColon(s, r)) {
            return true;
        }
        ArrayList<Token> all = new ArrayList<Token>();
        r.copyTo(all, r._e1);
        int m = all.size();
        int lpost = r._e1[m - 1]._position;
        Tree lpost_parent = s.leafAt(lpost).getParent();
        if (((Object)lpost_parent.label()).toString().equals("WP") || ((Object)lpost_parent.label()).toString().equals("WDT") || ((Object)lpost_parent.label()).toString().equals("WP$")) {
            --m;
        }
        for (int i = 0; i < m; ++i) {
            int pos = all.get((int)i)._position;
            Object s_current = null;
            if (pos == -1) continue;
            try {
                Tree n = s.leafAt(pos);
                if (this.isCrossOverSBAR(n)) {
                    return false;
                }
                if (!this.isCrossOverSemiColon(s, r)) continue;
                return false;
            }
            catch (Exception e) {
                System.out.println("DEBUG **** ERROR in SentenceLikeBoundaryFeature ****");
                System.out.println(pos);
                System.out.println(s.toString());
                System.exit(-1);
            }
        }
        return true;
    }

    private boolean isCrossOverSBAR(Tree node) {
        String label = ((Object)node.label()).toString();
        if (node == null) {
            return false;
        }
        if (label.equals("SBAR")) {
            return true;
        }
        if (node.getParent() == null || label.equals("ROOT")) {
            return false;
        }
        return this.isCrossOverSBAR(node.getParent());
    }

    private boolean isCrossOverSemiColon(SentenceData s, Relation r) {
        int begin = Math.min(r._e1[0]._position, r._e2[r._e2.length - 1]._position);
        int end = Math.max(r._e1[0]._position, r._e2[r._e2.length - 1]._position);
        if (begin == 0) {
            begin = 1;
        }
        for (int i = begin; i <= end; ++i) {
            if (!s.POSTagAt(i).equals(":") || i <= 5 || s.leafAt(i).toString().equals("-")) continue;
            return true;
        }
        return false;
    }

    private Tree GetFirstTreeNode(Token[] tokens, SentenceData s) {
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i]._position == -1 || s.POSTagAt(tokens[i]._position).equals("IN")) continue;
            return s.leafAt(tokens[i]._position);
        }
        return null;
    }
}

