/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.Dependency;
import edu.cmu.cs.lti.relationFilter.DependencyTree;
import edu.cmu.cs.lti.relationFilter.Relation;
import edu.cmu.cs.lti.relationFilter.RelationGenerator;
import edu.cmu.cs.lti.relationFilter.SentenceRawData;
import edu.cmu.cs.lti.relationFilter.Token;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import mark.chunking.Chunker;

public class SentenceData {
    private SentenceRawData _rawData;
    private String _chunked;
    private Tree _parseTree;
    private TreeGraphNode _parseTreeGraph;
    private List<Tree> _parseTreeLeaves;
    private ArrayList<Relation> _relations;
    private ArrayList<Dependency> _dependencies;
    private ArrayList<Dependency> _typedDependencies;
    private DependencyTree _dependTree;
    private int _minDistOfNP1andNP2 = 9999;
    private int _maxDistOfNP1andNP2 = 0;
    private int _minDistOfNP1andVP = 9999;
    private int _maxDistOfNP1andVP = 0;
    private int _minDistOfNP2andVP = 9999;
    private int _maxDistOfNP2andVP = 0;
    public ArrayList<ArrayList<Token>> NP = new ArrayList();
    public ArrayList<ArrayList<Token>> VP = new ArrayList();

    public SentenceData(SentenceRawData rawData, int verbosity) {
        this._rawData = rawData;
        this.processRawData(verbosity);
    }

    public int size() {
        String data = this._rawData._sentWithPOS;
        String[] toks = data.split(" ");
        return toks.length;
    }

    public String getRawSentenceString() {
        String data = this._rawData._sentWithPOS;
        String[] toks = data.split(" ");
        String current = "";
        for (int k = 0; k < toks.length; ++k) {
            int pos = toks[k].lastIndexOf("/");
            String token = toks[k].substring(0, pos);
            current = current + token + " ";
        }
        return current;
    }

    public ArrayList<String> NPtoString() {
        ArrayList<String> NPlist = new ArrayList<String>();
        for (int i = 0; i < this.NP.size(); ++i) {
            String _np = "";
            for (int j = 0; j < this.NP.get(i).size() - 1; ++j) {
                _np = _np + this.NP.get(i).get(j).toString() + " ";
            }
            _np = _np + this.NP.get(i).get(this.NP.get(i).size() - 1).toString();
            NPlist.add(_np);
        }
        return NPlist;
    }

    public ArrayList<String> VPtoString() {
        ArrayList<String> VPlist = new ArrayList<String>();
        for (int i = 0; i < this.VP.size(); ++i) {
            String _vp = "";
            for (int j = 0; j < this.VP.get(i).size() - 1; ++j) {
                _vp = _vp + this.VP.get(i).get(j).toString() + " ";
            }
            _vp = _vp + this.VP.get(i).get(this.VP.get(i).size() - 1).toString();
            VPlist.add(_vp);
        }
        return VPlist;
    }

    private void processRawData(int verbosity) {
        this.chunkSentence();
        this.initParseTree();
        this.initRelations2(verbosity);
        this.initDependencies();
        this.initTypedDependencies();
    }

    private void initParseTree() {
        if (this._rawData == null) {
            return;
        }
        try {
            this._parseTree = Tree.valueOf(this._rawData._parseTree);
            this._parseTree.initParent();
            this._parseTreeLeaves = this._parseTree.getLeaves();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initDependencies() {
        this._dependencies = new ArrayList();
        if (this._rawData._dependencyParse != null) {
            StringTokenizer t = new StringTokenizer(this._rawData._dependencyParse, "\n");
            while (t.hasMoreElements()) {
                String a = t.nextToken();
                this._dependencies.add(new Dependency(a));
            }
        }
        this._dependTree = DependencyTree.load(this._dependencies);
        for (int i = 0; i < this._relations.size(); ++i) {
            Relation rel = this._relations.get(i);
            ArrayList<String> depfeat = this.getDependencyFeature(rel, this._dependTree);
            rel._features.addAll(depfeat);
        }
    }

    private void initTypedDependencies() {
        this._typedDependencies = new ArrayList();
        if (this._rawData._typedDependencyParse != null) {
            StringTokenizer t = new StringTokenizer(this._rawData._typedDependencyParse, "\n");
            while (t.hasMoreElements()) {
                String a = t.nextToken();
                this._typedDependencies.add(new Dependency().initTypedDependency(a));
            }
        }
    }

    private void initRelations() {
        this._relations = new ArrayList();
        if (this._rawData._candidateRelations != null) {
            StringTokenizer t = new StringTokenizer(this._rawData._candidateRelations, "\n");
            while (t.hasMoreElements()) {
                this._relations.add(new Relation(t.nextToken()));
            }
        }
    }

    private void initRelations2(int verbosity) {
        if (this._chunked != null) {
            RelationGenerator rg = new RelationGenerator();
            this._relations = rg.GenerateRelations(this._chunked, verbosity);
            this.NP = new ArrayList();
            this.VP = new ArrayList();
            this.NP = rg.getBaseNP();
            this.VP = rg.getBaseVP();
        }
    }

    private ArrayList<String> getDependencyFeature(Relation r, DependencyTree tree) {
        if (tree == null) {
            return null;
        }
        ArrayList<String> f = new ArrayList<String>();
        this._minDistOfNP1andNP2 = this.getMinDistance(tree, r._e1, r._e2);
        this._maxDistOfNP1andNP2 = this.getMaxDistance(tree, r._e1, r._e2);
        this._minDistOfNP1andVP = this.getMinDistance(tree, r._e1, r._r);
        this._maxDistOfNP1andVP = this.getMaxDistance(tree, r._e1, r._r);
        this._minDistOfNP2andVP = this.getMinDistance(tree, r._e2, r._r);
        this._maxDistOfNP2andVP = this.getMaxDistance(tree, r._e2, r._r);
        if (r.e2toString().equals("-10000")) {
            this._minDistOfNP1andNP2 = 0;
            this._maxDistOfNP1andNP2 = 0;
            this._minDistOfNP2andVP = 0;
            this._maxDistOfNP2andVP = 0;
        }
        f.add(Integer.toString(this._minDistOfNP1andNP2));
        f.add(Integer.toString(this._maxDistOfNP1andNP2));
        f.add(Integer.toString(this._minDistOfNP1andVP));
        f.add(Integer.toString(this._maxDistOfNP1andVP));
        f.add(Integer.toString(this._minDistOfNP2andVP));
        f.add(Integer.toString(this._maxDistOfNP2andVP));
        return f;
    }

    private int getMinDistance(DependencyTree tree, Token[] e1, Token[] e2) {
        int minDist = 9999;
        for (int i = 0; i < e1.length; ++i) {
            for (int j = 0; j < e2.length; ++j) {
                Token t1 = e1[i];
                Token t2 = e2[j];
                if (t1._position == -1 || t2._position == -1) continue;
                int distance = tree.distance(t1, t2);
                if (distance == 1000000) {
                    return -1;
                }
                if (minDist <= distance) continue;
                minDist = distance;
            }
        }
        return minDist;
    }

    private int getMaxDistance(DependencyTree tree, Token[] e1, Token[] e2) {
        int maxDist = 0;
        for (int i = 0; i < e1.length; ++i) {
            for (int j = 0; j < e2.length; ++j) {
                Token t1 = e1[i];
                Token t2 = e2[j];
                if (t1._position == -1 || t2._position == -1) continue;
                int distance = tree.distance(t1, t2);
                if (distance == 1000000) {
                    return -1;
                }
                if (maxDist >= distance) continue;
                maxDist = distance;
            }
        }
        return maxDist;
    }

    private void chunkSentence() {
        String data = this._rawData._sentWithPOS;
        data = data.substring(0, data.length() - 1);
        this._chunked = Chunker.instance().processSentence(data);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this._rawData != null) {
            if (this._rawData._sentWithPOS != null) {
                result.append(this._rawData._sentWithPOS);
            }
            result.append("\n");
            if (this._rawData._parseTree != null) {
                result.append(this._rawData._parseTree);
            }
            result.append("\n");
            if (this._rawData._dependencyParse != null) {
                result.append(this._rawData._dependencyParse);
            }
            result.append("\n");
            int relCount = this._relations.size();
            for (int i = 0; i < relCount; ++i) {
                result.append(this._relations.get(i).toString());
                result.append("\n");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public Relation relationAt(int index) {
        if (index < this._relations.size()) {
            return this._relations.get(index);
        }
        return null;
    }

    public int relationCount() {
        return this._relations.size();
    }

    public Tree leafAt(int index) {
        if (--index < this._parseTreeLeaves.size()) {
            return this._parseTreeLeaves.get(index);
        }
        return null;
    }

    public String POSTagAt(int index) {
        List<Label> POStag = this._parseTree.preTerminalYield();
        if (--index < POStag.size()) {
            return ((Object)POStag.get(index)).toString();
        }
        return null;
    }

    public DependencyTree dependTree() {
        return this._dependTree;
    }

    public ArrayList<Dependency> getTypedDependencies() {
        return this._typedDependencies;
    }
}

