/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.Hypothesis;
import edu.cmu.cs.lti.relationFilter.Loss;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class RougeN
implements Loss {
    int ngram = 4;
    double precision = 0.0;
    double recall = 0.0;

    public RougeN() {
    }

    public RougeN(int i) {
        this.ngram = i;
    }

    @Override
    public double calculate(ArrayList<String> reference, Hypothesis guess) {
        double result = 0.0;
        if (guess == null) {
            return result;
        }
        ArrayList<String> hyp = guess.toStringArray();
        result = this.doAveF(reference, hyp);
        return result;
    }

    @Override
    public double precision() {
        return this.precision;
    }

    @Override
    public double recall() {
        return this.recall;
    }

    @Override
    public double calculate(ArrayList<String> reference, ArrayList<String> hyp) {
        double result = this.doAveF(reference, hyp);
        return result;
    }

    private double doAveF(ArrayList<String> reference, ArrayList<String> hyp) {
        Map<String, Double> HypCounts = this.count_ngram(hyp, this.ngram);
        Map<String, Double> RefCounts = this.count_ngram(reference, this.ngram);
        double ref_ngram_total = 0.0;
        double hyp_ngram_total = 0.0;
        double matched_ngram = 0.0;
        for (String ls : RefCounts.keySet()) {
            ref_ngram_total += RefCounts.get(ls).doubleValue();
        }
        for (String ls : HypCounts.keySet()) {
            hyp_ngram_total += HypCounts.get(ls).doubleValue();
            if (!RefCounts.containsKey(ls)) continue;
            matched_ngram += RefCounts.get(ls).doubleValue();
        }
        this.recall = matched_ngram / ref_ngram_total;
        this.precision = matched_ngram / hyp_ngram_total;
        double f = 2.0 * this.recall * this.precision / (this.recall + this.precision);
        if (Double.isNaN(f)) {
            f = 0.0;
        }
        if (Double.isNaN(this.recall)) {
            this.recall = 0.0;
        }
        if (Double.isNaN(this.precision)) {
            this.precision = 0.0;
        }
        return f;
    }

    private Map<String, Double> count_ngram(ArrayList<String> hyp, int len) {
        HashMap<String, Double> counts = new HashMap<String, Double>();
        for (int j = 0; j < hyp.size(); ++j) {
            String[] words = hyp.get(j).split(" ");
            for (int i = 0; i <= words.length - len; ++i) {
                Object[] ngr = Arrays.copyOfRange(words, i, i + len);
                String ngram = StringUtils.join(ngr, " ").toLowerCase();
                Double ct = (Double)counts.get(ngram);
                if (ct == null) {
                    ct = 0.0;
                }
                if (len < 6) {
                    counts.put(ngram, ct + 1.0);
                    continue;
                }
                counts.put(ngram, ct + 2.0);
            }
        }
        return counts;
    }
}

