/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.Relation;
import edu.cmu.cs.lti.relationFilter.Token;
import edu.cmu.cs.lti.relationFilter.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class RelationGenerator {
    private ArrayList<ArrayList<Token>> NP = new ArrayList();
    private ArrayList<ArrayList<Token>> VP = new ArrayList();
    static int MAX = 10000;

    public ArrayList<ArrayList<Token>> getBaseNP() {
        return this.NP;
    }

    public ArrayList<ArrayList<Token>> getBaseVP() {
        return this.VP;
    }

    public ArrayList<Relation> GenerateRelations(String sentence, int verbosity) {
        Token token;
        int i;
        int e1;
        ArrayList<Relation> relations = new ArrayList<Relation>();
        Sentence s = new Sentence(sentence, verbosity);
        s.tuneChunks();
        if (verbosity > 1) {
            int j;
            Tuple mnp;
            int i2;
            System.out.println("\nDEBUG\nNP chunks after merging and cleaning\n");
            for (i2 = 0; i2 < s.chunksNP.size(); ++i2) {
                mnp = s.chunksNP.get(i2);
                for (j = mnp.start; j <= mnp.end; ++j) {
                    System.out.print(s.tokens.get(j) + " ");
                }
                System.out.println();
            }
            System.out.println("\nVP chunks after merging and cleaning\n");
            for (i2 = 0; i2 < s.chunksVP.size(); ++i2) {
                mnp = s.chunksVP.get(i2);
                for (j = mnp.start; j <= mnp.end; ++j) {
                    System.out.print(s.tokens.get(j) + " ");
                }
                System.out.println();
            }
            System.out.println("\nEND DEBUG NP, VP list\n");
        }
        for (e1 = 0; e1 < s.chunksNP.size(); ++e1) {
            Tuple np = s.chunksNP.get(e1);
            if (!np.isBase) continue;
            ArrayList<Token> l1 = new ArrayList<Token>();
            for (i = np.start; i <= np.end; ++i) {
                token = new Token(s.tokens.get(i), i + 1);
                l1.add(token);
            }
            if (verbosity > 2) {
                System.out.println("DEBUG NP = " + l1);
            }
            this.NP.add(l1);
        }
        for (e1 = 0; e1 < s.chunksVP.size(); ++e1) {
            Tuple vp = s.chunksVP.get(e1);
            if (!vp.isBase) continue;
            ArrayList<Token> l1 = new ArrayList<Token>();
            for (i = vp.start; i <= vp.end; ++i) {
                token = new Token(s.tokens.get(i), i + 1);
                l1.add(token);
            }
            if (verbosity > 2) {
                System.out.println("DEBUG VP = " + l1);
            }
            this.VP.add(l1);
        }
        for (e1 = 0; e1 < s.chunksNP.size(); ++e1) {
            Tuple np1 = s.chunksNP.get(e1);
            if (np1.start == MAX || np1.start == np1.end && s.tags.get(np1.start).equals("CD")) continue;
            for (int r = 0; r < s.chunksVP.size(); ++r) {
                Tuple vp = s.chunksVP.get(r);
                for (int e2 = 0; e2 < s.chunksNP.size(); ++e2) {
                    Tuple np2 = s.chunksNP.get(e2);
                    if (np2.start == MAX) {
                        if (vp.start <= np1.end) continue;
                        Relation rel = RelationGenerator.CreateRelation(np1, vp, np2, s);
                        rel.setFeatures(RelationGenerator.getFeatures(s, e1, e2, r, rel));
                        relations.add(rel);
                        continue;
                    }
                    if (s.tags.get(np2.end).equals("PRP")) continue;
                    if (vp.start > np1.end && vp.end < np2.start && np1.start != np2.start) {
                        Relation rel = RelationGenerator.CreateRelation(np1, vp, np2, s);
                        rel.setFeatures(RelationGenerator.getFeatures(s, e1, e2, r, rel));
                        relations.add(rel);
                        continue;
                    }
                    if (vp.start <= np1.end || vp.start <= np2.end || np1.start == np2.start || !s.tags.get(0).equals("IN") && (!s.tags.get(0).contains("NN") || !s.tags.get(1).equals("CD"))) continue;
                    boolean new_rel = true;
                    block11: for (int i3 = np1.start; i3 <= np1.end; ++i3) {
                        for (int j = np2.start; j <= np2.end; ++j) {
                            String np2_j;
                            String np1_i = s.tokens.get(i3);
                            if (!np1_i.equals(np2_j = s.tokens.get(j))) continue;
                            new_rel = false;
                            continue block11;
                        }
                    }
                    if (!new_rel) continue;
                    Relation rel = RelationGenerator.CreateRelation(np2, vp, np1, s);
                    rel.setFeatures(RelationGenerator.getFeatures(s, e1, e2, r, rel));
                    relations.add(rel);
                }
            }
        }
        return relations;
    }

    static Relation CreateRelation(Tuple np1, Tuple vp, Tuple np2, Sentence s) {
        Token token;
        ArrayList<Token> l1 = new ArrayList<Token>();
        if (!np1.isNull) {
            for (int i = np1.start; i <= np1.end; ++i) {
                Token token2 = new Token(s.tokens.get(i), i + 1);
                l1.add(token2);
            }
        }
        ArrayList<Token> l2 = new ArrayList<Token>();
        for (int i = vp.start; i <= vp.end; ++i) {
            token = new Token(s.tokens.get(i), i + 1);
            l2.add(token);
        }
        ArrayList<Token> l3 = new ArrayList<Token>();
        if (np2.start != MAX) {
            if (np2.start > 0 && !s.tags.get(np2.start).equals("IN") && !s.tags.get(np2.start).equals("TO")) {
                int pos = np2.start - 1;
                String tag = s.tags.get(pos);
                int last_vp_pos = vp.end;
                if (tag.equals("IN") && last_vp_pos != pos) {
                    Token token3 = new Token(s.tokens.get(pos), pos + 1);
                    l2.add(token3);
                }
            }
            for (int i = np2.start; i <= np2.end; ++i) {
                Token token4 = new Token(s.tokens.get(i), i + 1);
                l3.add(token4);
            }
        } else {
            token = new Token("", MAX);
            l3.add(token);
        }
        return new Relation(l1, l2, l3);
    }

    static ArrayList<String> getFeatures(Sentence s, int e1, int e2, int r, Relation rel) {
        int j;
        ArrayList<String> feat = new ArrayList<String>();
        int np1count = 0;
        int np2count = 0;
        int vp1count = 0;
        int vp2count = 0;
        int e1nnpcount = 0;
        int e2nnpcount = 0;
        String rPOS = "";
        int e1start = s.chunksNP.get((int)e1).start;
        int e2start = s.chunksNP.get((int)e2).start;
        int rstart = s.chunksVP.get((int)r).start;
        int e1end = s.chunksNP.get((int)e1).end;
        int e2end = s.chunksNP.get((int)e2).end;
        int e1length = rel._e1.length;
        int e2length = rel._e2.length;
        int rlength = rel._r.length;
        if (e2start != MAX) {
            for (int i = e1 + 1; i < e2; ++i) {
                if (s.chunksNP.get((int)i).start < rstart) {
                    ++np1count;
                    continue;
                }
                ++np2count;
            }
        }
        for (j = 0; j < s.chunksVP.size(); ++j) {
            int vpstart = s.chunksVP.get((int)j).start;
            if (e1start < vpstart && vpstart < rstart) {
                ++vp1count;
            }
            if (e2start != MAX && rstart < vpstart && vpstart < e2start) {
                ++vp2count;
            }
            if (vpstart > e2start) break;
        }
        for (j = e1start; j <= e1end; ++j) {
            if (!s.tags.get(j).equals("NNP")) continue;
            ++e1nnpcount;
        }
        if (e2start != MAX) {
            for (j = e2start; j <= e2end; ++j) {
                if (!s.tags.get(j).equals("NNP")) continue;
                ++e2nnpcount;
            }
        }
        feat.add(Integer.toString(np1count));
        feat.add(Integer.toString(np2count));
        feat.add(Integer.toString(vp1count));
        feat.add(Integer.toString(vp2count));
        feat.add(Integer.toString(e1length));
        feat.add(Integer.toString(e2length));
        feat.add(Integer.toString(rlength));
        feat.add(Integer.toString(e1nnpcount));
        feat.add(Integer.toString(e2nnpcount));
        return feat;
    }

    private static String getPOSsequence(Sentence s, int start, int end) {
        String POS = "";
        for (int j = start; j < end; ++j) {
            POS = POS + s.tags.get(j) + " ";
        }
        POS = POS + s.tags.get(end);
        return POS;
    }

    private static class Sentence {
        ArrayList<String> tokens = new ArrayList();
        ArrayList<String> tags = new ArrayList();
        ArrayList<Tuple> chunksNP = new ArrayList();
        ArrayList<Tuple> chunksVP = new ArrayList();
        ArrayList<Tuple> consec_chunksNP = new ArrayList();
        ArrayList<Tuple> consec_chunksVP = new ArrayList();
        int verbosity = 0;

        Sentence(String sentence, int debug) {
            this.verbosity = debug;
            String s_clean = sentence.replaceAll("\\[", " \\[ ");
            s_clean = s_clean.replaceAll("\\]", " \\] ");
            if (this.verbosity > 5) {
                System.out.println("CHUNKed = " + s_clean);
            }
            String[] toks = sentence.split(" ");
            for (int k = 0; k < toks.length; ++k) {
                if (!toks[k].equals("/")) continue;
                toks[k] = "/CC";
            }
            this.getTokesAndTag(toks);
            this.chunksNP = this.getBaseNP(s_clean);
            this.chunksVP = this.getBaseVP(s_clean);
            this.mergeConsecutiveVP();
        }

        private void getTokesAndTag(String[] toks) {
            for (int i = 0; i < toks.length; ++i) {
                if (toks[i].equals("[") || toks[i].equals("]") || toks[i].isEmpty()) continue;
                String tok = toks[i];
                String[] data = new String[2];
                for (int j = tok.length() - 1; j > -1; --j) {
                    if (tok.charAt(j) != '/') continue;
                    data[0] = tok.substring(0, j);
                    data[1] = tok.substring(j + 1);
                }
                this.tokens.add(data[0]);
                this.tags.add(data[1]);
            }
        }

        private ArrayList<Tuple> getBaseVP(String s) {
            int i;
            String[] st = s.split(" ");
            ArrayList<String> sClean = new ArrayList<String>();
            for (int i2 = 0; i2 < st.length; ++i2) {
                if (st[i2].isEmpty()) continue;
                sClean.add(st[i2]);
            }
            ArrayList<Tuple> chunk = new ArrayList<Tuple>();
            Tuple vp = null;
            int bracket = 0;
            boolean inNP = false;
            boolean inVP = false;
            String vpstring = "";
            for (i = 0; i < sClean.size(); ++i) {
                if (((String)sClean.get(i)).equals("[")) {
                    ++bracket;
                    inNP = true;
                    inVP = false;
                    if (i <= 0 || ((String)sClean.get(i - 1)).equals("]")) continue;
                    vp.end = i - bracket;
                    if (vpstring.contains("/VB")) {
                        int k;
                        int vp_skipforward = 0;
                        int vp_skipbackward = 0;
                        int vpcore = 0;
                        String[] vps = vpstring.split(" ");
                        for (k = 0; k < vps.length; ++k) {
                            if (!vps[k].contains("/VB")) continue;
                            vpcore = k;
                        }
                        for (k = 0; k < vpcore; ++k) {
                            if (vps[k].contains("/,")) {
                                vp_skipforward = k + 1;
                                continue;
                            }
                            if (!vps[k].contains("/CC") && !vps[k].contains("/WDT") && !vps[k].contains("/WP") && !vps[k].contains("/WP$") && !vps[k].contains("/WDT")) continue;
                            ++vp_skipforward;
                        }
                        for (k = vps.length - 1; k > vpcore; --k) {
                            if (vps[k].contains("/,")) {
                                vp_skipbackward = vps.length - k;
                                continue;
                            }
                            if (!vps[k].contains("/CC") && !vps[k].contains("/WDT") && !vps[k].contains("/WP") && !vps[k].contains("/WP$") && !vps[k].contains("/WDT")) continue;
                            ++vp_skipbackward;
                        }
                        vp.start += vp_skipforward;
                        vp.end -= vp_skipbackward;
                        chunk.add(vp);
                    }
                    inVP = false;
                    vpstring = "";
                    continue;
                }
                if (((String)sClean.get(i)).equals("]")) {
                    ++bracket;
                    inNP = false;
                    vpstring = "";
                    continue;
                }
                if (inNP) continue;
                if (!inVP) {
                    vp = new Tuple();
                    vp.start = i - bracket;
                    vp.isBase = true;
                    inVP = true;
                }
                vpstring = vpstring + (String)sClean.get(i) + " ";
            }
            if (this.verbosity > 5) {
                System.out.println("\nBase VPs from chunked sentence");
                for (i = 0; i < this.chunksVP.size(); ++i) {
                    Tuple mnp = this.chunksVP.get(i);
                    for (int j = mnp.start; j <= mnp.end; ++j) {
                        System.out.print(this.tokens.get(j) + " ");
                    }
                    System.out.println();
                }
            }
            return chunk;
        }

        private ArrayList<Tuple> getBaseNP(String s) {
            int i;
            String[] st = s.split(" ");
            ArrayList<String> sClean = new ArrayList<String>();
            for (int i2 = 0; i2 < st.length; ++i2) {
                if (st[i2].isEmpty()) continue;
                sClean.add(st[i2]);
            }
            ArrayList<Tuple> chunk = new ArrayList<Tuple>();
            Tuple np = null;
            int bracket = 0;
            for (i = 0; i < sClean.size(); ++i) {
                if (((String)sClean.get(i)).equals("[")) {
                    np = new Tuple();
                    np.start = i - bracket;
                    np.isBase = true;
                    ++bracket;
                    continue;
                }
                if (!((String)sClean.get(i)).equals("]")) continue;
                np.end = i - ++bracket;
                np.isBase = true;
                chunk.add(np);
            }
            if (this.verbosity > 5) {
                System.out.println("\nBase NPs from chunked sentence");
                for (i = 0; i < chunk.size(); ++i) {
                    Tuple mnp = chunk.get(i);
                    for (int j = mnp.start; j <= mnp.end; ++j) {
                        System.out.print(this.tokens.get(j) + " ");
                    }
                    System.out.println();
                }
            }
            return chunk;
        }

        private void mergeConsecutiveVP() {
            int i;
            for (i = 0; i < this.chunksVP.size(); ++i) {
                Tuple vp1 = this.chunksVP.get(i);
                int c_start = vp1.start;
                int c_end = vp1.end;
                Tuple new_vp = null;
                for (int j = 0; j < this.chunksVP.size(); ++j) {
                    Tuple vp2 = this.chunksVP.get(j);
                    if (new_vp != null) {
                        c_start = new_vp.start;
                        c_end = new_vp.end;
                    }
                    boolean no_noun = true;
                    int k = vp1.end + 1;
                    if (k >= vp2.start) continue;
                    while (k < vp2.start) {
                        if (this.tags.get(k).startsWith("NN")) {
                            no_noun = false;
                            break;
                        }
                        ++k;
                    }
                    if (!no_noun) continue;
                    new_vp = new Tuple();
                    new_vp.start = c_start;
                    new_vp.end = vp2.end;
                    new_vp.isBase = false;
                    this.consec_chunksVP.add(new_vp);
                }
            }
            this.chunksVP.addAll(this.consec_chunksVP);
            if (this.verbosity > 5) {
                System.out.println("\nDEBUG chunks VP \n");
                for (i = 0; i < this.chunksVP.size(); ++i) {
                    Tuple mnp = this.chunksVP.get(i);
                    for (int j = mnp.start; j <= mnp.end; ++j) {
                        System.out.print(this.tokens.get(j) + " ");
                    }
                    System.out.println();
                }
                System.out.println("\nEND DEBUG VP\n");
            }
        }

        private ArrayList<Tuple> removeEmbeddedNP(ArrayList<Tuple> consecChunksNP) {
            int i;
            ArrayList<Tuple> np = consecChunksNP;
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            HashMap<Integer, Integer> seen = new HashMap<Integer, Integer>();
            for (i = 0; i < np.size() - 1; ++i) {
                for (int j = i + 1; j < np.size(); ++j) {
                    Tuple np1 = np.get(i);
                    Tuple np2 = np.get(j);
                    if (np1.start == np2.start) {
                        if (np1.end <= np2.end) {
                            if (seen.containsKey(i)) continue;
                            toRemove.add(i);
                            seen.put(i, 1);
                            continue;
                        }
                        if (seen.containsKey(j)) continue;
                        toRemove.add(j);
                        seen.put(j, 1);
                        continue;
                    }
                    if (np1.end != np2.end) continue;
                    if (np1.start <= np2.start) {
                        if (seen.containsKey(j)) continue;
                        toRemove.add(j);
                        seen.put(j, 1);
                        continue;
                    }
                    if (seen.containsKey(i)) continue;
                    toRemove.add(i);
                    seen.put(i, 1);
                }
            }
            Collections.sort(toRemove);
            for (i = toRemove.size() - 1; i >= 0; --i) {
                np.remove((Integer)toRemove.get(i));
            }
            return np;
        }

        void tuneChunks() {
            Tuple new_np;
            int i;
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            int lastRemoved = -1;
            this.mergeConsecutiveNP();
            ArrayList<Tuple> new_chunksNP = new ArrayList<Tuple>();
            for (i = 0; i < this.chunksNP.size(); ++i) {
                String tag;
                int new_end;
                int new_end2;
                int new_start;
                Tuple np = this.chunksNP.get(i);
                if (np.start > 3 && np.end < this.tokens.size() - 2) {
                    new_start = np.start - 3;
                    new_end2 = np.end + 2;
                    if (this.tags.get(new_start).equals("RB") && this.tags.get(new_start + 1).equals("JJ")) {
                        this.chunksNP.get((int)i).start = new_start + 1;
                    }
                    if (this.tags.get(new_end2).contains("VB") && this.tags.get(new_end2 - 1).equals("TO")) {
                        this.chunksNP.get((int)i).end = new_end2;
                    }
                }
                if (np.end < this.tokens.size() - 2 && this.tags.get(new_end = np.end + 2).contains("JJ") && this.tags.get(new_end - 1).equals("RBR")) {
                    this.chunksNP.get((int)i).end = new_end;
                }
                if (np.start > 3 && np.end < this.tokens.size() - 2) {
                    new_start = np.start - 2;
                    new_end2 = np.end;
                    if (this.tags.get(new_start).equals("JJ") && this.tags.get(new_start + 1).equals("TO")) {
                        this.chunksNP.get((int)i).start = new_start;
                    }
                }
                if (np.start > 1 && this.tags.get(np.start - 1).equals("IN") && this.tags.get(np.start).equals("CD")) {
                    this.chunksNP.get((int)i).start = np.start - 1;
                }
                if ((np.start - 1 == 0 || np.start - 2 == 0) && this.tags.get(0).contains("VB")) {
                    this.chunksNP.get((int)i).start = 0;
                }
                new_np = new Tuple();
                if (np.start > 0) {
                    boolean isNew_np = true;
                    for (int k = 0; k <= np.start; ++k) {
                        if (!this.tags.get(k).contains("VB")) continue;
                        isNew_np = false;
                    }
                    if (isNew_np) {
                        new_np.start = 0;
                        new_np.end = this.chunksNP.get((int)i).end;
                        new_np.isBase = false;
                        new_chunksNP.add(new_np);
                    }
                }
                if (np.start == np.end && ((tag = this.tags.get(np.start)).equals("WDT") || tag.equals("DT") || tag.equals("IN") || tag.equals("WP"))) {
                    toRemove.add(new Integer(i));
                    lastRemoved = i;
                }
                if (!this.tokens.get(np.start).equals("'s") && !this.tokens.get(np.start).equals("'") || !this.tags.get(np.start).equals("POS")) continue;
                ++np.start;
                if (i != 0 && this.chunksNP.get((int)(i - 1)).end == np.start - 2 && lastRemoved != i - 1) {
                    toRemove.add(new Integer(i - 1));
                    lastRemoved = i - 1;
                }
                if (np.start <= np.end) continue;
                toRemove.add(new Integer(i));
                lastRemoved = i;
            }
            for (i = toRemove.size() - 1; i >= 0; --i) {
                this.chunksNP.remove((Integer)toRemove.get(i));
            }
            this.consec_chunksNP = this.removeEmbeddedNP(this.consec_chunksNP);
            new_chunksNP.addAll(this.consec_chunksNP);
            new_chunksNP = this.removeEmbeddedNP(new_chunksNP);
            this.chunksNP.addAll(new_chunksNP);
            for (i = this.chunksVP.size() - 1; i >= 0; --i) {
                Tuple vp = this.chunksVP.get(i);
                if (this.tags.get(vp.start).contains("VB") && vp.start != 0 && this.tags.get(vp.start - 1).equals("TO")) {
                    this.chunksVP.remove(i);
                }
                if (vp.start > 2 && !this.tags.get(vp.end + 1).contains("VB") && this.tags.get(vp.start).equals("VBG") && this.tags.get(vp.start - 2).contains("NN") && this.tags.get(vp.start - 1).equals(",")) {
                    this.chunksVP.remove(i);
                }
                if (vp.start > 2 && vp.end + 2 < this.tokens.size() && this.tags.get(vp.end + 2).contains("NN") && this.tags.get(vp.end + 1).contains("IN") && this.tags.get(vp.start).equals("VBG") && this.tags.get(vp.start - 2).contains("NN") && this.tags.get(vp.start - 1).equals("IN")) {
                    this.chunksVP.remove(i);
                }
                if (vp.start > 1 && !this.tags.get(vp.start + 1).contains("VB") && this.tags.get(vp.start).equals("VBG") && this.tags.get(vp.start - 1).contains("NN")) {
                    this.chunksVP.remove(i);
                }
                if (vp.end > 1 && vp.end < this.tokens.size() - 2 && this.tags.get(vp.end + 1).equals("JJ") && !this.tags.get(vp.end + 2).contains("NN")) {
                    new_np = new Tuple();
                    new_np.start = vp.end + 1;
                    new_np.end = vp.end + 1;
                    new_np.isBase = false;
                    this.chunksNP.add(new_np);
                }
                if (vp.end <= 1 || vp.end >= this.tokens.size() - 1 || !this.tags.get(vp.end + 1).equals("RP")) continue;
                Tuple new_vp = new Tuple();
                new_vp.start = vp.start;
                new_vp.end = vp.end + 1;
                new_vp.isBase = false;
                this.chunksVP.add(new_vp);
            }
        }

        private void mergeConsecutiveNP() {
            for (int i = 0; i < this.chunksNP.size(); ++i) {
                Tuple np1 = this.chunksNP.get(i);
                int c_start = np1.start;
                int c_end = np1.end;
                Tuple new_np = null;
                for (int j = 0; j < this.chunksNP.size(); ++j) {
                    Tuple np2 = this.chunksNP.get(j);
                    if (new_np != null) {
                        c_start = new_np.start;
                        c_end = new_np.end;
                    }
                    if (!(c_end == np2.start - 1 || c_end == np2.start - 2 && (this.tags.get(np2.start - 1).equals("IN") || this.tags.get(np2.start - 1).equals("TO")) || c_end == np2.start - 3 && this.tags.get(np2.start - 2).equals("TO") && this.tags.get(np2.start - 1).contains("VB") || c_end == np2.start - 3 && this.tags.get(np2.start - 2).equals("JJ") && (this.tags.get(np2.start - 1).equals("IN") || this.tags.get(np2.start - 1).equals("TO")) || c_end == np2.start - 3 && this.tags.get(np2.start - 2).equals("IN") && this.tags.get(np2.start - 1).equals("IN") || c_end == np2.start - 2 && (this.tags.get(np2.start - 1).equals("VBG") || this.tags.get(np2.end - 1).equals("VBG")) || c_end == np2.start - 3 && this.tags.get(np2.start - 2).equals(",") && (this.tags.get(np2.start - 1).equals("VBG") || this.tags.get(np2.end - 1).equals("VBG")) || c_end == np2.start - 3 && this.tags.get(np2.start - 2).equals(",") && (this.tags.get(np2.start - 1).equals("IN") || this.tags.get(np2.end - 1).equals("IN")) || c_end == np2.start - 3 && this.tags.get(np2.start - 2).equals("IN") && (this.tags.get(np2.start - 1).equals("VBG") || this.tags.get(np2.end - 1).equals("VBG")) || c_end == np2.start - 4 && this.tags.get(np2.start - 3).equals("IN") && this.tags.get(np2.start - 1).equals("IN") && (this.tags.get(np2.start - 2).equals("VBG") || this.tags.get(np2.end - 2).equals("VBG")) || c_end == np2.start - 2 && (this.tags.get(np2.start - 1).equals("CC") || this.tags.get(np2.end - 1).equals("CC")) && !this.tags.get(np2.end + 1).contains("VB")) && (c_end != np2.start - 2 || !this.tags.get(np2.start - 1).equals(",") && !this.tags.get(np2.end - 1).equals(",") || this.tags.get(np2.start).equals("WP") || this.tags.get(np2.start).equals("WDT") || this.tags.get(np2.start).equals("WP$") || this.tags.get(np2.end + 1).contains("VB"))) continue;
                    new_np = new Tuple();
                    new_np.start = c_start;
                    new_np.end = np2.end;
                    new_np.isBase = false;
                    this.consec_chunksNP.add(new_np);
                }
            }
        }
    }
}

