/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.DataFileWriter;
import edu.cmu.cs.lti.relationFilter.Features;
import edu.cmu.cs.lti.relationFilter.Filter;
import edu.cmu.cs.lti.relationFilter.Hypothesis;
import edu.cmu.cs.lti.relationFilter.InputDataReader;
import edu.cmu.cs.lti.relationFilter.Loss;
import edu.cmu.cs.lti.relationFilter.NgramLoss;
import edu.cmu.cs.lti.relationFilter.Relation;
import edu.cmu.cs.lti.relationFilter.SentenceData;
import edu.cmu.cs.lti.relationFilter.SentenceRawData;
import edu.cmu.cs.lti.relationFilter.Token;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RelationFilter {
    InputDataReader _inData;
    InputDataReader _refData;
    DataFileWriter _outData;
    Properties _props;
    Filter fS;
    int nbest_size = 100;
    int max_hyp_stack_size = 200;
    int max_subj_length = 9;
    int verbosity = 0;
    String prune_strategy = "WordCoverage";
    ArrayList<Double> weights = new ArrayList();
    String train_ref_file;
    int train_iterations;
    int mOracle = 5;
    Double C = 0.1;
    long FeatureSize;
    String InitWeightsRamdom = "yes";
    String LossFunction = "Ngram";
    Loss loss = null;
    public ArrayList<String> hyp_features;
    public static boolean generateOnly = true;

    public RelationFilter(String inFile, String outFile, String propsFile) {
        this._inData = new InputDataReader(inFile);
        this._outData = new DataFileWriter(outFile);
        this._props = new Properties();
        try {
            this._props.load(new FileInputStream(propsFile));
            if (this._props.getProperty("Verbosity") != null) {
                this.verbosity = Integer.parseInt(this._props.getProperty("Verbosity"));
                if (this.verbosity > 0) {
                    System.out.format("Debugging level = %d%n", this.verbosity);
                }
            }
            if (this._props.getProperty("NBest") != null) {
                this.nbest_size = Integer.parseInt(this._props.getProperty("NBest"));
                if (this.verbosity > 0) {
                    System.out.format("N-Best simplified candidate = %d%n", this.nbest_size);
                }
            }
            if (this._props.getProperty("MaxHypothesisStackSize") != null) {
                this.max_hyp_stack_size = Integer.parseInt(this._props.getProperty("MaxHypothesisStackSize"));
                if (this.verbosity > 0) {
                    System.out.format("Max number of elements in stack = %d%n", this.max_hyp_stack_size);
                }
            }
            if (this._props.getProperty("MaxSubjectLength") != null) {
                this.max_subj_length = Integer.parseInt(this._props.getProperty("MaxSubjectLength"));
                if (this.verbosity > 0) {
                    System.out.format("Max number of word in a subject = %d%n", this.max_subj_length);
                }
            }
            if (this._props.getProperty("DecoderWeights") != null) {
                Object[] w = this._props.getProperty("DecoderWeights").split(" ");
                for (int i = 0; i < w.length; ++i) {
                    this.weights.add(Double.parseDouble(w[i]));
                }
                if (this.verbosity > 0) {
                    System.out.println("Decoder weights = " + Arrays.toString(w));
                }
            }
            if (this._props.getProperty("PrunningStrategy") != null) {
                this.prune_strategy = this._props.getProperty("PrunningStrategy");
                if (!this.prune_strategy.equalsIgnoreCase("ModelScore") && !this.prune_strategy.equalsIgnoreCase("WordCoverageModelScore")) {
                    this.prune_strategy = "WordCoverage";
                }
                if (this.verbosity > 0) {
                    System.out.println("Prunning strategy       = " + this.prune_strategy);
                }
            }
        }
        catch (IOException e) {
            System.err.println("problems reading filtering properties file");
            System.exit(-1);
        }
        this.fS = new Filter(this.verbosity);
    }

    public void train() {
        this.getTrainingParams();
        this._refData = new InputDataReader(this.train_ref_file);
        ArrayList<ArrayList<String>> reference = new ArrayList<ArrayList<String>>();
        String current = this._refData.NextRefSentence();
        while (current != null) {
            ArrayList<String> sents = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(current, "\n");
            while (tokens.hasMoreTokens()) {
                sents.add((String)tokens.nextElement());
            }
            reference.add(sents);
            current = this._refData.NextRefSentence();
        }
        if (this.verbosity > 3) {
            int n = reference.size();
            for (int i = 0; i < n; ++i) {
                System.out.print(reference.get(i) + "\n\n");
            }
        }
        ArrayList<SentenceData> traindata = new ArrayList<SentenceData>();
        SentenceRawData currentRawSentence = this._inData.NextSentence();
        while (currentRawSentence != null) {
            SentenceData currSent = new SentenceData(currentRawSentence, this.verbosity);
            traindata.add(currSent);
            currSent = this.fS.addSoftFilterFeature(currSent);
            if (this.verbosity > 0) {
                this._outData.write(currSent.toString());
            }
            currentRawSentence = this._inData.NextSentence();
        }
        if (this.verbosity > 3) {
            int n = traindata.size();
            for (int i = 0; i < n; ++i) {
                System.out.print(((SentenceData)traindata.get(i)).getRawSentenceString() + "\n\n");
            }
        }
        if (reference.size() != traindata.size()) {
            System.out.println("Missmatch!!! training data = " + traindata.size() + " reference = " + reference.size());
            System.exit(0);
        }
        if (this.InitWeightsRamdom.equals("yes")) {
            System.out.print("Random weights          = ");
            this.weights = new ArrayList();
            int i = 0;
            while ((long)i < this.FeatureSize) {
                double val = Math.random();
                this.weights.add(this.FourDecimal(val));
                System.out.format("%.4f ", val);
                ++i;
            }
            System.out.println();
        }
        this.weights = this.MIRA(this.train_iterations, traindata, reference, this.weights, this.mOracle);
    }

    private void getTrainingParams() {
        if (this._props.getProperty("TrainingIterations") != null) {
            this.train_iterations = Integer.parseInt(this._props.getProperty("TrainingIterations"));
            System.out.println("Training iteration      = " + this.train_iterations);
        }
        if (this._props.getProperty("mOracle") != null) {
            this.mOracle = Integer.parseInt(this._props.getProperty("mOracle"));
            System.out.println("Training with m-oracle  = " + this.mOracle);
        }
        if (this._props.getProperty("InitWeightsRandom") != null) {
            this.InitWeightsRamdom = this._props.getProperty("InitWeightsRandom");
            if (this.InitWeightsRamdom.equals("yes")) {
                System.out.println("Weights will be initialized ramdomly. Remember to specify the number of features.");
            }
        }
        if (this._props.getProperty("FeatureSize") != null) {
            this.FeatureSize = Long.parseLong(this._props.getProperty("FeatureSize"));
            System.out.println("The number of features  = " + this.FeatureSize);
        }
        if (this._props.getProperty("LossFunction") != null) {
            this.LossFunction = this._props.getProperty("LossFunction");
            if (this.LossFunction.equals("Ngram")) {
                this.loss = new NgramLoss();
            }
            System.out.println("Training loss function  = " + this.LossFunction);
        }
        if (this._props.getProperty("C") != null) {
            this.C = Double.parseDouble(this._props.getProperty("C"));
            System.out.println("Training constant C     = " + this.C);
        }
        if (this._props.getProperty("TrainingReferenceFile") != null) {
            this.train_ref_file = this._props.getProperty("TrainingReferenceFile");
            System.out.println("Reference file          = " + this.train_ref_file);
        }
    }

    private ArrayList<Double> MIRA(int N, ArrayList<SentenceData> traindata, ArrayList<ArrayList<String>> reference, ArrayList<Double> w0, int m) {
        int j;
        ArrayList<String> report = new ArrayList<String>();
        ArrayList<Object> best_weights = new ArrayList();
        double best_averageLoss = -9999999.0;
        ArrayList<ArrayList<Double>> w = new ArrayList<ArrayList<Double>>();
        w.add(w0);
        int i = 0;
        int skip = 0;
        for (int n = 1; n <= N; ++n) {
            skip = 0;
            System.out.println("\nIteration " + n + ":\n-------------\nEstimating current loss ...\n");
            ArrayList<Double> normalized_w = this.Normalize_Weight_Vector(w);
            double averageLoss = this.ComputeAverageLoss(traindata, reference, normalized_w);
            System.out.format("Average loss before iteration %d: %.4f when using weights = %s%n", n, averageLoss, normalized_w.toString());
            String results = "Average Loss = " + this.FourDecimal(averageLoss) + " Weigths = " + normalized_w.toString();
            report.add(results);
            if (averageLoss > best_averageLoss) {
                best_averageLoss = averageLoss;
                best_weights = normalized_w;
            }
            int T = traindata.size();
            for (int t = 0; t < T; ++t) {
                ArrayList<Hypothesis> H = this.get_K_Best(traindata.get(t), w.get(i), this.nbest_size, this.verbosity);
                if (!H.isEmpty()) {
                    ArrayList<Hypothesis> O = this.get_M_Oracle(H, reference.get(t), m);
                    ArrayList<Double> w_new = this.UpdateWeight(w.get(i), H, O, reference.get(t));
                    ArrayList<Hypothesis> H_new = this.get_K_Best(traindata.get(t), w_new, 1, 0);
                    double new_loss = this.loss.calculate(reference.get(t), H_new.get(0));
                    System.out.println("After updating weights = " + w_new);
                    System.out.format("Updated Best: loss = %.4f ; score = %.5f : %s%n", new_loss, H_new.get((int)0)._score, H_new.get(0).toOneString());
                    w.add(w_new);
                    ++i;
                    continue;
                }
                ++skip;
                System.out.println("This training instance is quite simple or hard! The trainer will skip it.");
            }
        }
        ArrayList<Double> last_weights = this.Normalize_Weight_Vector(w);
        double averageLoss = this.ComputeAverageLoss(traindata, reference, last_weights);
        String results = "Average Loss = " + this.FourDecimal(averageLoss) + " Weights = " + last_weights.toString();
        report.add(results);
        if (averageLoss > best_averageLoss) {
            best_averageLoss = averageLoss;
            best_weights = last_weights;
        }
        System.out.println("\n-----------\nTraining report\n");
        for (j = 0; j < report.size(); ++j) {
            System.out.println("Iteration " + j + ": " + (String)report.get(j));
        }
        System.out.println("\nNumber of updated weights vectors = " + w.size() + " ; Skip instances = " + skip);
        System.out.print("Best weights = ");
        for (j = 0; j < best_weights.size(); ++j) {
            System.out.print(((Double)best_weights.get(j)).toString() + " ");
        }
        System.out.format("\nAverage loss with optimized weights: %.4f%n", best_averageLoss);
        return best_weights;
    }

    private ArrayList<Double> Normalize_Weight_Vector(ArrayList<ArrayList<Double>> w) {
        int j;
        ArrayList<Double> final_weights = new ArrayList<Double>();
        for (j = 0; j < w.get(0).size(); ++j) {
            final_weights.add(0.0);
        }
        for (j = 0; j < w.size(); ++j) {
            for (int k = 0; k < w.get(j).size(); ++k) {
                double val = w.get(j).get(k);
                if (final_weights.get(k) == 0.0) {
                    final_weights.set(k, val);
                    continue;
                }
                final_weights.set(k, final_weights.get(k) + val);
            }
        }
        for (int k = 0; k < final_weights.size(); ++k) {
            double normalize = final_weights.get(k) / (double)w.size();
            normalize = this.FourDecimal(normalize);
            final_weights.set(k, normalize);
        }
        return final_weights;
    }

    private double ComputeAverageLoss(ArrayList<SentenceData> traindata, ArrayList<ArrayList<String>> reference, ArrayList<Double> w) {
        double avg = 0.0;
        this.fS.setVerbosity(0);
        int T = traindata.size();
        for (int t = 0; t < T; ++t) {
            ArrayList<Hypothesis> H = this.get_K_Best(traindata.get(t), w, 1, 0);
            if (H.isEmpty()) continue;
            avg += this.loss.calculate(reference.get(t), H.get(0));
        }
        return avg / (double)T;
    }

    private ArrayList<Double> UpdateWeight(ArrayList<Double> wi, ArrayList<Hypothesis> H, ArrayList<Hypothesis> O, ArrayList<String> ref) {
        ArrayList<Double> update = new ArrayList<Double>();
        for (int i = 0; i < wi.size(); ++i) {
            update.add(0.0);
        }
        for (int o = 0; o < O.size(); ++o) {
            for (int h = 0; h < H.size(); ++h) {
                int i;
                ArrayList<Double> diff = this.FeatureDiff(O.get((int)o)._hypFeatures, H.get((int)h)._hypFeatures);
                double alpha = this.getAlpha(O.get(o), H.get(h), ref);
                ArrayList<Double> alpha_time_diff = new ArrayList<Double>();
                for (i = 0; i < diff.size(); ++i) {
                    double val = alpha * diff.get(i);
                    alpha_time_diff.add(val);
                }
                for (i = 0; i < alpha_time_diff.size(); ++i) {
                    double newval = (Double)update.get(i) + (Double)alpha_time_diff.get(i);
                    update.set(i, newval);
                }
            }
        }
        int normalize = O.size() * H.size();
        ArrayList<Double> wnew = new ArrayList<Double>();
        for (int i = 0; i < wi.size(); ++i) {
            double val = wi.get(i) + (Double)update.get(i) / (double)normalize;
            val = this.FourDecimal(val);
            wnew.add(val);
        }
        return wnew;
    }

    private double getAlpha(Hypothesis o, Hypothesis h, ArrayList<String> ref) {
        double loss_O_Ref = this.loss.calculate(ref, o);
        double loss_H_Ref = this.loss.calculate(ref, h);
        double L = loss_O_Ref - loss_H_Ref;
        double scorediff = o._score - h._score;
        double nominator = L - scorediff;
        double denominator = 0.0;
        for (int i = 0; i < o.size(); ++i) {
            double val = o._hypFeatures.get(i).floatValue() - h._hypFeatures.get(i).floatValue();
            denominator += Math.pow(val, 2.0);
        }
        double delta = nominator / denominator;
        if (Double.isNaN(delta)) {
            delta = 0.0;
        }
        double alpha = Math.max(0.0, Math.min(this.C, delta));
        return alpha;
    }

    private ArrayList<Double> FeatureDiff(ArrayList<Float> o, ArrayList<Float> h) {
        ArrayList<Double> diff = new ArrayList<Double>();
        for (int i = 0; i < o.size(); ++i) {
            double val = o.get(i).floatValue() - h.get(i).floatValue();
            diff.add(i, val);
        }
        return diff;
    }

    private ArrayList<Hypothesis> get_M_Oracle(ArrayList<Hypothesis> h, ArrayList<String> ref, int m) {
        int i;
        ArrayList<Hypothesis> orac = new ArrayList<Hypothesis>();
        for (int i2 = 0; i2 < h.size(); ++i2) {
            h.get((int)i2)._loss = this.loss.calculate(ref, h.get(i2));
        }
        System.out.format("Original Best: loss = %.4f ; score = %.5f : %s%n", h.get((int)0)._loss, h.get((int)0)._score, h.get(0).toOneString());
        Collections.sort(h, new Comparator<Hypothesis>(){

            @Override
            public int compare(Hypothesis o1, Hypothesis o2) {
                if (o1._loss > o2._loss) {
                    return -1;
                }
                if (o1._loss < o2._loss) {
                    return 1;
                }
                return 0;
            }
        });
        Pattern p = Pattern.compile("\\p{Punct}");
        String reference = StringUtils.join(ref, " ").trim();
        Matcher match = p.matcher(reference);
        String ref_clean = match.replaceAll("");
        ref_clean = ref_clean.replaceAll("\\s+", " ");
        for (i = 0; i < h.size(); ++i) {
            String hypothesis = h.get(i).toOneNiceString(" ").trim();
            match = p.matcher(hypothesis);
            String hyp_clean = match.replaceAll("");
            if (!(hyp_clean = hyp_clean.replaceAll("\\s+", " ")).equalsIgnoreCase(ref_clean)) continue;
            if (this.verbosity > 0) {
                System.out.println("EXACT match!!! Found reference in k-best list, entry = " + i);
            }
            orac.add(h.get(i));
            --m;
        }
        m = Math.min(m, h.size());
        for (i = 0; i < m; ++i) {
            orac.add(h.get(i));
        }
        System.out.format("Oracle: rank = %d ; loss = %.4f ; score = %.5f : %s%n", ((Hypothesis)orac.get((int)0))._rank, h.get((int)0)._loss, h.get((int)0)._score, h.get(0).toOneString());
        return orac;
    }

    private ArrayList<Hypothesis> get_K_Best(SentenceData currSent, ArrayList<Double> w, int K, int debug) {
        if (debug > 0) {
            System.out.println("\nSENTENCE: " + currSent.getRawSentenceString() + "\n");
        }
        Object[] Obj = this.getObjTable(currSent);
        Map ObjTable = (Map)Obj[0];
        Relation r1 = (Relation)Obj[1];
        ArrayList hypoStack = new ArrayList();
        Stack<Object> h = new Stack();
        ArrayList<Hypothesis> hypothesis = new ArrayList<Hypothesis>();
        h = this.Init_HypStack_By_First_VP(ObjTable, r1);
        hypoStack.add(h);
        int max_simp_sent = currSent.VP.size() + 1;
        if (debug > 0) {
            System.out.format("Max number of simplified sentences per candidate = %d%n", max_simp_sent);
        }
        for (int i = 0; i < max_simp_sent - 1; ++i) {
            Hypothesis r;
            Stack<Hypothesis> expand_h = new Stack<Hypothesis>();
            Stack cp_expand_h = new Stack();
            while (!((Stack)hypoStack.get(i)).empty()) {
                r = (Hypothesis)((Stack)hypoStack.get(i)).pop();
                expand_h = this.Expanding_Hypothesis(r, ObjTable, expand_h, currSent);
            }
            expand_h = this.Prune_Hyp(expand_h, this.max_hyp_stack_size, this.prune_strategy, currSent, w);
            cp_expand_h = (Stack)expand_h.clone();
            hypoStack.add(i + 1, expand_h);
            while (!cp_expand_h.empty()) {
                r = (Hypothesis)cp_expand_h.pop();
                hypothesis.add(r);
            }
        }
        ArrayList<Hypothesis> unique_hypothesis = this.Unique_Hypothesis(hypothesis);
        unique_hypothesis = this.computeHypExpScore(unique_hypothesis, currSent, w);
        unique_hypothesis = this.Sort_Hyp(unique_hypothesis, currSent);
        if (debug > 0) {
            System.out.println("Hypothesis size = " + unique_hypothesis.size());
        }
        for (int i = 0; i < unique_hypothesis.size(); ++i) {
            unique_hypothesis.get((int)i)._rank = i;
        }
        ArrayList<Hypothesis> kbest = new ArrayList<Hypothesis>();
        int top = Math.min(this.nbest_size, unique_hypothesis.size());
        if (unique_hypothesis.size() == 0 && debug > 0) {
            System.out.println("No candidate has been found");
        }
        for (int i = 0; i < top; ++i) {
            kbest.add(unique_hypothesis.get(i));
        }
        return kbest;
    }

    private Stack<Hypothesis> Prune_Hyp(Stack<Hypothesis> expandH, int maxHypStackSize, String pruneStrategy, SentenceData currSent, ArrayList<Double> w) {
        Stack<Hypothesis> sorted_HypStack = new Stack();
        if (pruneStrategy.equalsIgnoreCase("WordCoverage")) {
            sorted_HypStack = this.Prune_Hyp_By_Word_Covered(expandH, maxHypStackSize);
        } else if (pruneStrategy.equalsIgnoreCase("ModelScore")) {
            sorted_HypStack = this.Prune_Hyp_By_Model_Score(expandH, maxHypStackSize, currSent, w);
        } else if (pruneStrategy.equalsIgnoreCase("WordCoverageModelScore")) {
            sorted_HypStack = this.Prune_Hyp_By_WCMS(expandH, maxHypStackSize, currSent, w);
        }
        return sorted_HypStack;
    }

    private Stack<Hypothesis> Prune_Hyp_By_WCMS(Stack<Hypothesis> HypStack, int maxHypStackSize, SentenceData currSent, ArrayList<Double> w) {
        Stack<Hypothesis> sorted_HypStack = new Stack<Hypothesis>();
        int maxHypSize = maxHypStackSize * 10;
        HypStack = this.Prune_Hyp_By_Word_Covered(HypStack, maxHypSize);
        ArrayList<Hypothesis> sorted_Hyp = new ArrayList();
        ArrayList<Hypothesis> hyp = new ArrayList<Hypothesis>();
        while (!HypStack.empty()) {
            Hypothesis r = HypStack.pop();
            hyp.add(r);
        }
        sorted_Hyp = this.computeHypExpScore(hyp, currSent, w);
        sorted_Hyp = this.Sort_Hyp(sorted_Hyp, currSent);
        int top = Math.min(maxHypStackSize, hyp.size());
        for (int i = 0; i < top; ++i) {
            sorted_HypStack.push(hyp.get(i));
        }
        return sorted_HypStack;
    }

    private Stack<Hypothesis> Prune_Hyp_By_Model_Score(Stack<Hypothesis> HypStack, int maxHypStackSize, SentenceData currSent, ArrayList<Double> w) {
        Stack<Hypothesis> sorted_HypStack = new Stack<Hypothesis>();
        ArrayList<Hypothesis> sorted_Hyp = new ArrayList();
        ArrayList<Hypothesis> hyp = new ArrayList<Hypothesis>();
        while (!HypStack.empty()) {
            Hypothesis r = HypStack.pop();
            hyp.add(r);
        }
        sorted_Hyp = this.computeHypExpScore(hyp, currSent, w);
        sorted_Hyp = this.Sort_Hyp(sorted_Hyp, currSent);
        int top = Math.min(maxHypStackSize, hyp.size());
        for (int i = 0; i < top; ++i) {
            sorted_HypStack.push(hyp.get(i));
        }
        return sorted_HypStack;
    }

    private ArrayList<Hypothesis> computeHypScore(ArrayList<Hypothesis> hypothesis, SentenceData sent, ArrayList<Double> w) {
        for (int j = 0; j < hypothesis.size(); ++j) {
            Hypothesis c = hypothesis.get(j);
            c._hypFeatures = this.getHypFeatures(c, sent);
            c._score = this.getHypScore(c._hypFeatures, w);
        }
        return hypothesis;
    }

    private ArrayList<Hypothesis> computeHypExpScore(ArrayList<Hypothesis> hypothesis, SentenceData sent, ArrayList<Double> w) {
        double rawscore;
        Hypothesis c;
        int j;
        double m = -9999999.0;
        double Z = 0.0;
        for (j = 0; j < hypothesis.size(); ++j) {
            c = hypothesis.get(j);
            c._hypFeatures = this.getHypFeatures(c, sent);
            rawscore = this.getHypScore(c._hypFeatures, w);
            if (!(m < rawscore)) continue;
            m = rawscore;
        }
        for (j = 0; j < hypothesis.size(); ++j) {
            c = hypothesis.get(j);
            rawscore = this.getHypScore(c._hypFeatures, w);
            Z += Math.exp(rawscore - m);
        }
        Z = m + Math.log(Z);
        for (j = 0; j < hypothesis.size(); ++j) {
            c = hypothesis.get(j);
            double cscore = m + Math.log(Math.exp(this.getHypScore(c._hypFeatures, w) - m));
            c._score = cscore - Z;
        }
        return hypothesis;
    }

    private Object[] getObjTable(SentenceData sent) {
        Object[] ObjTable = new Object[]{new HashMap(), new Relation()};
        int min_post = 99999;
        for (int j = 0; j < sent.relationCount(); ++j) {
            String np2;
            ArrayList<Relation> l;
            Relation r = sent.relationAt(j);
            if (!r._label) continue;
            if (min_post >= r._e2[r._e2.length - 1]._position) {
                ObjTable[1] = r;
                min_post = r._e2[r._e2.length - 1]._position;
            }
            if ((l = (ArrayList<Relation>)((Map)ObjTable[0]).get(np2 = r.e2toString())) == null) {
                l = new ArrayList<Relation>();
                ((Map)ObjTable[0]).put(np2, l);
            }
            l.add(r);
        }
        return ObjTable;
    }

    public void decode() {
        int sentencesProcessed = 0;
        SentenceRawData currentRawSentence = this._inData.NextSentence();
        while (currentRawSentence != null) {
            SentenceData currentSentence = new SentenceData(currentRawSentence, this.verbosity);
            currentSentence = this.fS.addSoftFilterFeature(currentSentence);
            if (this.verbosity > 0) {
                this._outData.write(currentSentence.toString());
            }
            ArrayList<Hypothesis> hypothesis = this.get_K_Best(currentSentence, this.weights, this.nbest_size, this.verbosity);
            this.printHypothesis(hypothesis, currentSentence, this.verbosity);
            currentRawSentence = this._inData.NextSentence();
            if (++sentencesProcessed % 100 != 0 || this.verbosity <= 0) continue;
            System.out.println("Processed: " + sentencesProcessed + " sentences");
        }
        this._outData.close();
    }

    private void printHypothesis(ArrayList<Hypothesis> unique_hypothesis, SentenceData sent, int debug) {
        int i;
        int top = Math.min(this.nbest_size, unique_hypothesis.size());
        if (unique_hypothesis.size() == 0) {
            System.out.println("We have no suggestion to simplify your sentence.\n");
        } else if (debug == 0) {
            for (i = 0; i < top; ++i) {
                String nice_output = unique_hypothesis.get(i).toOneNiceString();
                System.out.println(nice_output);
            }
        } else {
            while (i < top) {
                ArrayList<Float> hf = unique_hypothesis.get((int)i)._hypFeatures;
                String result = "HYP " + Integer.toString(i) + " [ " + "Size = " + Float.toString(hf.get(0).floatValue()) + "; score = " + String.format("%.5f", unique_hypothesis.get((int)i)._score) + " ]\n";
                String result_one_line = "1-LINE-HYP: " + Float.toString(hf.get(0).floatValue()) + " ||| " + unique_hypothesis.get(i).toOneString() + "\n\n";
                for (int j = 0; j < unique_hypothesis.get(i).size(); ++j) {
                    result = result + unique_hypothesis.get(i).get(j).toString() + "\n";
                }
                result = result + "\n";
                this._outData.write(result);
                if (this.verbosity > 1) {
                    this._outData.write(result_one_line);
                }
                ++i;
            }
            this._outData.write("#END#\n\n");
        }
    }

    private ArrayList<Hypothesis> Unique_Hypothesis(ArrayList<Hypothesis> hypothesis) {
        ArrayList<Hypothesis> unq = new ArrayList<Hypothesis>();
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        for (int j = 0; j < hypothesis.size(); ++j) {
            Hypothesis c = hypothesis.get(j);
            if (hm.containsKey(c.toOneString())) continue;
            hm.put(c.toString(), 1);
            unq.add(c);
        }
        return unq;
    }

    private double getHypScore(ArrayList<Float> hf, ArrayList<Double> w) {
        double score = 0.0;
        for (int i = 0; i < hf.size(); ++i) {
            score += w.get(i) * (double)hf.get(i).floatValue();
        }
        return score;
    }

    private ArrayList<Float> getHypFeatures(Hypothesis o1, SentenceData sent) {
        ArrayList<Float> hf = new ArrayList();
        Features F2 = new Features(o1, sent);
        hf = F2.getFeaturesVector();
        return hf;
    }

    private ArrayList<Hypothesis> Sort_Hyp(ArrayList<Hypothesis> hypothesis, SentenceData sent) {
        Collections.sort(hypothesis, new Comparator<Hypothesis>(){

            @Override
            public int compare(Hypothesis o1, Hypothesis o2) {
                if (o1._score > o2._score) {
                    return -1;
                }
                if (o1._score < o2._score) {
                    return 1;
                }
                return 0;
            }
        });
        return hypothesis;
    }

    private ArrayList<ArrayList<Hypothesis>> Filter_Hyp_By_NP_Coverage(ArrayList<Hypothesis> hypothesis, SentenceData sent) {
        ArrayList<Hypothesis> h = new ArrayList<Hypothesis>();
        ArrayList<Hypothesis> nh = new ArrayList<Hypothesis>();
        ArrayList<ArrayList<Hypothesis>> hyplist = new ArrayList<ArrayList<Hypothesis>>();
        ArrayList<String> NPlist = sent.NPtoString();
        for (int i = 0; i < hypothesis.size(); ++i) {
            ArrayList<String> hyp_NPlist = new ArrayList<String>();
            for (int j = 0; j < hypothesis.get(i).size(); ++j) {
                hyp_NPlist.add(hypothesis.get(i).get(j).e1toString());
                hyp_NPlist.add(hypothesis.get(i).get(j).e2toString());
            }
            boolean isGoodHyp = true;
            for (int k = 0; k < NPlist.size(); ++k) {
                boolean found_np = false;
                for (int m = 0; m < hyp_NPlist.size(); ++m) {
                    if (!((String)hyp_NPlist.get(m)).contains(NPlist.get(k))) continue;
                    found_np = true;
                }
                if (found_np) continue;
                isGoodHyp = false;
                break;
            }
            if (isGoodHyp) {
                h.add(hypothesis.get(i));
                continue;
            }
            nh.add(hypothesis.get(i));
        }
        hyplist.add(h);
        hyplist.add(nh);
        return hyplist;
    }

    private Stack<Hypothesis> Init_HypStack_By_First_VP(Map<String, ArrayList<Relation>> ObjT, Relation r1) {
        Stack<Hypothesis> h = new Stack<Hypothesis>();
        for (String key : ObjT.keySet()) {
            for (Relation t : ObjT.get(key)) {
                int vp_position = t._r[0]._position;
                int r1_vp_position = r1._r[0]._position;
                if (vp_position != r1_vp_position) continue;
                Hypothesis ph = new Hypothesis();
                ph.add(t);
                h.push(ph);
            }
        }
        return h;
    }

    private Stack<Hypothesis> Init_Stack_By_First_Object(Map<String, ArrayList<Relation>> ObjT, int min_post) {
        Stack<Hypothesis> h = new Stack<Hypothesis>();
        for (String key : ObjT.keySet()) {
            Relation tmp = ObjT.get(key).get(0);
            int npobj = tmp._e2[tmp._e2.length - 1]._position;
            if (npobj != min_post) continue;
            for (Relation t : ObjT.get(key)) {
                Hypothesis ph = new Hypothesis();
                ph.add(t);
                h.push(ph);
            }
        }
        return h;
    }

    private Stack<Hypothesis> Init_Stack_By_All(SentenceData sent) {
        Stack<Hypothesis> h = new Stack<Hypothesis>();
        for (int j = 0; j < sent.relationCount(); ++j) {
            Relation r = sent.relationAt(j);
            if (!r._label) continue;
            Hypothesis ph = new Hypothesis();
            if (r._e1[r._e1.length - 1]._position >= this.max_subj_length) continue;
            ph.add(r);
            h.push(ph);
        }
        return h;
    }

    private Stack<Hypothesis> Expanding_Hypothesis(Hypothesis partial_hyp, Map<String, ArrayList<Relation>> ot, Stack<Hypothesis> hyp_expansion, SentenceData sent) {
        HashMap<String, Integer> covered_obj = new HashMap<String, Integer>();
        for (int i = 0; i < partial_hyp.size(); ++i) {
            Relation r = partial_hyp.get(i);
            String np2 = r.e2toString();
            covered_obj.put(np2, 1);
        }
        for (String obj : ot.keySet()) {
            if (!covered_obj.containsKey(obj)) {
                if (this.verbosity > 5) {
                    System.out.println("DEBUG trying to expand object = " + obj);
                }
                for (Relation t : ot.get(obj)) {
                    Hypothesis new_hyp = new Hypothesis();
                    new_hyp.addAll(partial_hyp);
                    boolean isNewHyp = true;
                    block3: for (int k = 0; k < partial_hyp.size(); ++k) {
                        String tok;
                        int i;
                        String np1 = partial_hyp.get(k).e1toString();
                        String vp = partial_hyp.get(k).rtoString();
                        String np2 = partial_hyp.get(k).e2toString();
                        if (t.rtoString().equals(vp) || this.isVPwithPPAttachment(t._r, partial_hyp.get((int)k)._r)) {
                            for (i = 0; i < partial_hyp.get((int)k)._e2.length; ++i) {
                                tok = partial_hyp.get((int)k)._e2[i].toString();
                                if (!t.e2toString().contains(tok)) continue;
                                isNewHyp = false;
                                break;
                            }
                        }
                        for (i = 0; i < partial_hyp.get((int)k)._e2.length; ++i) {
                            tok = partial_hyp.get((int)k)._e2[i].toString();
                            int lp = t._e1[t._e1.length - 1]._position;
                            if (!t.e1toString().contains(tok) || lp >= sent.size() - 2 || sent.POSTagAt(lp + 1).equals("WDT") || sent.POSTagAt(lp + 1).equals("WP") || sent.POSTagAt(lp + 1).equals("WP$") || sent.POSTagAt(lp + 1).equals(",") || sent.POSTagAt(lp + 2).equals("WDT") || sent.POSTagAt(lp + 2).equals("WP") && sent.POSTagAt(lp + 2).equals("WP$")) continue;
                            if (this.verbosity > 5) {
                                System.out.println("DEBUG POS = " + sent.POSTagAt(lp) + " " + sent.POSTagAt(lp + 1) + " " + sent.POSTagAt(lp + 2));
                            }
                            isNewHyp = false;
                            continue block3;
                        }
                    }
                    if (isNewHyp) {
                        new_hyp.add(t);
                        hyp_expansion.push(new_hyp);
                        continue;
                    }
                    if (this.verbosity <= 5) continue;
                    System.out.println("DEBUG cannot expand with t = " + t.toString());
                }
                continue;
            }
            if (this.verbosity <= 5) continue;
            System.out.println("DEBUG obj ::: " + obj + " ::: is covered");
        }
        return hyp_expansion;
    }

    private Stack<Hypothesis> Prune_Hyp_By_Word_Covered(Stack<Hypothesis> HypStack, int max_size) {
        Stack<Hypothesis> sorted_HypStack = new Stack<Hypothesis>();
        ArrayList<Hypothesis> hyp = new ArrayList<Hypothesis>();
        while (!HypStack.empty()) {
            Hypothesis r = HypStack.pop();
            hyp.add(r);
        }
        Collections.sort(hyp, new Comparator<Hypothesis>(){

            @Override
            public int compare(Hypothesis o1, Hypothesis o2) {
                int j;
                int o1_count = 0;
                int o2_count = 0;
                for (j = 0; j < o1.size(); ++j) {
                    o1_count += o1.get((int)j)._e1.length + o1.get((int)j)._e2.length + o1.get((int)j)._r.length;
                }
                for (j = 0; j < o2.size(); ++j) {
                    o2_count += o2.get((int)j)._e1.length + o2.get((int)j)._e2.length + o2.get((int)j)._r.length;
                }
                return o2_count - o1_count;
            }
        });
        if (this.verbosity > 5) {
            for (Hypothesis r : hyp) {
                for (int j = 0; j < r.size(); ++j) {
                    System.out.format("DEBUG j = %d ; ph = %s%n", j, r.get(j).toString());
                }
            }
        }
        int top = Math.min(max_size, hyp.size());
        for (int i = 0; i < top; ++i) {
            sorted_HypStack.push((Hypothesis)hyp.get(i));
        }
        return sorted_HypStack;
    }

    private boolean isVPwithPPAttachment(Token[] r, Token[] r2) {
        if (Math.abs(r.length - r2.length) > 1) {
            return false;
        }
        int s = Math.max(r.length, r2.length);
        for (int i = 0; i < s - 1; ++i) {
            if (r[i]._position == r2[i]._position) continue;
            return false;
        }
        if (r.length > r2.length && !this.isPreposition(r[s - 1]._token)) {
            return false;
        }
        return r2.length <= r.length || this.isPreposition(r2[s - 1]._token);
    }

    private double FourDecimal(double val) {
        DecimalFormat fourDec = new DecimalFormat("0.0000");
        val = Double.parseDouble(fourDec.format(val));
        return val;
    }

    private boolean isPreposition(String token) {
        HashMap<String, String> _prepositions = null;
        if (_prepositions == null) {
            _prepositions = new HashMap<String, String>();
            _prepositions.put("aboard", "x");
            _prepositions.put("about", "x");
            _prepositions.put("above", "x");
            _prepositions.put("across", "x");
            _prepositions.put("against", "x");
            _prepositions.put("along", "x");
            _prepositions.put("alongside", "x");
            _prepositions.put("among", "x");
            _prepositions.put("amongst", "x");
            _prepositions.put("around", "x");
            _prepositions.put("at", "x");
            _prepositions.put("behind", "x");
            _prepositions.put("below", "x");
            _prepositions.put("between", "x");
            _prepositions.put("beyond", "x");
            _prepositions.put("by", "x");
            _prepositions.put("down", "x");
            _prepositions.put("during", "x");
            _prepositions.put("except", "x");
            _prepositions.put("for", "x");
            _prepositions.put("from", "x");
            _prepositions.put("in", "x");
            _prepositions.put("including", "x");
            _prepositions.put("inside", "x");
            _prepositions.put("into", "x");
            _prepositions.put("near", "x");
            _prepositions.put("of", "x");
            _prepositions.put("off", "x");
            _prepositions.put("on", "x");
            _prepositions.put("onto", "x");
            _prepositions.put("out", "x");
            _prepositions.put("outside", "x");
            _prepositions.put("over", "x");
            _prepositions.put("past", "x");
            _prepositions.put("per", "x");
            _prepositions.put("throughout", "x");
            _prepositions.put("toward", "x");
            _prepositions.put("towards", "x");
            _prepositions.put("under", "x");
            _prepositions.put("underneath", "x");
            _prepositions.put("up", "x");
            _prepositions.put("upon", "x");
            _prepositions.put("with", "x");
            _prepositions.put("within", "x");
            _prepositions.put("without", "x");
        }
        return _prepositions.containsKey(token);
    }
}

