/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.Token;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Relation {
    public boolean _label;
    public Token[] _e1;
    public Token[] _e2;
    public Token[] _r;
    public ArrayList<String> _features;

    public Relation() {
    }

    public Relation(ArrayList e1, ArrayList r, ArrayList e2) {
        this._label = true;
        this._e1 = new Token[e1.size()];
        this._e2 = new Token[e2.size()];
        this._r = new Token[r.size()];
        e1.toArray(this._e1);
        e2.toArray(this._e2);
        r.toArray(this._r);
    }

    public Relation(String relation) {
        try {
            this._label = true;
            int pos1 = relation.indexOf(", ", 0);
            int pos2 = relation.indexOf(", ", pos1 + 1);
            String e1 = relation.substring(1, pos1);
            this._e1 = this.tokenizeString(e1);
            String r = relation.substring(pos1 + 1, pos2);
            this._r = this.tokenizeString(r);
            String e2 = relation.substring(pos2 + 1, relation.length() - 1);
            this._e2 = this.tokenizeString(e2);
        }
        catch (Exception e) {
            System.out.println(relation);
            System.exit(-1);
        }
    }

    public void setFeatures(ArrayList<String> features) {
        this._features = features;
    }

    public void addFeature(String f) {
        this._features.add(f);
    }

    public ArrayList<Token> allTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.copyTo(tokens, this._e1);
        this.copyTo(tokens, this._r);
        this.copyTo(tokens, this._e2);
        return tokens;
    }

    private Token[] tokenizeString(String s) {
        StringTokenizer t = new StringTokenizer(s, " ");
        int count = t.countTokens();
        Token[] result = new Token[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new Token(t.nextToken());
        }
        return result;
    }

    public void copyTo(ArrayList<Token> al, Token[] ts) {
        for (int i = 0; i < ts.length; ++i) {
            al.add(ts[i]);
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String e1toString() {
        return this.toString(this._e1).toString();
    }

    public String e2toString() {
        return this.toString(this._e2).toString();
    }

    public String rtoString() {
        return this.toString(this._r).toString();
    }

    public String toRawString(Token[] toks) {
        String current = "";
        for (int i = 0; i < toks.length - 1; ++i) {
            current = current + toks[i]._token + " ";
        }
        current = current + toks[toks.length - 1]._token;
        return current;
    }

    public String toOneString() {
        return this.toRawString(this._e1) + " " + this.toRawString(this._r) + " " + this.toRawString(this._e2);
    }

    public String toString(boolean printLabel) {
        StringBuffer res = new StringBuffer();
        if (printLabel) {
            int label = this._label ? 1 : 0;
            res.append(label);
            res.append(" ||| ");
        }
        res.append(this.toString(this._e1));
        res.append(" ||| ");
        res.append(this.toString(this._r));
        res.append(" ||| ");
        res.append(this.toString(this._e2));
        res.append(" ||| ");
        if (this._features != null) {
            for (int i = 0; i < this._features.size() - 1; ++i) {
                res.append(this._features.get(i));
                res.append(',');
            }
            res.append(this._features.get(this._features.size() - 1));
        }
        return res.toString();
    }

    private StringBuffer toString(Token[] tokens) {
        StringBuffer result = new StringBuffer();
        if (tokens[0]._position != -1) {
            for (int i = 0; i < tokens.length; ++i) {
                result.append(tokens[i].toString());
                if (i == tokens.length - 1) continue;
                result.append(' ');
            }
        } else {
            result.append("");
        }
        return result;
    }
}

