/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.FilterFunction;
import edu.cmu.cs.lti.relationFilter.Relation;
import edu.cmu.cs.lti.relationFilter.SentenceData;
import edu.cmu.cs.lti.relationFilter.Token;
import edu.stanford.nlp.trees.Tree;

public class ObjectInTheSameVP
implements FilterFunction {
    @Override
    public boolean filter(SentenceData s, Relation r) {
        if (r._e2[0]._position == 1) {
            return true;
        }
        Tree e1 = this.GetFirstTreeNode(r._e1, s);
        Tree e2 = this.GetFirstTreeNode(r._e2, s);
        Tree rel = this.GetFirstTreeNode(r._r, s);
        Tree anc1 = Tree.leastCommonAncestor(rel, e2);
        Tree vp = this.getVPparent(anc1);
        return vp != null || s.POSTagAt(1).equals("IN");
    }

    private Tree GetFirstTreeNode(Token[] tokens, SentenceData s) {
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i]._position == -1 || s.POSTagAt(tokens[i]._position).equals("IN")) continue;
            return s.leafAt(tokens[i]._position);
        }
        return null;
    }

    private Tree getVPparent(Tree t) {
        if (t == null) {
            return null;
        }
        if (((Object)t.label()).toString().equals("VP")) {
            return t;
        }
        return this.getVPparent(t.getParent());
    }
}

