/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.DependencyDistanceFilter;
import edu.cmu.cs.lti.relationFilter.FilterFunction;
import edu.cmu.cs.lti.relationFilter.ObjectInTheSameVP;
import edu.cmu.cs.lti.relationFilter.PPAttachmentFeature;
import edu.cmu.cs.lti.relationFilter.Relation;
import edu.cmu.cs.lti.relationFilter.RelationContainsVBFeature;
import edu.cmu.cs.lti.relationFilter.SentenceData;
import edu.cmu.cs.lti.relationFilter.SentenceLikeBoundaryFeature;
import edu.cmu.cs.lti.relationFilter.SinglePronounFeature;
import java.util.ArrayList;
import java.util.Properties;

public class Filter {
    ArrayList<FilterFunction> _filters = new ArrayList();
    long _totalRel = 0L;
    long _posRel = 0L;
    int verbosity = 0;

    public Filter(int debug) {
        this._filters.add(new RelationContainsVBFeature());
        this._filters.add(new PPAttachmentFeature());
        this._filters.add(new SinglePronounFeature());
        this._filters.add(new SentenceLikeBoundaryFeature());
        this._filters.add(new ObjectInTheSameVP());
    }

    public SentenceData addSoftFilterFeature(SentenceData sent) {
        for (int i = 0; i < this._filters.size(); ++i) {
            FilterFunction filter = this._filters.get(i);
            for (int j = 0; j < sent.relationCount(); ++j) {
                Relation r = sent.relationAt(j);
                try {
                    boolean value = filter.filter(sent, r);
                    if (!value) {
                        r._features.add("0");
                        continue;
                    }
                    r._features.add("1");
                    continue;
                }
                catch (Exception e) {
                    System.out.println("DEBUG ***** ERROR in applying filtering rules " + j + " *****");
                    System.out.println("Got an IOException: " + e.getMessage());
                    System.out.println(sent.toString());
                    System.out.println(r.toString());
                    System.exit(-1);
                }
            }
        }
        return sent;
    }

    public Filter(Properties _props, int debug) {
        this.verbosity = debug;
        this._filters.add(new RelationContainsVBFeature());
        if (_props.getProperty("FilterPPAttachment").equals("true")) {
            this._filters.add(new PPAttachmentFeature());
            if (this.verbosity > 0) {
                System.out.println("PPAttachment filter created");
            }
        }
        if (_props.getProperty("FilterSinglePronoun").equals("true")) {
            this._filters.add(new SinglePronounFeature());
            if (this.verbosity > 0) {
                System.out.println("Single Pronoun filter created");
            }
        }
        if (_props.getProperty("FilterSentenceLikeBoundary").equals("true")) {
            this._filters.add(new SentenceLikeBoundaryFeature());
            if (this.verbosity > 0) {
                System.out.println("SentenceLikeBoundary filter created");
            }
        }
        if (_props.getProperty("FilterObjectInTheSameVP").equals("true")) {
            this._filters.add(new ObjectInTheSameVP());
            if (this.verbosity > 0) {
                System.out.println("ObjectInTheSameVP filter created");
            }
        }
        if (_props.getProperty("FilterDependencyDistance").equals("true")) {
            int maxDist = Integer.parseInt(_props.getProperty("MaximumDependencyDistance", "5"));
            int minDist = Integer.parseInt(_props.getProperty("MinimumDependencyDistance", "10"));
            int spanDist = Integer.parseInt(_props.getProperty("SpanDependencyDistance", "6"));
            this._filters.add(new DependencyDistanceFilter(minDist, maxDist, spanDist));
            if (this.verbosity > 0) {
                System.out.println("Dependency Distance filter created, minDist=" + minDist + " ; maxDist=" + maxDist + " ; spanDist=" + spanDist);
            }
        }
        if (this.verbosity > 0) {
            System.out.println("");
        }
    }

    public SentenceData filterSentence(SentenceData sent) {
        for (int i = 0; i < this._filters.size(); ++i) {
            FilterFunction filter = this._filters.get(i);
            for (int j = 0; j < sent.relationCount(); ++j) {
                Relation r = sent.relationAt(j);
                if (r.e2toString().equals("-10000")) {
                    r._label = true;
                    continue;
                }
                if (!r._label) continue;
                try {
                    boolean value = filter.filter(sent, r);
                    if (value) continue;
                    r._label = false;
                    continue;
                }
                catch (Exception e) {
                    System.out.println("DEBUG ***** ERROR in applying filtering rules " + j + " *****");
                    System.out.println("Got an IOException: " + e.getMessage());
                    System.out.println(sent.toString());
                    System.out.println(r.toString());
                    System.exit(-1);
                }
            }
        }
        for (int j = 0; j < sent.relationCount(); ++j) {
            Relation r = sent.relationAt(j);
            ++this._totalRel;
            if (!r._label) continue;
            ++this._posRel;
        }
        if (this.verbosity > 0) {
            System.out.println("Extracted simplified sentences: " + this._totalRel);
            System.out.println("After filtering               : " + this._posRel);
        }
        return sent;
    }

    public void setVerbosity(int i) {
        this.verbosity = i;
    }
}

