/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.Dependency;
import edu.cmu.cs.lti.relationFilter.Fathom;
import edu.cmu.cs.lti.relationFilter.Hypothesis;
import edu.cmu.cs.lti.relationFilter.Relation;
import edu.cmu.cs.lti.relationFilter.SentenceData;
import edu.cmu.cs.lti.relationFilter.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Features {
    public Hypothesis _hyp;
    public SentenceData _sent;
    HashMap<String, Integer> _dependencyType = new HashMap();

    public Features() {
    }

    public Features(Hypothesis h, SentenceData s) {
        this._hyp = h;
        this._sent = s;
    }

    public ArrayList<Float> getFeaturesVector() {
        ArrayList<Float> hf = new ArrayList<Float>();
        ArrayList<Object> relational_features = new ArrayList();
        ArrayList<Object> np_coverage = new ArrayList();
        ArrayList<Object> vp_coverage = new ArrayList();
        ArrayList<Object> np1_cross_sent = new ArrayList();
        ArrayList<Object> readability = new ArrayList();
        ArrayList<Object> hypsize = new ArrayList();
        ArrayList<Object> sent1 = new ArrayList();
        ArrayList<Object> sent2 = new ArrayList();
        ArrayList<Object> sent1_dtype = new ArrayList();
        ArrayList<Object> sent2_dtype = new ArrayList();
        np_coverage = this.getNP_Coverage();
        vp_coverage = this.getVP_Coverage();
        np1_cross_sent = this.getNP1_CrossSent();
        readability = this.getReadability();
        hypsize = this.getHypSizeBinary();
        float normalized_ed1 = this.getNormalized_EditDistance();
        float normalized_wordcount = this.getNormalized_WordCount();
        float normalized_missing_np = this.getNormalized_MisingNP();
        sent1_dtype = this.getSentDType(this._hyp.get(0));
        sent2_dtype = this.getSentDType(this._hyp.get(1));
        sent1 = this.getSentFeat(this._hyp.get(0));
        sent2 = this.getSentFeat(this._hyp.get(1));
        relational_features = this.getAverageSentFeat();
        hf.add(Float.valueOf(this._hyp.size()));
        hf.addAll(hypsize);
        hf.addAll(np_coverage);
        hf.addAll(vp_coverage);
        hf.addAll(np1_cross_sent);
        hf.addAll(readability);
        hf.add(Float.valueOf(normalized_ed1));
        hf.add(Float.valueOf(normalized_wordcount));
        hf.add(Float.valueOf(normalized_missing_np));
        hf.addAll(sent1_dtype);
        hf.addAll(sent2_dtype);
        hf.addAll(sent1);
        hf.addAll(sent2);
        hf.addAll(relational_features);
        return hf;
    }

    private ArrayList<Float> getHypSizeBinary() {
        ArrayList<Float> f = new ArrayList<Float>();
        for (int i = 0; i < 5; ++i) {
            f.add(i, Float.valueOf(0.0f));
        }
        if (this._hyp.size() == 2) {
            f.set(0, Float.valueOf(1.0f));
        }
        if (this._hyp.size() == 3) {
            f.set(1, Float.valueOf(1.0f));
        }
        if (this._hyp.size() == 4) {
            f.set(2, Float.valueOf(1.0f));
        }
        if (this._hyp.size() == 5) {
            f.set(3, Float.valueOf(1.0f));
        }
        if (this._hyp.size() > 5) {
            f.set(4, Float.valueOf(1.0f));
        }
        return f;
    }

    private ArrayList<Float> getSentDType(Relation rel) {
        ArrayList<Float> f = new ArrayList<Float>();
        this.init_dependency_type();
        ArrayList<Dependency> tdtree = this._sent.getTypedDependencies();
        HashMap<String, String> td = new HashMap<String, String>();
        for (int i = 0; i < tdtree.size(); ++i) {
            Token t1 = tdtree.get(i).first();
            Token t2 = tdtree.get(i).second();
            String type = tdtree.get(i).type();
            String t1t2 = t1.toString() + t2.toString();
            String t2t1 = t2.toString() + t1.toString();
            td.put(t1t2, type);
            td.put(t2t1, type);
        }
        this.getDependenciesType(rel._r, rel._e1, td);
        this.getDependenciesType(rel._r, rel._e2, td);
        this.getDependenciesType(rel._e1, rel._e1, td);
        this.getDependenciesType(rel._e2, rel._e2, td);
        this.getDependenciesType(rel._e1, rel._e2, td);
        for (Map.Entry<String, Integer> e : this._dependencyType.entrySet()) {
            float val = e.getValue().intValue();
            f.add(Float.valueOf(val));
        }
        return f;
    }

    private void getDependenciesType(Token[] tok1, Token[] tok2, HashMap<String, String> td) {
        for (int i = 0; i < tok1.length; ++i) {
            for (int j = 0; j < tok2.length; ++j) {
                String dt = this.getDepType(tok1[i], tok2[j], td);
                if (dt.isEmpty()) continue;
                try {
                    int val = this._dependencyType.get(dt);
                    this._dependencyType.put(dt, val + 1);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("ERROR!!!DT = " + dt + "\nSENT = " + this._sent.toString() + "\nHYP = " + this._hyp.toOneString());
                }
            }
        }
    }

    private String getDepType(Token t1, Token t2, HashMap<String, String> td) {
        String type = "";
        String t1t2 = t1.toString() + " " + t2.toString();
        String t2t1 = t2.toString() + " " + t1.toString();
        if (td.containsKey(t1t2)) {
            type = td.get(t1t2);
        } else if (td.containsKey(t2t1)) {
            type = td.get(t2t1);
        }
        return type;
    }

    private ArrayList<Float> getReadability() {
        ArrayList<Float> f = new ArrayList<Float>();
        Fathom.Stats FatStat = Fathom.analyze(this._hyp.toOneNiceString());
        double nsyl = FatStat.getNumSyllables();
        double nword = FatStat.getNumWords();
        double nsent = FatStat.getNumSentences();
        double ncomplexword = FatStat.getNumComplexWords();
        double npolysyl = FatStat.getNumPolySyllables();
        double nletter = FatStat.getNumLetters();
        double words_per_sentence = nword / nsent;
        double syllables_per_word = nsyl / nword;
        double percent_complex_words = ncomplexword / nword * 100.0;
        double poly_per_sentence = npolysyl / nsent;
        double letter_per_word = nletter / nword;
        float flesh = (float)(206.835 - 1.015 * words_per_sentence - 84.6 * syllables_per_word);
        float fog = (float)((words_per_sentence + percent_complex_words) * 0.4);
        float kincaid = (float)(11.8 * syllables_per_word + 0.39 * words_per_sentence - 15.59);
        float smog = (float)(1.043 * Math.sqrt(30.0 * poly_per_sentence) + 3.1291);
        float ari = (float)(4.71 * letter_per_word + 0.5 * words_per_sentence - 21.43);
        float average = (flesh + fog + kincaid + smog + ari) / 5.0f;
        f.add(Float.valueOf(flesh));
        f.add(Float.valueOf(fog));
        f.add(Float.valueOf(kincaid));
        f.add(Float.valueOf(smog));
        f.add(Float.valueOf(ari));
        f.add(Float.valueOf(average));
        return f;
    }

    private ArrayList<Float> getSentFeat(Relation rel) {
        int i;
        ArrayList<Float> f = new ArrayList<Float>();
        for (i = 0; i < this._hyp.get((int)0)._features.size(); ++i) {
            f.add(new Float(0.0f));
        }
        for (i = 0; i < rel._features.size(); ++i) {
            float val = Float.parseFloat(rel._features.get(i));
            f.set(i, Float.valueOf(f.get(i).floatValue() + val));
        }
        return f;
    }

    private ArrayList<Float> getNP1_CrossSent() {
        ArrayList<Float> f = new ArrayList<Float>();
        String np1s1 = this._hyp.get(0).e1toString();
        String np2s1 = this._hyp.get(0).e2toString();
        String np1s2 = this._hyp.get(1).e1toString();
        float ed1 = this.EditDistance(np1s1, np1s2);
        float ed2 = this.EditDistance(np2s1, np1s2);
        f.add(Float.valueOf(ed1));
        f.add(Float.valueOf(ed2));
        return f;
    }

    private ArrayList<Float> getNP_Coverage() {
        ArrayList<Float> npc = new ArrayList<Float>();
        ArrayList<String> NPlist = this._sent.NPtoString();
        HashMap<String, Integer> CoverNP = new HashMap<String, Integer>();
        for (int i = 0; i < NPlist.size(); ++i) {
            CoverNP.put(NPlist.get(i), 0);
        }
        ArrayList<String> hyp_NPlist = new ArrayList<String>();
        for (int j = 0; j < this._hyp.size(); ++j) {
            hyp_NPlist.add(this._hyp.get(j).e1toString());
            hyp_NPlist.add(this._hyp.get(j).e2toString());
        }
        for (int k = 0; k < NPlist.size(); ++k) {
            for (int m = 0; m < hyp_NPlist.size(); ++m) {
                if (!((String)hyp_NPlist.get(m)).contains(NPlist.get(k))) continue;
                CoverNP.put(NPlist.get(k), 1);
            }
        }
        float np_coverage = 0.0f;
        for (int i = 0; i < NPlist.size(); ++i) {
            np_coverage += (float)((Integer)CoverNP.get(NPlist.get(i))).intValue();
        }
        float np_coverage_s1 = 0.0f;
        String s1e1 = this._hyp.get(0).e1toString();
        String s1e2 = this._hyp.get(0).e2toString();
        for (int i = 0; i < NPlist.size(); ++i) {
            if (!s1e1.contains(NPlist.get(i)) && !s1e2.contains(NPlist.get(i))) continue;
            np_coverage_s1 += 1.0f;
        }
        float np_coverage_s2 = 0.0f;
        String s2e1 = this._hyp.get(1).e1toString();
        String s2e2 = this._hyp.get(1).e2toString();
        for (int i = 0; i < NPlist.size(); ++i) {
            if (!s2e1.contains(NPlist.get(i)) && !s2e2.contains(NPlist.get(i))) continue;
            np_coverage_s2 += 1.0f;
        }
        float normalize_np_c = np_coverage / (float)this._hyp.size();
        npc.add(Float.valueOf(np_coverage));
        npc.add(Float.valueOf(normalize_np_c));
        npc.add(Float.valueOf(np_coverage_s1));
        npc.add(Float.valueOf(np_coverage_s2));
        return npc;
    }

    private ArrayList<Float> getVP_Coverage() {
        ArrayList<Float> vpc = new ArrayList<Float>();
        ArrayList<String> VPlist = this._sent.VPtoString();
        HashMap<String, Integer> CoverVP = new HashMap<String, Integer>();
        for (int i = 0; i < VPlist.size(); ++i) {
            CoverVP.put(VPlist.get(i), 0);
        }
        ArrayList<String> hyp_VPlist = new ArrayList<String>();
        for (int j = 0; j < this._hyp.size(); ++j) {
            hyp_VPlist.add(this._hyp.get(j).rtoString());
        }
        for (int k = 0; k < VPlist.size(); ++k) {
            for (int m = 0; m < hyp_VPlist.size(); ++m) {
                if (!((String)hyp_VPlist.get(m)).contains(VPlist.get(k))) continue;
                CoverVP.put(VPlist.get(k), 1);
            }
        }
        float vp_coverage = 0.0f;
        for (int i = 0; i < VPlist.size(); ++i) {
            vp_coverage += (float)((Integer)CoverVP.get(VPlist.get(i))).intValue();
        }
        float vp_coverage_s1 = 0.0f;
        String s1r = this._hyp.get(0).rtoString();
        for (int i = 0; i < VPlist.size(); ++i) {
            if (!s1r.contains(VPlist.get(i))) continue;
            vp_coverage_s1 += 1.0f;
        }
        float vp_coverage_s2 = 0.0f;
        String s2r = this._hyp.get(1).rtoString();
        for (int i = 0; i < VPlist.size(); ++i) {
            if (!s2r.contains(VPlist.get(i))) continue;
            vp_coverage_s2 += 1.0f;
        }
        float normalize_vp_c = vp_coverage / (float)this._hyp.size();
        vpc.add(Float.valueOf(vp_coverage));
        vpc.add(Float.valueOf(normalize_vp_c));
        vpc.add(Float.valueOf(vp_coverage_s1));
        vpc.add(Float.valueOf(vp_coverage_s2));
        return vpc;
    }

    private ArrayList<Float> getAverageSentFeat() {
        int j;
        ArrayList<Float> f = new ArrayList<Float>();
        for (int i = 0; i < this._hyp.get((int)0)._features.size(); ++i) {
            f.add(new Float(0.0f));
        }
        for (j = 0; j < this._hyp.size(); ++j) {
            Relation rel = this._hyp.get(j);
            for (int i = 0; i < rel._features.size(); ++i) {
                float val = Float.parseFloat(rel._features.get(i));
                f.set(i, Float.valueOf(f.get(i).floatValue() + val));
            }
        }
        for (j = 0; j < f.size(); ++j) {
            f.set(j, Float.valueOf(f.get(j).floatValue() / (float)this._hyp.size()));
        }
        return f;
    }

    private float getNormalized_MisingNP() {
        ArrayList<String> NPlist = this._sent.NPtoString();
        float o1_missing_np = NPlist.size();
        float normalized_missing_np = NPlist.size();
        HashMap<String, Integer> o1_NPlist = new HashMap<String, Integer>();
        for (int j = 0; j < this._hyp.size(); ++j) {
            o1_NPlist.put(this._hyp.get(j).e1toString(), 1);
            o1_NPlist.put(this._hyp.get(j).e2toString(), 1);
        }
        for (int i = 0; i < NPlist.size(); ++i) {
            if (!o1_NPlist.containsKey(NPlist.get(i))) continue;
            o1_missing_np -= 1.0f;
        }
        normalized_missing_np = o1_missing_np / (float)this._hyp.size();
        return normalized_missing_np;
    }

    private float getNormalized_WordCount() {
        float h_wordcount = 0.0f;
        float normalized_wordcount = 0.0f;
        for (int j = 0; j < this._hyp.size(); ++j) {
            h_wordcount += (float)(this._hyp.get((int)j)._e1.length + this._hyp.get((int)j)._e2.length + this._hyp.get((int)j)._r.length);
        }
        normalized_wordcount = h_wordcount / (float)this._hyp.size();
        return normalized_wordcount;
    }

    private float getNormalized_EditDistance() {
        String rawSentence = this._sent.getRawSentenceString();
        String o1_vp_np2 = "";
        for (int j = 0; j < this._hyp.size(); ++j) {
            o1_vp_np2 = o1_vp_np2 + this._hyp.get(j).toRawString(this._hyp.get((int)j)._r) + " " + this._hyp.get(j).toRawString(this._hyp.get((int)j)._e2) + " ";
        }
        float ed1 = this.EditDistance(o1_vp_np2, rawSentence);
        float normalized_ed1 = ed1 / (float)this._hyp.size();
        return normalized_ed1;
    }

    private int EditDistance(String str1, String str2) {
        int j;
        String[] s1 = str1.split(" ");
        String[] s2 = str2.split(" ");
        int m = s1.length;
        int n = s2.length;
        int[][] d = new int[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (j = 1; j <= n; ++j) {
            for (int i = 1; i <= m; ++i) {
                int cost = s1[i - 1].equals(s2[j - 1]) ? 0 : 1;
                d[i][j] = this.minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[m][n];
    }

    private int minimum(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    private void init_dependency_type() {
        this._dependencyType.clear();
        this._dependencyType.put("abbrev", 0);
        this._dependencyType.put("acomp", 0);
        this._dependencyType.put("advcl", 0);
        this._dependencyType.put("advmod", 0);
        this._dependencyType.put("amod", 0);
        this._dependencyType.put("appos", 0);
        this._dependencyType.put("attr", 0);
        this._dependencyType.put("aux", 0);
        this._dependencyType.put("auxpass", 0);
        this._dependencyType.put("cc", 0);
        this._dependencyType.put("ccomp", 0);
        this._dependencyType.put("complm", 0);
        this._dependencyType.put("conj", 0);
        this._dependencyType.put("cop", 0);
        this._dependencyType.put("csubj", 0);
        this._dependencyType.put("csubjpass", 0);
        this._dependencyType.put("dep", 0);
        this._dependencyType.put("det", 0);
        this._dependencyType.put("dobj", 0);
        this._dependencyType.put("expl", 0);
        this._dependencyType.put("infmod", 0);
        this._dependencyType.put("iobj", 0);
        this._dependencyType.put("mark", 0);
        this._dependencyType.put("measure", 0);
        this._dependencyType.put("neg", 0);
        this._dependencyType.put("nn", 0);
        this._dependencyType.put("nsubj", 0);
        this._dependencyType.put("nsubjpass", 0);
        this._dependencyType.put("num", 0);
        this._dependencyType.put("number", 0);
        this._dependencyType.put("parataxis", 0);
        this._dependencyType.put("partmod", 0);
        this._dependencyType.put("pcomp", 0);
        this._dependencyType.put("pobj", 0);
        this._dependencyType.put("poss", 0);
        this._dependencyType.put("possessive", 0);
        this._dependencyType.put("preconj", 0);
        this._dependencyType.put("predet", 0);
        this._dependencyType.put("prep", 0);
        this._dependencyType.put("prt", 0);
        this._dependencyType.put("purpcl", 0);
        this._dependencyType.put("quantmod", 0);
        this._dependencyType.put("rcmod", 0);
        this._dependencyType.put("rel", 0);
        this._dependencyType.put("tmod", 0);
        this._dependencyType.put("xcomp", 0);
    }
}

