/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.Syllable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Fathom {
    private static final String[] abbreviations = new String[]{"Mr", "Mrs", "M", "Dr", "Prof", "Det", "Insp", "Pty", "PLC", "Ltd", "Inc", "etc", "vs"};
    private static final Pattern WORD_PAT = Pattern.compile("\\b([a-z][-'a-z]*)\\b");
    private static final Pattern VOWELS = Pattern.compile("[aeiouy]");
    private static final Pattern VALID_HYPHENS = Pattern.compile("[a-z]{2,}-[a-z]{2,}");
    private static final Pattern END_SENTENCE = Pattern.compile("\\b\\s*[.!?]\\s*\\b");
    private static final Pattern END_SENTENCE_END_LINE = Pattern.compile("\\b\\s*[.!?]\\s*$");

    public static Stats analyze(File f) throws IOException {
        return Fathom.analyze(new FileInputStream(f));
    }

    public static Stats analyze(InputStream s) throws IOException {
        return Fathom.analyze(new InputStreamReader(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stats analyze(Reader r) throws IOException {
        BufferedReader br = new BufferedReader(r);
        try {
            String line;
            Stats ret = new Stats();
            while ((line = br.readLine()) != null) {
                Fathom.analyzeWords(ret, line);
            }
            Stats stats = ret;
            return stats;
        }
        finally {
            br.close();
        }
    }

    public static Stats analyze(String s) {
        String[] sent = s.split("\n");
        Stats ret = new Stats();
        for (int i = 0; i < sent.length; ++i) {
            String line = sent[i] + ".";
            Fathom.analyzeWords(ret, line);
        }
        return ret;
    }

    public static Stats analyze(Stats stats, String s) {
        return Fathom.analyzeWords(stats, s);
    }

    private static Stats analyzeWords(Stats _stats, String _s) {
        Stats stats = _stats == null ? new Stats() : _stats;
        String s = _s.toLowerCase().trim();
        Matcher m = WORD_PAT.matcher(s);
        while (m.find()) {
            String word = m.group(1);
            if (!VOWELS.matcher(word).find() || word.indexOf(45) > 0 && !VALID_HYPHENS.matcher(word).matches()) continue;
            stats.addWord(word);
            stats.numLetters += word.length();
            int syl = Syllable.syllable(word);
            stats.numSyllables += syl;
            if (syl > 2) {
                stats.numPolySyllables++;
            }
            if (syl <= 2 || word.indexOf(45) >= 0) continue;
            stats.numComplexWords++;
        }
        s = Fathom.replaceAbbr(s);
        s.replaceAll("[\"']", "");
        m = END_SENTENCE.matcher(s);
        stats.numSentences++;
        m = END_SENTENCE_END_LINE.matcher(s);
        return stats;
    }

    private static final String replaceAbbr(String s) {
        String ret = s;
        for (String a : abbreviations) {
            ret = ret.replaceAll("\\s" + a + "\\.\\s", a);
        }
        return ret;
    }

    public static final class Stats {
        private int numWords = 0;
        private int numSentences = 0;
        private final int numTextLines = 0;
        private final int numBlankLines = 0;
        private int numSyllables = 0;
        private int numPolySyllables = 0;
        private int numLetters = 0;
        private int numComplexWords = 0;
        private final Map<String, Integer> uniqueWords = new HashMap<String, Integer>();

        private Stats() {
        }

        public String toString() {
            Object[] objectArray = new Object[6];
            objectArray[0] = this.numWords;
            objectArray[1] = this.numSentences;
            this.getClass();
            objectArray[2] = 0;
            this.getClass();
            objectArray[3] = 0;
            objectArray[4] = this.numSyllables;
            objectArray[5] = this.numComplexWords;
            return String.format("Stats:[words: %d, sentences: %d, text: %d, blank: %d, syllables: %d, complex: %d]", objectArray);
        }

        private void addWord(String s) {
            Integer i = this.uniqueWords.get(s);
            this.uniqueWords.put(s, i == null ? 1 : 1 + i);
            ++this.numWords;
        }

        public int getNumBlankLines() {
            return 0;
        }

        public int getNumSentences() {
            return this.numSentences;
        }

        public int getNumTextLines() {
            return 0;
        }

        public int getNumWords() {
            return this.numWords;
        }

        public int getNumComplexWords() {
            return this.numComplexWords;
        }

        public int getNumSyllables() {
            return this.numSyllables;
        }

        public int getNumPolySyllables() {
            return this.numPolySyllables;
        }

        public int getNumLetters() {
            return this.numLetters;
        }

        public Map<String, Integer> getUniqueWords() {
            return Collections.unmodifiableMap(this.uniqueWords);
        }
    }
}

