/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.Dependency;
import edu.cmu.cs.lti.relationFilter.Token;
import java.util.ArrayList;
import java.util.HashMap;

public class DependencyTree {
    private ArrayList<DependencyTree> _children = new ArrayList();
    private DependencyTree _parent = null;
    private String _type = null;
    private Token _token = null;
    private HashMap<String, DependencyTree> _entries = null;
    private int _depth = 0;
    public static int NO_PATH = 1000000;

    public DependencyTree(String type, Token token, DependencyTree parent) {
        this._type = type;
        this._token = token;
        this._parent = parent;
    }

    public void addChild(DependencyTree child) {
        this._children.add(child);
    }

    private void setType(String type) {
        if (this._type != null) {
            System.err.println("ERROR DEPEND");
        }
        this._type = type;
    }

    private void setParent(DependencyTree parent) {
        if (this._parent != null) {
            System.err.println("ERROR DEPEND");
        }
        this._parent = parent;
    }

    private void setEntriesMap(HashMap<String, DependencyTree> map) {
        this._entries = map;
    }

    public DependencyTree parent() {
        return this._parent;
    }

    public Token token() {
        return this._token;
    }

    public String type() {
        return this._type;
    }

    public DependencyTree findNode(Token t) {
        return this._entries.get(t.toString());
    }

    public int distance(Token t1, Token t2) {
        DependencyTree node1 = this.findNode(t1);
        DependencyTree node2 = this.findNode(t2);
        if (node1 != null && node2 != null) {
            return this.distance(node1, node2);
        }
        return NO_PATH;
    }

    public int distance(DependencyTree node1, DependencyTree node2) {
        DependencyTree anc = this.leastCommonAncestor(node1, node2);
        if (anc != null) {
            return node1._depth - anc._depth + node2._depth - anc._depth;
        }
        return NO_PATH;
    }

    public DependencyTree leastCommonAncestor(Token t1, Token t2) {
        DependencyTree node1 = this.findNode(t1);
        DependencyTree node2 = this.findNode(t2);
        if (node1 != null && node2 != null) {
            return this.leastCommonAncestor(node1, node2);
        }
        return null;
    }

    public DependencyTree leastCommonAncestor(DependencyTree node1, DependencyTree node2) {
        int leastDepth;
        DependencyTree[] path1 = node1.pathFromRoot();
        DependencyTree[] path2 = node2.pathFromRoot();
        for (int depth = leastDepth = Math.min(node1._depth, node2._depth); depth >= 0; --depth) {
            if (path1[depth] != path2[depth]) continue;
            return path1[depth];
        }
        return null;
    }

    public DependencyTree[] pathFromRoot() {
        DependencyTree[] result = new DependencyTree[this._depth + 1];
        for (DependencyTree current = this; current != null; current = current.parent()) {
            result[current._depth] = current;
        }
        return result;
    }

    public static DependencyTree load(ArrayList<Dependency> deps) {
        HashMap<String, DependencyTree> map = new HashMap<String, DependencyTree>();
        for (int i = 0; i < deps.size(); ++i) {
            String t2;
            DependencyTree dt2;
            Dependency d = deps.get(i);
            String t1 = d.first().toString();
            DependencyTree dt1 = (DependencyTree)map.get(t1);
            if (dt1 == null) {
                dt1 = new DependencyTree(null, d.first(), null);
                dt1.setEntriesMap(map);
                map.put(t1, dt1);
            }
            if ((dt2 = (DependencyTree)map.get(t2 = d.second().toString())) == null) {
                dt2 = new DependencyTree(null, d.second(), null);
                dt2.setEntriesMap(map);
                map.put(t2, dt2);
            }
            dt1.addChild(dt2);
            dt2.setParent(dt1);
            dt2.setType(d.type());
        }
        DependencyTree root = null;
        for (DependencyTree current : map.values()) {
            if (current.parent() != null) continue;
            root = current;
            root.populateDepth(1);
            break;
        }
        return root;
    }

    private void populateDepth(int depth) {
        this._depth = depth;
        for (int i = 0; i < this._children.size(); ++i) {
            this._children.get(i).populateDepth(depth + 1);
        }
    }
}

