/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.cmu.cs.lti.relationFilter.DependencyTree;
import edu.cmu.cs.lti.relationFilter.FilterFunction;
import edu.cmu.cs.lti.relationFilter.Relation;
import edu.cmu.cs.lti.relationFilter.SentenceData;
import edu.cmu.cs.lti.relationFilter.Token;

public class DependencyDistanceFilter
implements FilterFunction {
    private int _maxDist;
    private int _minDist;
    private int _spanDist;
    private int _minDistOfNP1andNP2 = 99999;
    private int _maxDistOfNP1andNP2 = 0;
    private int _minDistOfNP1andVP = 99999;
    private int _maxDistOfNP1andVP = 0;
    private int _minDistOfNP2andVP = 99999;
    private int _maxDistOfNP2andVP = 0;

    public DependencyDistanceFilter(int minDist, int maxDist, int spanDist) {
        this._minDist = minDist;
        this._maxDist = maxDist;
        this._spanDist = spanDist;
    }

    @Override
    public boolean filter(SentenceData s, Relation r) {
        DependencyTree tree = s.dependTree();
        if (tree == null) {
            return false;
        }
        this._minDistOfNP1andNP2 = Integer.parseInt(r._features.get(9));
        this._maxDistOfNP1andNP2 = Integer.parseInt(r._features.get(10));
        this._minDistOfNP1andVP = Integer.parseInt(r._features.get(11));
        this._maxDistOfNP1andVP = Integer.parseInt(r._features.get(12));
        this._minDistOfNP2andVP = Integer.parseInt(r._features.get(13));
        this._maxDistOfNP2andVP = Integer.parseInt(r._features.get(14));
        return this._minDistOfNP1andNP2 <= this._minDist && this._maxDistOfNP1andNP2 <= this._maxDist && this._maxDistOfNP1andNP2 - this._minDistOfNP1andNP2 <= this._spanDist && this._maxDistOfNP1andVP - this._minDistOfNP1andVP <= this._spanDist;
    }

    private int getMinDistance(DependencyTree tree, Token[] e1, Token[] e2) {
        int minDist = 99999;
        for (int i = 0; i < e1.length; ++i) {
            for (int j = 0; j < e2.length; ++j) {
                int distance;
                Token t1 = e1[i];
                Token t2 = e2[j];
                if (t1._position == -1 || t2._position == -1 || minDist <= (distance = tree.distance(t1, t2))) continue;
                minDist = distance;
            }
        }
        return minDist;
    }

    private int getMaxDistance(DependencyTree tree, Token[] e1, Token[] e2) {
        int maxDist = 0;
        for (int i = 0; i < e1.length; ++i) {
            for (int j = 0; j < e2.length; ++j) {
                int distance;
                Token t1 = e1[i];
                Token t2 = e2[j];
                if (t1._position == -1 || t2._position == -1 || maxDist >= (distance = tree.distance(t1, t2))) continue;
                maxDist = distance;
            }
        }
        return maxDist;
    }
}

