/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;

public class DEPServer {
    private boolean DEBUG = true;
    private final ServerSocket LISTENER;
    private LexicalizedParser DEP;
    private static final String USAGE = "Transtac Nov 2008 Eval: English Dependency Parser Server\nUsage: DEPServer -loadModel [path_to_your_model] portNumber\nExample: java -mx700m -cp 'stanford-parser.jar:' DEPServer -loadModel englishFactored.ser.gz 1234\nTest server by: telnet localhost 1234 ; then enter a sentence\n";

    public DEPServer(int port, LexicalizedParser asc) throws IOException {
        this.DEP = asc;
        this.LISTENER = new ServerSocket(port);
    }

    public DEPServer(int port, String model) throws IOException {
        this.DEP = new LexicalizedParser(model);
        this.DEP.setOptionFlags("-maxLength", "120", "-outputFormatOptions", "basicDependencies");
        this.LISTENER = new ServerSocket(port);
        System.out.println("[DEPServer] is ready at port " + port);
    }

    public void run() {
        Socket client = null;
        while (true) {
            try {
                while (true) {
                    client = this.LISTENER.accept();
                    if (this.DEBUG) {
                        System.out.println("[DEPServer] Accepted request from " + client.getInetAddress().getHostName());
                    }
                    new Session(client);
                }
            }
            catch (Exception e1) {
                System.err.println("[DEPServer] couldn't accept");
                e1.printStackTrace(System.err);
                try {
                    client.close();
                    continue;
                }
                catch (Exception e2) {
                    System.err.println("[DEPServer] couldn't close client");
                    e2.printStackTrace(System.err);
                    continue;
                }
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        String loadFile = props.getProperty("loadModel");
        String portStr = props.getProperty("");
        if (portStr == null || portStr.equals("")) {
            System.err.println(USAGE);
            System.exit(1);
        }
        if (loadFile != null && !loadFile.equals("")) {
            String model = loadFile;
        } else {
            String model = "englishFactored.ser.gz";
        }
        int port = 0;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            System.err.println("Non-numerical port");
            System.err.println(USAGE);
            System.exit(1);
        }
        new DEPServer(port, loadFile).run();
    }

    private class Session
    extends Thread {
        private Socket client;
        private BufferedReader in;
        private PrintWriter out;

        private Session(Socket socket) throws IOException {
            this.client = socket;
            this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            this.out = new PrintWriter(this.client.getOutputStream());
            this.start();
        }

        @Override
        public void run() {
            if (DEPServer.this.DEBUG) {
                System.out.println("[DEPServer] Created new session");
            }
            String input = null;
            try {
                input = this.in.readLine();
                if (DEPServer.this.DEBUG) {
                    System.out.println("[DEPServer] Receiving: \"" + input + "\"");
                }
            }
            catch (IOException e) {
                System.err.println("[DEPServer] Session: couldn't read input");
                e.printStackTrace(System.err);
            }
            catch (NullPointerException npe) {
                System.err.println("[DEPServer] Session: connection closed by peer");
                npe.printStackTrace(System.err);
            }
            if (input != null) {
                String[] sent = input.split(" ");
                Tree parse = DEPServer.this.DEP.apply(Arrays.asList(sent));
                PennTreebankLanguagePack tlp = new PennTreebankLanguagePack();
                GrammaticalStructureFactory gsf = tlp.grammaticalStructureFactory();
                GrammaticalStructure gs = gsf.newGrammaticalStructure(parse);
                Collection<TypedDependency> tdl = gs.typedDependenciesCollapsed();
                String compact = tdl.toString();
                TreePrint tp0 = new TreePrint("wordsAndTags");
                StringWriter wt = new StringWriter();
                PrintWriter pwt = new PrintWriter(wt);
                tp0.printTree(parse, pwt);
                String wordtag = wt.toString();
                if (DEPServer.this.DEBUG) {
                    System.out.println("[DEPSever] Sending: \n" + wordtag);
                }
                TreePrint tp = new TreePrint("dependencies");
                StringWriter wr = new StringWriter();
                PrintWriter pw = new PrintWriter(wr);
                tp.printTree(parse, pw);
                String dep = wr.toString();
                if (DEPServer.this.DEBUG) {
                    System.out.println("[DEPSever] Sending: \n" + dep);
                }
                TreePrint tp1 = new TreePrint("penn");
                StringWriter wr1 = new StringWriter();
                PrintWriter pw1 = new PrintWriter(wr1);
                tp1.printTree(parse, pw1);
                String syntac = wr1.toString();
                if (DEPServer.this.DEBUG) {
                    System.out.println("[DEPSever] Sending: \n" + syntac);
                }
                TreePrint tp2 = new TreePrint("typedDependencies", "basicDependencies", tlp);
                StringWriter wr2 = new StringWriter();
                PrintWriter pw2 = new PrintWriter(wr2);
                tp2.printTree(parse, pw2);
                String typedep = wr2.toString();
                if (DEPServer.this.DEBUG) {
                    System.out.println("[DEPSever] Sending: \n" + typedep);
                }
                String output = wordtag + syntac + dep + typedep;
                if (DEPServer.this.DEBUG) {
                    System.out.println("[DEPSever] Sending: \n" + output);
                }
                this.out.print(output);
                this.out.flush();
                wr.flush();
                wt.flush();
                wr1.flush();
                wr2.flush();
            }
            this.close();
        }

        private void close() {
            try {
                this.in.close();
                this.out.close();
                this.client.close();
            }
            catch (Exception e) {
                System.err.println("[DEPServer] Session: can't close session");
                e.printStackTrace(System.err);
            }
        }
    }
}

