/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.lti.relationFilter;

import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DEPClient {
    private static final String USAGE = "Transtac Nov 2008 Eval: English Dependency Parser Client\nUsage: DEPClient -host [server name] -port [portNumber] -infile [English text file] -outCoNLL [write Dependency tree to this file in CoNLL format]\nExample: java -mx700m -cp 'stanford-parser.jar:' DEPClient -host localhost -port 1234 -infile English";

    private static void communicateWithDEPServer(String host, int port, String inputStr, String outCoNLL) throws IOException {
        if (host == null) {
            host = "localhost";
        }
        BufferedWriter outfile = null;
        if (outCoNLL != "") {
            try {
                outfile = new BufferedWriter(new FileWriter(outCoNLL));
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (inputStr == null || inputStr.equals("")) {
            String userInput;
            BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Input some text and press RETURN to POS tag it, or just RETURN to finish.");
            while ((userInput = stdIn.readLine()) != null && !userInput.matches("\\n?")) {
                try {
                    Socket socket = new Socket(host, port);
                    PrintWriter out2 = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream()), true);
                    BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    out2.println(userInput);
                    String line = "";
                    while ((line = in.readLine()) != null) {
                        System.out.println(line);
                    }
                    in.close();
                    socket.close();
                }
                catch (UnknownHostException e) {
                    System.err.print("Cannot find host: ");
                    System.err.println(host);
                    return;
                }
                catch (IOException e) {
                    System.err.print("I/O error in the connection to: ");
                    System.err.println(host);
                    return;
                }
            }
            stdIn.close();
        } else {
            try {
                String userInput;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(inputStr)));
                while ((userInput = bufferedReader.readLine()) != null) {
                    try {
                        Socket socket = new Socket(host, port);
                        PrintWriter out3 = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream()), true);
                        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        out3.println(userInput);
                        String[] sent = userInput.split(" ");
                        int[] dv = new int[Arrays.asList(sent).size()];
                        for (int i = 0; i < Arrays.asList(sent).size(); ++i) {
                            dv[i] = 0;
                        }
                        String line = "";
                        while ((line = in.readLine()) != null) {
                            if (outCoNLL == null || outCoNLL.equals("")) {
                                System.out.println(line);
                                continue;
                            }
                            String patternStr = "^(.+?)\\((.*)\\-(\\d+)\\,(.*)\\-(\\d+)\\)$";
                            Pattern pattern = Pattern.compile(patternStr);
                            Matcher matcher = pattern.matcher(line);
                            boolean matchFound = matcher.find();
                            if (!matchFound) continue;
                            dv[Integer.parseInt((String)matcher.group((int)5)) - 1] = Integer.parseInt(matcher.group(3));
                        }
                        if (outCoNLL != "") {
                            try {
                                for (int i = 0; i < Arrays.asList(sent).size(); ++i) {
                                    int j = i + 1;
                                    outfile.write(j + "\t" + sent[i] + "\t_\t_\t_\t_\t" + dv[i] + "\t_\t_\t_\n");
                                }
                                outfile.write("\n");
                            }
                            catch (IOException e) {
                                System.err.print("Cannot write to file " + outCoNLL);
                                return;
                            }
                        }
                        in.close();
                        socket.close();
                    }
                    catch (UnknownHostException e) {
                        System.err.print("Cannot find host: ");
                        System.err.println(host);
                        return;
                    }
                    catch (IOException e) {
                        System.err.print("I/O error in the connection to: ");
                        System.err.println(host);
                        return;
                    }
                }
                bufferedReader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (outfile != null) {
            outfile.close();
        }
    }

    public static void main(String[] args) throws Exception {
        String portStr;
        Properties props = StringUtils.argsToProperties(args);
        String hostStr = props.getProperty("host");
        if (hostStr == null || hostStr.equals("")) {
            System.err.println(USAGE);
            System.exit(1);
        }
        if ((portStr = props.getProperty("port")) == null || portStr.equals("")) {
            System.err.println(USAGE);
            System.exit(1);
        }
        int port = 0;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            System.err.println("Non-numerical port");
            System.err.println(USAGE);
            System.exit(1);
        }
        String inputStr = props.getProperty("infile");
        String outCoNLL = props.getProperty("outCoNLL");
        if (outCoNLL == null || outCoNLL.equals("")) {
            outCoNLL = "";
        }
        DEPClient.communicateWithDEPServer(hostStr, port, inputStr, outCoNLL);
    }
}

