///////////////////////////////////////////////////////
//
// Filename: swpwm.c
// Author: Kwanjee Ng/kwanjee@andrew.cmu.edu
//
// Software PWM test
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "pwm.h"

char inval;
char intr_count = 0;

// hardware pwm control variables
char ccpcon;
char dc_vel[2] = {0,0};

void interrupt(void) {

	// if inval = 0, output will always be 0.
    if (intr_count < inval) {
        // PWM hi
        clear_bit(PORTB, 4);
    }
    else {
        // PWM lo
        set_bit(PORTB, 4 );
    }
	
    intr_count++;
	// this should roll over from 255 to 0.

    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void main(void) {
	set_bit( STATUS, RP0 );
   	OPTION_REG = 0x00; // set pre_scaler to 1:1
   	TRISB = 0; // port B as outputs
   	TRISD = 0; // prot D as outputs
    
   	clear_bit( STATUS, RP0 );
   	PORTB = 0;
   	PORTD = 0;

	// init...
   	inval = 0; intr_count = 0;
	ser_init();
	init_pwm();

   	enable_interrupt( GIE );
   	enable_interrupt( T0IE );  //enable TMR0 overflow bit

	//Set Phase of Motors
	set_bit(PORTB, 5);
    set_bit(PORTB, 1);

	putstring("Software PWM test\r");
	while (1) {
		putstring("Vel? ");
		inval = getdec();
		pwm_setvel(0,inval);
	}
}

