///////////////////////////////////////////////////////
//
// FileName: sui.c
// Author: kwanjee@andrew.cmu.edu
//
// Serial user interface (implementing v0.2)
//
////////////////////////////////////////////////////////

//#opt 9

#include <16f877.h>
#include "877reg.h"
#include "sercomm.h"
#include "sersoft.h"
#include "servo.h"
#include "adc.h"
#include "pwm.h"
#include "i2cm.h"

#define VERSION_STR "Cerebellum Serial Interface v0.9b "

#define BUFMAX 50

#define RETCHAR 13

#define I2C_PREFIX 0xf8

#define SIGN_POS 0
#define SIGN_NEG 1
#define SIGN_NONE 2

char buf[BUFMAX];
char bufcnt;
char bufptr;
char servo_buf[8];
char proc_err;

void main(void) {
	char inp, num;

	TSB3 = 0;
	TSB2 = 0; // RB2 as output
	RB2 = 0;
	TSB1 = 0;
	RB1 = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	sersoft_init(); // init software serial port
	pwm_init(); // initialize CCP module
	servo_init();
	i2c_init();
	adc_init(0); // all channels analog, output MSBs

	servo_state = 1; // activate servo driver

	GIE = 1;

	inp = read_eeprom(TO_ADDR);
	if (inp != 255) to_val = inp;
	
	show_info();

	//ser_tx('O'); ser_tx('K'); ser_tx('\r');
	my_putc('O'); my_putc('K'); my_putc('\r');
	while (1) {
		getbuf();
		procbuf();
	}

/*	putc('!');	
	while (1) {
		num = my_getc();
		while(servo_free);
		while (!servo_free);
		putc(num);
	}*/

}

