///////////////////////////////////////////////////////
//
// FileName: rover.c
// Author: kwanjee@andrew.cmu.edu
//
// Personal Rover platform test
//
////////////////////////////////////////////////////////

//#opt 9

#include <16f877.h>
#include "877reg.h"
#include "sercom2.h"
#include "sersoft.h"
#include "servo.h"
#include "adc.h"
#include "pwm.h"
#include "i2cm.h"
#include "db.h"

void main(void) {
	char inp, num;
	char inp0, inp1, inp2, inp3;

	TSB3 = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	sersoft_init(); // init software serial port
	pwm_init(); // initialize CCP module
	servo_init();
	i2c_init();
	adc_init(0); // all channels analog, output MSBs

	servo_state = 1; // activate servo driver

	GIE = 1;

	sw_putc("db test\r");
	sw_getc();
	
//	inp = db_set_vel(0, 0);
//	sw_putdec(inp); 
//	inp = db_set_vel(1, 0);
//	sw_putdec(inp); 
//	inp = db_set_vel(2, 0);
//	sw_putdec(inp); 
	inp = db_set_vel(0, 0);
	sw_putdec(inp);
	
	sw_putc('\r');
	
//	inp = db_controller_on(0);
//	sw_putdec(inp); sw_putc(' ');
//	inp = db_controller_on(1);
//	sw_putdec(inp); sw_putc(' ');
//	inp = db_controller_on(2);
//	sw_putdec(inp); sw_putc(' ');
	inp = db_controller_on(0);
	sw_putdec(inp); sw_putc('\r');
	
	sw_putc("holding 0\r");
	sw_getc();
	
	while (1) {	
		sw_putc("speed?");
		inp = sw_getdec();
//		inp0 = db_set_vel(0,inp);
//		inp1 = db_set_vel(1,inp);
//		inp2 = db_set_vel(2,inp);
		inp3 = db_set_vel(0,inp);
//		sw_putdec(inp0); sw_putc(' ');
//		sw_putdec(inp1); sw_putc(' ');
//		sw_putdec(inp2); sw_putc(' ');
		sw_putdec(inp3); sw_putc('\r');
	}
}

