// PIC 16F877 Hardware PWM routines using the CCP module
//
// Runs at 19.5 kHz by default

#ifndef _PWM_H_
#define _PWM_H_

#define DC1_DIR RC5
#define DC2_DIR RC0

// hardware pwm control variables
char ccpcon;
char dc_vel[2] = {0,0};

// function prototypes
void pwm_init(void);
void pwm_setvel8(char n, char d, char c);
void pwm_setvel10(char n, char d, char ch, char cl);

void pwm_init(void) {
	
	// init hardware PWM
	CCP1CON = 0; // CCP off
	CCP2CON = 0;
	TMR2 = 0;
	PR2 = 0xff; // 0x3f: 78kHz, 0xff: 19.5kHz
	CCPR1L = 255; // output is inverted, so this means stop
	CCPR2L = 255;
	TRISC = TRISC & 0b11011000; // set DC motor pins to output
	
	ccpcon = 0b00111100; // setup reg mask
	
	CCP1CON = ccpcon; // CCP module to PWM mode
	CCP2CON = ccpcon;

	TMR2ON = 1;
}

void pwm_setvel8(char n, char d, char c) {
	if (n == 0) {
		if (d == 0) DC1_DIR = 1;
		else DC1_DIR = 0;
		CCPR1L = (~c);
	}
	else if (n==1) {
		if (d == 0) DC2_DIR = 1;
		else DC2_DIR = 0;
		CCPR2L = (~c);
	}
}

void pwm_setvel10(char n, char d, char ch, char cl) {
	if (n == 0) {
		if (d == 0) DC1_DIR = 1;
		else DC1_DIR = 0;
		cl = cl >> 2;
		CCP1CON = (~cl) & ccpcon;
		CCPR1L = (~ch);
	}
	else if (n==1) {
		if (d == 0) DC2_DIR = 1;
		else DC2_DIR = 0;
		cl = cl >> 2;
		CCP2CON = (~cl) & ccpcon;
		CCPR2L = (~ch);
	}
}


#endif