///////////////////////////////////////////////////////
//
// FileName: pid.c
// Author: kwanjee@andrew.cmu.edu
//
// Closed loop control test
// 10-bit PWM resolution
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "pwm.h"
#include "encoder.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

char ah, al;
char bh, bl;
char xh, xl;
char mulcount;
char mulstat;
char modYl, modYh;
char sigY;

// xh:xl = - ah:al
void neg16(void) {
	al = ~ al;
	ah = ~ ah;
	al++;
	if (STATUS & 1) ah++;
}

// calculates ah:al - bh:bl
void sub16(void) {
	xl = al - bl;
	if (~STATUS & 1) xh = 0xff;
	else xh = 0;
	xh = xh - ah - bh;
}

// calculates ah:al + bh:bl
void add16(void) {
	xl = al + bl;
	if (STATUS & 1) xh = 1;
	else xh = 0;
	xh = xh + ah + bh;
}

// al * bl = xh:xl, signed
void mult_8(void) {

	xh = al ^ bl;
	if (xh & 0x80) mulstat = 1;
	else mulstat = 0;

	if (al > 127) al = 0-al;
	if (bl > 127) bl = 0-bl;

asm {
	movlw	8
	movwf	_mulcount
	movf	_al,W
	movwf	_xl
	movf	_bl,W
	clrf	_xh
mul_loop
	bcf		STATUS,C
	btfsc	_xl,0
	addwf	_xh,F
	rrf		_xh,F
	rrf		_xl,F
	decfsz	_mulcount,F
	goto	mul_loop
}
	
	if (mulstat == 1) {
		xl = ~xl;
		xh = ~xh;
		xl = xl + 1;
		if (STATUS & 1) {
			xh = xh + 1;
		}
	}

	return;
}

void main(void) {
	char vel; // desired velocity
	char v; // instantaneous velocity
	char dv; // proportional error in velocity
	char pdv; // previous proportional error
	char d2v; // change in proportional error
	char sdvh, sdvl; // sum of proportional error
	char Yh, Yl; // PID output
	char Kp; // P term constant
	char Kd; // D term constant
	char Ki; // I term constant

	OPTION_REG = 0x05; // TMR0 @ 1:64, prescaler to timer0 (pid loop freq)

	TRISB = 0; // port B as outputs
    TRISD = 0xff; // port D as inputs
    
    PORTB = 0;

	// init...
	ser_init(); // init rs-232 comms
	pwm_init(); // initialize CCP module
	enc_init(); // initialize encoder counter chip	

	putstring("\rVelocity control test\r");
	
	vel = 0;
	dv = 0;
	sdvh = 0;
	sdvl = 0;
	Kp = 16;
	Ki = 6;
	Kd = 16;

	putstring(" Vel>");
	vel = getdec();
	
	while (1) {
		set_bit(PORTB,0);

		// 16 bit signed arithmetic!!!!!

		v = enc_read_8();
		enc_reset();

		pdv = dv;
		dv = vel - v;

		d2v = dv - pdv;

/*		ah = sdvh; al = sdvl;
		bl = dv;
		if (bh & 0x80) bh = 0xff; // sign extend dv
		else bh = 0;
		add16();
		sdvh = xh; sdvl = xl;*/

		// saturating adder for sdvl
		sdvh = sdvl + dv;
		if (!((sdvl ^ dv) & 0x80)) {
			// overflow possible
			if ((sdvh ^ sdvl) & 0x80) {
				// overflow!
				if (sdvh & 0x80) {
					// too positive
					sdvh = 0x7f;
				}
				else {
					// too negative
					sdvh = 0x81;
				}
			}
		}
		sdvl = sdvh;

		//Y = Kp * dv;
		al = Kp; bl = dv; 
		mult_8();
		Yh = xh; Yl = xl;

		al = Kd; bl = d2v;
		mult_8();
		ah = xh; al = xl;

		bh = Yh; bl = Yl;
		add16();
		// results in xh:xl

		Yh = xh; Yl = xl;
		al = sdvh; bl = Ki;
		mult_8();
		ah = xh; al = xl;

		bh = Yh; bl = Yl;
		add16();
		//results in xh:xl

/*		if ((xh == 0)&&(xl < 128)) {
			// Y < 8 bits, positive
			modY = xl << 1;
			sigY = 0;
		}
		else if ((xh == 0xff)&&(xl > 128)) {
			// Y < 8 bits, negative
			modY = ~xl + 1;
			modY = modY << 1;
			sigY = 1;
		}
		else if (xh & 0x80) {
			// Y negative, saturate
			modY = 255;
			sigY = 1;
		}
		else {
			// Y positive, saturate
			modY = 255;
			sigY = 0;
		}*/

		// saturate xh:xl to 10 bits magnitude
		// xh: chop off top 6 bits
		// if xh < 128, x is positive (sigY = 0)
		// else x is negative (sigY = 1, flip xl:xh)
		// at this point: xl:xh = magnitude. saturate it if necessary
		// if xh > 3, overflow, saturate
		// now, shift 2 bits right, setvel.

		if (xh < 128) {
			sigY = 0;
			modYh = xh;
			modYl = xl;
		}
		else {
			sigY = 1;
			modYh = ~xh;
			modYl = (~xl) + 1;
			if (STATUS & 1) {
				modYh++;
			}
		}
		if (modYh > 3) {
			modYh = 3;
			modYl = 255;
		}

/*		modYl = (xl & 0x03) << 6;
		modYh = (xl >> 2) & (xh << 6);

		modYh = modYh << 6;
		modYh = (modYl >> 6) | modYh;
		modYl = modYl << 6;*/

		asm {
		rrf		_modYh,F
		rrf		_modYl,F
		rrf		_modYh,F
		rrf		_modYl,F
		rrf		_modYh,F
		}

		modYh = modYh & 0xc0;

		pwm_setveldir10(0,modYl,modYh,sigY);

		putdec(v); ser_tx(' ');
		putdec(dv); ser_tx(' ');
		putdec(d2v); ser_tx(' ');
		putdec(sdvh); ser_tx(' ');
		puthex(xh); puthex(xl); ser_tx(' ');
		puthex(sigY); ser_tx(' ');
		puthex(modYl); puthex(modYh); ser_tx('\r');

		clear_bit(PORTB,0);

		while (TMR0 != 0);
	}
}

