///////////////////////////////////////////////////////
//
// FileName: nine.c
// Author: kwanjee@andrew.cmu.edu
//
// 2 channel hardware PWM
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

#define DC_PORT PORTB
#define DC1_ENB 4
#define DC1_DIR 5
#define DC2_ENB 2
#define DC2_DIR 1

char led = 0;

char ccpcon;
char dc1_vel;
char dc2_vel;
char dc_count;

void interrupt(void) {

    clear_wdt();

	dc_count++;	// pwm counter

	// this should roll over from 255 to 0.
    if( led<127 ) {
    	set_bit(BLINK_PORT, BLINK_PIN);
    }
    else {
        clear_bit(BLINK_PORT, BLINK_PIN);
    }
    led++;

    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void init_pwm(void) {
	
	// init hardware PWM
	CCP1CON = 0; // CCP off
	CCP2CON = 0;
	TMR2 = 0;
	PR2 = 0x3f; // 0x3f: 78kHz, 0xff: 19.5kHz
	CCPR1L = 0; // period = 0
	CCPR2L = 0;
	TRISC = TRISC & 11111001b; // set CCP pins to output
	
	ccpcon = 00001100b; // setup reg mask
	
	dc1_vel = 0;
	dc2_vel = 0;
	
	CCP1CON = ccpcon; // CCP module to PWM mode
	CCP2CON = ccpcon;

	set_bit(T2CON,TMR2ON);
}

void pwm1_setvel(char c) {
	char tmp;

	tmp = c & 0x03;
	tmp = tmp << 4;
	CCP1CON = tmp | ccpcon;

	CCPR1L = c >> 2;
}

void pwm2_setvel(char c) {
	char tmp;

	tmp = c & 0x03;
	tmp = tmp << 4;
	CCP2CON = tmp | ccpcon;

	CCPR2L = c >> 2;
}

void main(void) {
	char inp;

	OPTION_REG = 0x03; // set pre_scaler to 1:16
    TRISB = 0; // port B as outputs
    TRISD = 0; // port D as outputs
    
    PORTB = 0;
    PORTD = 0;

	ser_init(); // init rs-232 comms

	// init...
	init_pwm();
	
    enable_interrupt(GIE);
    enable_interrupt(T0IE);  //enable TMR0 overflow bit

	
	putstring("\rHardware PWM test\r");
	
	while (1) {
		putstring("Current settings: ");
		putdec(dc1_vel); ser_tx(' ');
		putdec(dc2_vel); ser_tx('\r');

		inp = ser_rx();

		if (inp == 'q') {
			// motor 1 inc
			dc1_vel = dc1_vel + 1;
			pwm1_setvel(dc1_vel);
		}
		else if (inp == 'a') {
			// motor 1 dec
			if (dc1_vel > 0) dc1_vel = dc1_vel - 1;
			pwm1_setvel(dc1_vel);
		}
		else if (inp == 'w') {
			// motor 2 inc
			if (dc2_vel < 255) dc2_vel = dc2_vel + 1;
			pwm2_setvel(dc2_vel);
		}
		else if (inp == 's') {
			// motor 2 dec
			dc2_vel = dc2_vel - 1;
			pwm2_setvel(dc2_vel);
		}
	}
}

