/*
 *  
 * I2C slave mode routines
 *
 */
 
#ifndef _I2CM_H_
#ifndef _I2CS_H_
#define _I2CS_H_

#define I2C_SLAVE_READ 0
#define I2C_SLAVE_WRITE 1
#define I2C_MASTER_ACK 0
#define I2C_MASTER_NACK 1
#define I2C_DATA_READ 2
#define I2C_STOP 255

char i2c_tmp;
char i2c_data;

// initializes MSSP for I2C
void i2c_init(char addr) {
	
	// enable SSP, I2C slave mode, 7 bit addr
	SSPCON = 0b00110110;
	SSPADD = addr << 1; // UNDOCUMENTED!!!!!
	
	// slew rate control enabled, i2c spec input levels
	SSPSTAT = 0;

	// I/O pins as inputs (RC3,4)
	//TRISC |= 0x18;
	TSC3 = 1;
	TSC4 = 1;
}

// slave receive
char i2c_rx(void) {
	while (!SSPIF);
	SSPIF = 0;

	if (SSPOV) {
		ser_tx('*');
		SSPOV = 0;
	}
		
	if (RW) { // check R/W bit
		// if he wants to read, we have to write
		// CKP cleared in hardware to stall for time
		return I2C_SLAVE_WRITE;
	}
	else {
		// master write, slave read
		
		// this is either our address or the incoming data
		// either way, must clear it to prevent SSPOV
		i2c_data = SSPBUF; 
		if (DA) {
			// just got the incoming data
			return I2C_DATA_READ;
		}
		else {
			// just got address with write command
			// exit, then get called again to rx incoming data
			
			return I2C_SLAVE_READ;
		}
	}
}

// transmit data
// returns 1 if master NACK, else returns 0
char i2c_tx(char data) {
	
	SSPBUF = data; // send data

	CKP = 1;

	while (!SSPIF); // wait for tx to finish
	SSPIF = 0;
	
	// if R/W == 0, master says NACK
	if (RW) {
		return I2C_MASTER_ACK;
	}
	else {
		return I2C_MASTER_NACK;
	}
}

#endif
#endif
