///////////////////////////////////////////////////////
//
// FileName: exp1.c
// Author: kwanjee@andrew.cmu.edu
//
// Experiment 2
// Gear motors give better resolution response
// Without gearing, motor gives very high back emf 
// immediately after switch-off, leading to resolution
// problems.
//
////////////////////////////////////////////////////////


#include <16f877.h>
#include "877reg.h"
#include "sercomm.h"
//#include "sersoft.h"
#include "servo.h"
#include "adc.h"
#include "pwm.h"
#include "i2cm.h"

char getdec(void) {
	char i=0;
	
	ser_tmp = 0;
	
	while ((ser_tmp != '\n')&&(ser_tmp != '\r')) {
		ser_tmp = ser_rx();
	
		if ((ser_tmp > 47)&&(ser_tmp < 58)) {
			// it's a digit!
			i = i * 10;
			ser_tmp = ser_tmp - '0';
			i = i + ser_tmp;
		}
	} 
	
	return i;
}

void main(void) {
	char inp, num;

	TSB3 = 0;
	TSB2 = 0; // RB2 as output
	RB2 = 0;
	TSB1 = 0;
	RB1 = 0;

	// init...
	//sersoft_init(); // init software serial port
	ser_init(SER_115200);
	servo_init();
	pwm_init(); // initialize CCP module
	adc_init(0); // all channels analog, output MSBs

	while (1) {
		RB2 = 1;
		ser_tx("speed: ");
		inp = getdec();
	
		pwm_setvel8(0,0,inp);
		ser_tx("running...");
		inp = ser_rx();
		
		RB2 = 0;
		pwm_setvel8(0,0,0);
		ser_tx("stopped\r");
		inp = ser_rx();
	}
}

