/*
 *  Quadrature counting using up down counters
 *  Timer0 for Up count, Timer1 for Down count
 */

#ifndef _ENCUPDN_H_
#define _ENCUPDN_H_

#include "877reg.h"

char TMR0H;
char enc_h, enc_l;
// snapshot counter values
char up_h, up_l, dn_h, dn_l;
char enc_tmp;

char _enc_swap;
#bit enc_swap = _enc_swap.0

#INT_RTCC
void tmr0intr(void) {
	TMR0H++;
	T0IF = 0;
}

void enc_init(void) {
	
	// activate timer 1,
	// 1:1 prescale, osc off, use external clk, don't synchronize
	T1CON = 0x07;
	//set_bit(TRISC,0); // up input
	TSC0 = 1;
	
	// activate timer 0,
	// transition on external input, inc on posedge, 1:1 prescale
	OPTION_REG &= 0xE8;
	PSA = 1;
	T0CS = 1;

	// default to no swap
	enc_swap = 0;
	
    //enable_interrupt(T0IE);  //enable tmr0 overflow interrupt
    T0IE = 1;
}

char enc_read(void) {	
	// encoder reading = upcount - downcount
	enc_tmp = ~dn_h;
	while (enc_tmp != dn_h) {
		dn_h = TMR1H;
		dn_l = TMR1L;
		enc_tmp = TMR1H;
	}	

	//up_h = TMR0H; up_l = TMR0;
	enc_tmp = ~up_h;
	while (enc_tmp != up_h) {
		up_h = TMR0H;
		up_l = TMR0;
		enc_tmp = TMR0H;
	}	
	
	// swap?
	if (enc_swap) {
		enc_tmp = up_h;
		up_h = dn_h;
		dn_h = enc_tmp;
		
		enc_tmp = up_l;
		up_l = dn_l;
		dn_l = enc_tmp;
	}

	// 16bit subtraction
	enc_l = up_l - dn_l;
	if (!CARRY) up_h--;
	enc_h = up_h - dn_h;

	return enc_l;
}

void enc_reset(void) {
	T1CON &= 0xFE; // timer1 OFF
	TMR1L = 0;
	TMR1H = 0;
	TMR0 = 0;
	TMR0H = 0;
	T1CON |= 0x01; // timer1 ON
}

#endif