// PIC 16F877 Hardware PWM routines using the CCP module
//
// Runs at 19.5 kHz by default

#ifndef _DBPWM_H_
#define _DBPWM_H_

//#define DC_PORT PORTC
#define DC1_DIR RC1

// hardware pwm control variables
char ccpcon;
char dc_vel = 0;

void pwm_init(void) {
	
	// init hardware PWM
	CCP1CON = 0; // CCP off
	TMR2 = 0;
	PR2 = 0xff; // 0x3f: 78kHz, 0xff: 19.5kHz
	CCPR1L = 255; // output is inverted, so this means stop
	TSC1 = 0; // set DC motor pins to output
	TSC2 = 0;
	
	ccpcon = 0b00111100; // setup reg mask
	
	CCP1CON = ccpcon; // CCP module to PWM mode

	TMR2ON = 1;
}

// ch:cl is 10 bits wide, left justified
void pwm_setvel(char d, char ch, char cl) {
	if (d == 0) DC1_DIR = 1;
	else DC1_DIR = 0;
	cl = cl >> 2;
	CCP1CON = (~cl) & ccpcon;
	CCPR1L = (~ch);
}

/*
void init_pwm(void) {
	
	// init hardware PWM
	CCP1CON = 0; // CCP off
	CCP2CON = 0;
	TMR2 = 0;
	PR2 = 0x3f; // 0x3f: 78kHz, 0xff: 19.5kHz
	CCPR1L = 255; // output is inverted, so this means stop
	CCPR2L = 255;
	TRISC = TRISC & 11111001b; // set CCP pins to output
	
	ccpcon = 00001100b; // setup reg mask
	
	CCP1CON = ccpcon; // CCP module to PWM mode
	CCP2CON = ccpcon;

	set_bit(T2CON,TMR2ON);
}

void pwm_setvel(char n, char c) {
	char tmp;

	tmp = (~c) & 0x03;
	tmp = tmp << 4;

	if (n == 0) {
		CCP1CON = tmp | ccpcon;
		CCPR1L = (~c) >> 2;
	}
	else if (n==1) {
		CCP2CON = tmp | ccpcon;
		CCPR2L = (~c) >> 2;
	}
}
*/

#endif