///////////////////////////////////////////////////////
//
// FileName: First.c
// Author: Kwanjee Ng/kwanjee@andrew.cmu.edu
//
// Program Description:
//    This program uses our PIC 16F84 to drive a DC Motor
//  using the reading from a Potentiometer off of the
//  Analog to Digital converter at ADCON1.
//    It does this by first sending out, using an LED array
//  the current digital value, and transmits this as a variable
//  power using the main method.
//
// Program History:
//    4/14/2001: Operational
//        Currently using the main program to run DC Motor
// Future Plans:
//    Set up the motor driver to use interrupts rather than
//  call the main program.
//
// Known Bugs:
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"

char inval;
char led = 1;
char intr_count = 0;
char wait = 0;

void interrupt(void) {
	// assume it's a timer0 interrupt
	// work on multiplexing this function later.

    intr_count++;
	// this should roll over from 255 to 0.

    if( led == 1 ) {
        output_high_port_b( 1 );
        led = 0;
    }
    else {
        output_low_port_b( 1 );
        led = 1;
    }

    clear_wdt();
    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void main(void) {
    char i;

    set_bit( STATUS, RP0 );
    // if POR is 0, ->POR, set POR
    if ((PCON & 0x2)==0) set_bit( PCON, 1 );

    OPTION_REG = 0x07; // set pre_scaler to 1:256
    TRISB = 0; // port B as outputs
    TRISD = 0; // port D as outputs
    
    clear_bit( STATUS, RP0 );
    //PORTB = 0;
    PORTC = 0;

    PORTB = 1;
    delay_us(255);

	// init...
    inval = 0; intr_count = 0; led = 0;
	
    enable_interrupt( GIE );
    enable_interrupt( T0IE );  //enable TMR0 overflow bit

    PORTB = 0;

	while (1) {
        PORTD = TMR0;
    }
}

