///////////////////////////////////////////////////////
//
// Filename: seven.c
// Author: Kwanjee Ng/kwanjee@andrew.cmu.edu
//
// Program Description:
// Control loop testbed for multiple DC motors
//
// Unreliable. Works, but screwson edge cases.
// Interrupt processing time seems small.
// Logic gets exponentially more complicated when more
// motors are added. Not feasible.
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

#define DC_PORT PORTB
#define DC1_ENB 4
#define DC1_DIR 5
#define DC2_ENB 2
#define DC2_DIR 1

char dc1_vel = 0;
char dc2_vel = 0;
char dc_count = 0;
char dc_mask = 0;
char new_tmr0;
char led = 1;
char wait = 0;

void interrupt(void) {
	// assume it's a timer0 interrupt
	// work on multiplexing this function later.

    set_bit(PORTB, 0);
	// timer jump
	if (dc_count == 0) {
		// start of cycle
		new_tmr0 = 0; // reset...
		if (dc1_vel != 0) {
			clear_bit(DC_PORT,DC1_ENB);
			set_bit(dc_mask,0);
			new_tmr0 = dc1_vel; // switch me off!
		}
		if (dc2_vel != 0) {
			clear_bit(DC_PORT,DC2_ENB);
			set_bit(dc_mask,1);
			if (dc2_vel < new_tmr0) new_tmr0 = dc2_vel; // no, switch *me* off!
		}

		if (new_tmr0 != 0) {
			TMR0 = 255 - new_tmr0; // next interrupt in new_tmr0 ticks
			dc_count = new_tmr0;
		}
	}
	else {
		if (dc_count == dc1_vel) {
			set_bit(DC_PORT,DC1_ENB);
			clear_bit(dc_mask,0);
		}
		if (dc_count == dc2_vel) {
			set_bit(DC_PORT,DC2_ENB);
			clear_bit(dc_mask,1);
		}

		if (dc_mask == 10b) {
			// 1 off, 2 on
			new_tmr0 = dc2_vel - dc1_vel;
			TMR0 = 255 - new_tmr0;
			dc_count = dc_count + new_tmr0;
		}
		else if (dc_mask == 01b) {
			// 2 off, 1 on
			new_tmr0 = dc1_vel - dc2_vel;
			TMR0 = 255 - new_tmr0;
			dc_count = dc_count + new_tmr0;
		}
		else if (dc_mask == 0) {
			// both off
			TMR0 = dc_count;
			dc_count = 0;
		}
	}

/*	if( led ) {
        set_bit(PORTB, 0);
        led = 0;
    }
    else {
        clear_bit(PORTB, 0);
        led = 1;
    }*/

	clear_bit(PORTB, 0);
    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void main(void) {
	char mot, newvel;

	set_bit( STATUS, RP0 );
   	OPTION_REG = 0x03; // set pre_scaler to 1:16
   	TRISB = 0; // port B as outputs
   	TRISD = 0; // prot D as outputs
    
   	clear_bit( STATUS, RP0 );
   	PORTB = 0;
   	PORTD = 0;

	// init...
    led = 0;
	
	ser_init();

    enable_interrupt( GIE );
    enable_interrupt( T0IE );  //enable TMR0 overflow bit

	//set both motors to same dir
	set_bit(DC_PORT,DC1_DIR);
	set_bit(DC_PORT,DC2_DIR);

	//both motors initally stop
	set_bit(DC_PORT,DC1_ENB);
	set_bit(DC_PORT,DC2_ENB);

	putstring("Hi.\r");

	// user interface
	while (1) {

		putstring("M?");
		mot = ser_rx();
		ser_tx('\r');
		putstring("M");
		mot = mot - 48;
		putdec(mot);
		putstring(" V?");
		newvel = getdec();

		if (mot == 1) {
			dc1_vel = newvel;
		}
		if (mot == 2) {
			dc2_vel = newvel;
		}
	}
}

