///////////////////////////////////////////////////////
//
// FileName: robocat.c
// Author: kwanjee@andrew.cmu.edu
//
// Robocat control program
// Simple wall avoidance
// Servo-steering, rear-wheel drive
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "adc.h"
#include "servo.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

#define SENSL 0
#define SENSF 1
#define SENSR 2

void interrupt(void) {

	if (servo_state == 1) {
		// next intr in 0.6 ms
		TMR0 = 180;

		if (servo_pos[servo_curr] != 0)
			SERVO_PORT = SERVO_PORT | servo_switch; // output hi
		
		servo_switch = servo_switch << 1;
		if (servo_switch == 0) servo_switch = 1;
		
		servo_state = servo_state + 1;
		servo_count = 0;
	}
	else if (servo_state == 2) {
		TMR0 = 255 - servo_pos[servo_curr];
		servo_state = 3;
	}
	else if (servo_state == 3) {
		SERVO_PORT = 0; // output lo
		TMR0 = servo_pos[servo_curr];
		servo_curr = servo_curr + 1;
		servo_curr = servo_curr & 0x07;
		servo_state = 1;
	}

    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void main(void) {
	char inp, num;
	char f, l, r;
	char avg;

	// servo inits
	TRISB = 0; // port B as outputs
    
    PORTB = 0;
    PORTD = 0;

	// init...
	ser_init(); // init rs-232 comms
	pwm_init(); // initialize CCP module
	servo_init();
	ADCON1 = 0x00; // port A all analog, result left justified

	servo_state = 1; // activate servo driver

    enable_interrupt(GIE);

	putstring("\rRobocat!\r");
	
	// don't modulate speed first...
	pwm_setvel_dir(0,120,0);		

	while (1) {
		f = adc_read(SENSF);
		l = adc_read(SENSL);
		r = adc_read(SENSR);
		
		avg = (f >> 1) + (l >> 1) + (r >> 1);		
		// f/l/r: larger -> nearer -> slower
		
		dir = 161; // center steering servo
		
		if (r > thold) dir = dir - delta;
		if (l > thold) dir = dir + delta;
		
		// steering to new direction
		servo_pos[0] = dir;
	}
}

