///////////////////////////////////////////////////////
//
// FileName: pid.c
// Author: kwanjee@andrew.cmu.edu
//
// Closed loop control test
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "pwm.h"
#include "encoder.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

char ah, al;
char bh, bl;
char xh, xl;
char mulcount;
char mulstat;

// xh:xl = - ah:al
void neg16(void) {
	al = ~ al;
	ah = ~ ah;
	al++;
	if (STATUS & 1) ah++;
}

// calculates ah:al - bh:bl
void sub16(void) {
	xl = al - bl;
	if (~STATUS & 1) xh = 0xff;
	else xh = 0;
	xh = xh - ah - bh;
}

// calculates ah:al + bh:bl
void add16(void) {
	xl = al + bl;
	if (STATUS & 1) xh = 1;
	else xh = 0;
	xh = xh + ah + bh;
}

// al * bl = xh:xl, signed
void mult_8(void) {

	xh = al ^ bl;
	if (xh & 0x80) mulstat = 1;
	else mulstat = 0;

	if (al > 127) al = 0-al;
	if (bl > 127) bl = 0-bl;

asm {
	movlw	8
	movwf	_mulcount
	movf	_al,W
	movwf	_xl
	movf	_bl,W
	clrf	_xh
mul_loop
	bcf		STATUS,C
	btfsc	_xl,0
	addwf	_xh,F
	rrf		_xh,F
	rrf		_xl,F
	decfsz	_mulcount,F
	goto	mul_loop
}
	
	if (mulstat == 1) {
		xl = ~xl;
		xh = ~xh;
		xl = xl + 1;
		if (STATUS & 1) {
			xh = xh + 1;
		}
	}

	return;
}

void main(void) {
	char vel; // desired velocity
	char v; // instantaneous velocity
	char dv; // proportional error in velocity
	char pdv; // previous proportional error
	char d2v; // change in proportional error
	char sdvh, sdvl; // sum of proportional error
	char Yh, Yl; // PID output
	char modY, sigY;
	char Kp; // P term constant
	char Kd; // D term constant
	char Ki; // I term constant

	OPTION_REG = 0x05; // TMR0 @ 1:64, prescaler to timer0 (pid loop freq)

	TRISB = 0; // port B as outputs
    TRISD = 0xff; // port D as inputs
    
    PORTB = 0;

	// init...
	ser_init(); // init rs-232 comms
	pwm_init(); // initialize CCP module
	enc_init(); // initialize encoder counter chip	

	putstring("\rVelocity control test\r");
	
	vel = 0;
	dv = 0;
	sdvh = 0;
	sdvl = 0;
	Kp = 2;
	Kd = 2;
	Ki = 1;

/*	while (1) {
		putstring("X>");
		al = getdec();
		putstring("Y>");
		bl = getdec();
		mult_8();
		puthex(xh);
		puthex(xl);
		ser_tx('\r');
	}*/

/*	while (1) {
		putstring("Vel>");
		vel = getdec();
		if (vel & 0x80) {
			sigY = 1;
			modY = ~vel;
			modY++;		// modY now positive magnitude
			modY = modY << 1;
		}
		else {
			sigY = 0;
			modY = vel << 1;
		}

		pwm_setvel_dir(0,modY,sigY);
		enc_reset();
		delay_ms(1);
		v = enc_read_8();
		putdec(v);
		ser_tx('\r');
	}*/

/*	while (1) {
		putstring("sdvl>");
		sdvl = getdec();
		putstring("dv>");
		dv = getdec();

		sdvh = sdvl + dv;
		if (!((sdvl ^ dv) & 0x80)) {
			// overflow possible
			if ((sdvh ^ sdvl) & 0x80) {
				// overflow!
				if (sdvh & 0x80) {
					// too positive
					sdvh = 0x7f;
				}
				else {
					// too negative
					sdvh = 0x81;
				}
			}
		}
		puthex(sdvh); ser_tx('\r');
	}*/

	putstring(" Vel>");
	vel = getdec();
	
	while (1) {
		set_bit(PORTB,0);

		// 16 bit signed arithmetic!!!!!

		v = enc_read_8();
		enc_reset();

		pdv = dv;
		dv = vel - v;

		d2v = dv - pdv;

/*		ah = sdvh; al = sdvl;
		bl = dv;
		if (bh & 0x80) bh = 0xff; // sign extend dv
		else bh = 0;
		add16();
		sdvh = xh; sdvl = xl;*/

		// saturating adder for sdvl
		sdvh = sdvl + dv;
		if (!((sdvl ^ dv) & 0x80)) {
			// overflow possible
			if ((sdvh ^ sdvl) & 0x80) {
				// overflow!
				if (sdvh & 0x80) {
					// too positive
					sdvh = 0x7f;
				}
				else {
					// too negative
					sdvh = 0x81;
				}
			}
		}
		sdvl = sdvh;

		//Y = Kp * dv;
		al = Kp; bl = dv; 
		mult_8();
		Yh = xh; Yl = xl;

		al = Kd; bl = d2v;
		mult_8();
		ah = xh; al = xl;

		bh = Yh; bl = Yl;
		add16();
		// results in xh:xl

		Yh = xh; Yl = xl;
		al = sdvh; bl = Ki;
		mult_8();
		ah = xh; al = xl;
//		ah = 0;
//		al = sdvh >> 1;

		bh = Yh; bl = Yl;
		add16();
		//results in xh:xl

		if ((xh == 0)&&(xl < 128)) {
			// Y < 8 bits, positive
			modY = xl << 1;
			sigY = 0;
		}
		else if ((xh == 0xff)&&(xl > 128)) {
			// Y < 8 bits, negative
			modY = ~xl + 1;
			modY = modY << 1;
			sigY = 1;
		}
		else if (xh & 0x80) {
			// Y negative, saturate
			modY = 255;
			sigY = 1;
		}
		else {
			// Y positive, saturate
			modY = 255;
			sigY = 0;
		}

		// figure out sign & magnitude
/*		if (xh & 0x80) {
			sigY = 1;
			modY = ~xh;
			modY++;		// modY now positive magnitude
			modY = modY << 1;
		}
		else {
			sigY = 0;
			modY = xh << 1;
		}*/

		pwm_setvel_dir(0,modY,sigY);

		putdec(v); ser_tx(' ');
		putdec(dv); ser_tx(' ');
		putdec(d2v); ser_tx(' ');
		putdec(sdvh); ser_tx(' ');
		puthex(xh); //ser_tx(' ');
		puthex(xl); ser_tx(' ');
		puthex(sigY); ser_tx(' ');
		puthex(modY); ser_tx('\r');

		clear_bit(PORTB,0);

		while (TMR0 != 0);
	}
}

